<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class exportArtikelGUI extends exportDefault implements iExport, iGUIHTML2 {

	#private $Kategorien = array();
	
	public function getLabel(){
		return "Artikel";
	}
	
	public function getApps(){
		return array("open3A");
	}

	public function getExportCollection(){
		/*$ac = new anyC();
		$ac->setCollectionOf("Kategorie");
		$ac->addAssocV3("type", "=", "1");

		while($a = $ac->getNextEntry())
			$this->Kategorien[$a->getID()] = $a->A("name");
*/

		$ac = anyC::get("Artikel");
		#$ac->addJoinV3("Kappendix", "AdresseID", "=", "AdresseID");
		#$ac->addAssocV3("AuftragID", "=", "-1");
		$fields = array(
			"artikelnummer AS Artikelnummer",
			"t1.name AS Artikelname",
			"gebinde AS Einheit",
			"preis",
			"EK1 AS EK1",
			"EK2 AS EK2",
			"mwst AS MwSt",
			"beschreibung AS Beschreibung",
			"bemerkung AS Bemerkung",
			"EAN");
		
		$j = 2;
		if(Session::isPluginLoaded("mLieferant")){
			$fields[] = "preisModus";
			$fields[] = "aufschlagListenpreis";
			$fields[] = "aufschlagGesamt";
			$fields[] = "LieferantFirma AS Lieferant";
			$fields[] = "LieferantID";
			$fields[] = "LieferantPreisArtikelnummer AS Lieferantenartikelnummer";
			$fields[] = "LieferantPreisArtikelname AS Lieferantenartikelname";
			$fields[] = "LieferantPreisListenPreis AS Listenpreis";
			$fields[] = "LieferantPreisRabattgruppe AS Rabattgruppe";
			
			$ac->addJoinV3("LieferantPreis", "ArtikelID", "=", "LieferantPreisArtikelID");
			$ac->addJoinV3("LieferantPreis", "LieferantPreisVarianteArtikelID", "=", "0");
			$ac->addJoinV3("Lieferant", "t2.LieferantPreisLieferantID", "=", "LieferantID");
			$ac->addJoinV3("Rabattgruppe", "t2.LieferantPreisRabattgruppe", "=", "RabattgruppeNummer");
			#$ac->addJoinV3("Rabattgruppe", "RabattgruppeLieferantID", "=", "t2.LieferantPreisLieferantID");
			$j += 3;
		}
		
		$KatNum = -1;
		if(Session::isPluginLoaded("Kategorien")){
			$KatNum = count($fields);
			$fields[] = "t$j.name AS Kategorie";
			
			$ac->addJoinV3("Kategorie", "t1.KategorieID", "=", "KategorieID");
			$j += 1;
		}
		
		if(Session::isPluginLoaded("mLager")){
			$fields[] = "SUM(LagerbestandMenge) AS Lagerbestand";
			
			$ac->addJoinV3("Lagerbestand", "t1.ArtikelID", "=", "LagerbestandOwnerClassID");
			$ac->addJoinV3("Lagerbestand", "LagerbestandOwnerClass", "=", "LArtikel");
			$ac->addGroupV3("ArtikelID");
		}
		
		
		$ac->setFieldsV3($fields);
		
		$KID = mUserdata::getUDValueS("exportArtikelKategorieID", "0");
		if($KID != 0)
			$ac->addAssocV3 ("t1.KategorieID", "=", $KID);
		
		$All = new ArrayCollection();
		while($E = $ac->n()){
			$All->add($E);
		}
		
		if(Session::isPluginLoaded("mVariante") AND mUserdata::getUDValueS("exportArtikelVarianten", "0")){
			$VFields = $fields;
			$VFields[0] = "VarianteArtikelNummer AS artikelnummer";
			$VFields[1] = "VarianteArtikelName AS name";
			
			$Varianten = anyC::get("VarianteArtikel");
			$Varianten->addJoinV3("Artikel", "VarianteArtikelArtikelID", "=", "ArtikelID");
			$Varianten->addJoinV3("Lagerbestand", "VarianteArtikelID", "=", "LagerbestandOwnerClassID");
			$Varianten->addJoinV3("Lagerbestand", "LagerbestandOwnerClass", "=", "VarianteArtikel");
			
			$Varianten->addOrderV3("VarianteArtikelArtikelID");
			$Varianten->addAssocV3("ArtikelID", "IS NOT", "NULL");
			$Varianten->addGroupV3("VarianteArtikelID");
			$j = 3;
			
			if(Session::isPluginLoaded("mLieferant")){
				$Varianten->addJoinV3("LieferantPreis", "t2.ArtikelID", "=", "LieferantPreisArtikelID");
				$Varianten->addJoinV3("LieferantPreis", "LieferantPreisVarianteArtikelID", "=", "0");
				$Varianten->addJoinV3("Lieferant", "t4.LieferantPreisLieferantID", "=", "LieferantID");
				$Varianten->addJoinV3("Rabattgruppe", "t4.LieferantPreisRabattgruppe", "=", "RabattgruppeNummer");
				
				$j += 4;
			}
			
			if(Session::isPluginLoaded("Kategorien")){
				$VFields[$KatNum] = "t$j.name AS Kategorie";

				$Varianten->addJoinV3("Kategorie", "t2.KategorieID", "=", "KategorieID");
				$j += 1;
			}
			
			$Varianten->setFieldsV3($VFields);
			
			while($A = $Varianten->n()){
				$Artikel = new Artikel(-1);
				$Artikel->setA($A->getA());
				
				$All->add($Artikel);
			}
		}
		
		$this->hidden = array(
			"preisModus",
			"aufschlagListenpreis",
			"aufschlagGesamt",
			"LieferantID"
		);
		
		return $All;
	}

	public function getHTML($id) {
		T::load(__DIR__, "Exps");
		$ac = anyC::get("Kategorie", "type", "2");
		$ac->addOrderV3("name");
		$options = array();
		$options["0"] = T::_("Alle");
		while($a = $ac->n())
			$options[$a->getID()] = $a->A("name");
		
		$fields = array("KategorieID");
		if(Session::isPluginLoaded("mVariante"))
			$fields[] = "varianten";
		
		$F = new HTMLForm("lexEx", $fields, "Export-Einstellungen");
		$F->setLabel("KategorieID", "Kategorie");
		$F->setType("KategorieID", "select", mUserdata::getUDValueS("exportArtikelKategorieID", "0"), $options);
		$F->getTable()->addColStyle(1, "width:120px;");
		$F->addJSEvent("KategorieID", "onChange", "contentManager.rmePCR('exportArtikel','', 'saveKID', this.value)");
		
		$F->setType("varianten", "checkbox", mUserdata::getUDValueS("exportArtikelVarianten", "0"), $options);
		$F->setLabel("varianten", "Varianten?");
		$F->addJSEvent("varianten", "onChange", "contentManager.rmePCR('exportArtikel','', 'saveVar', \$j(this).prop('checked') ? '1' : '0')");
		
		$F->setDescriptionField("varianten", "Sollen die Varianten berücksichtigt werden?");
		
		return parent::getHTML($id).$F;
	}
	
	public static function saveKID($KID){
		mUserdata::setUserdataS("exportArtikelKategorieID", $KID);

		Red::messageSaved();
	}
	
	public static function saveVar($KID){
		mUserdata::setUserdataS("exportArtikelVarianten", $KID);

		Red::messageSaved();
	}
	
	protected function entryParser(PersistentObject $entry){
		#$entry->changeA("Anrede", Util::formatAnrede("de_DE", $entry, true));

		#if(isset($this->Kategorien[$entry->A("Kategorie")]))
		#	$entry->changeA("Kategorie", $this->Kategorien[$entry->A("Kategorie")]);
		#else $entry->changeA("Kategorie", "");
		$entry->resetParsers();
		$A = $entry->getA();
		$entry->changeA("preis", Util::CLNumberParserZ($entry->getGesamtNettoVK(false, Session::isPluginLoaded("mLieferant") ? $entry->A("LieferantID") : null)));
		$entry->changeA("EK1", Util::CLNumberParserZ($entry->getGesamtEK1(Session::isPluginLoaded("mLieferant") ? $entry->A("LieferantID") : null)));
		$entry->changeA("EK2", Util::CLNumberParserZ($entry->A("EK2")));
		$entry->changeA("MwSt", Util::CLNumberParserZ($entry->A("MwSt")));
		
		if(Session::isPluginLoaded("mLieferant"))
			$entry->changeA("Listenpreis", Util::CLNumberParserZ($entry->A("Listenpreis")));
		
		#unset($A->AdresseID);
		unset($A->ArtikelID);
	}
}
?>
