<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2022, open3A GmbH - Support@open3A.de
 */
if(!defined("PHYNX_USE_TCPDF"))
	define("PHYNX_USE_TCPDF", true);

class PDFMergerMPB extends FPDI {
	function Header() {
		
	}
	
	function Footer() {
		
	}
}

class multiPrintBasketGUI extends UnpersistentClass implements iGUIHTML2 {

	public $hasRechnungsversand = false;
	public $hasStandardversand = false;
	
	public function __construct() {

		$this->customize();
	}

	public static function getButton(){
		$BP = new Button("multiDruck\nListe anzeigen", "liste");
		$BP->editInPopup("multiPrintBasket", -1, "multiDruck-Liste", "", "{width: 800}");
		
		return $BP;
	}
	
	public function addToList($type = null, $fromDate = null, $prefix = null) {
		#$_SESSION["BPS"]->setActualClass(get_class($this));
		$bps = BPS::getAllProperties(get_class($this));#$_SESSION["BPS"]->getAllProperties();
		
		$pSpecData = mUserdata::getPluginSpecificData("Auftraege");
		
		
		$what = $type;
		
		if(isset($bps["add"]) AND $bps["add"] != "") 
			$what = $bps["add"];
			
		if($what === null)
			return;
		
		$bps = $_SESSION["BPS"]->getAllProperties();
		
		$gs = anyC::get("GRLBM");
		if($what != "Kalk") 
			$gs->addAssocV3("is$what","=","1");
		else 
			$gs->addAssocV3("isWhat","=","$what");
		
		$gs->addAssocV3("isPrinted","=","0");
		
		if($what != "M") 
			$gs->addJoinV3("Auftrag", "AuftragID", "=", "AuftragID");
		
		if($what != "M") 
			$gs->addAssocV3("auftragDatum", "IS", "NOT NULL");

		if($what == "R") 
			$gs->addAssocV3("isPayed","!=","2"); //keine stornierten Rechnungen

		if($fromDate != null AND $fromDate != ""){
			$gs->addAssocV3("datum", ">=", Util::CLDateParser($fromDate, "store"));
			BPS::setProperty("mpb", "fromDate", $fromDate);
		} else
			BPS::unsetProperty("mpb", "fromDate");
		
		if($prefix != null AND $prefix != ""){
			$gs->addAssocV3("prefix", "=", $prefix);
			BPS::setProperty("mpb", "prefix", $prefix);
		} else
			BPS::unsetProperty("mpb", "prefix");
		
		if(isset($pSpecData["pluginSpecificCanOnlyEditOwn"])) 
			$gs->addAssocV3("UserID","= ",$_SESSION["S"]->getCurrentUser()->getID());
		
		Aspect::joinPoint("alterQuery", $this, __METHOD__, array($gs));
		
		$newIds = array();
		while(($t = $gs->getNextEntry())){
			if(isset($bps["ids"]) AND strstr($bps["ids"],",,".$t->getID().",,")) 
				continue;
			
			$newIds[] = $t->getID();
		}
		
		BPS::unsetProperty("multiPrintBasketGUI", "add", "");
		BPS::setProperty("multiPrintBasketGUI", "ids", (isset($bps["ids"]) ? $bps["ids"] : ",,").implode(",,", $newIds).(count($newIds) > 0 ? ",," : ""));
	}

	public function emptyList($do = false) {
		//has to do nothing, the list will be emptied via BPS
		if($do)
			BPS::unsetProperty("multiPrintBasketGUI", "ids");
	}
	
	public static function addBeleg($GRLBMID){
		$ids = BPS::getProperty("multiPrintBasketGUI", "ids", ",,");
		BPS::setProperty("multiPrintBasketGUI", "ids", $ids.$GRLBMID.",,");
		
		#$_SESSION["BPS"]->setACProperty("ids",(isset($bps["ids"]) ? $bps["ids"] : ",,").implode(",,",$newIds).(count($newIds) > 0 ? ",," : ""));
		
	}
	
	/**
	 * @return mGRLBMGUI
	 */
	public function getGRLBMS($ignoreAlreadySent = false){
		$gs = anyC::get("GRLBM");
		
		#$_SESSION["BPS"]->setActualClass("multiPrintBasketGUI");
		$bps = BPS::getAllProperties("multiPrintBasketGUI");#$_SESSION["BPS"]->getAllProperties();
		#print_r($bps);
		if(!isset($bps["ids"])) {
			$bps = array();
			$bps["ids"] = ",,";
		}
		$ids = explode(",,",$bps["ids"]);
		$gs->addAssocV3("t1.GRLBMID","=","-1","OR");

		for($i = 1; $i < count($ids) - 1; $i++)
			$gs->addAssocV3("t1.GRLBMID","=",$ids[$i],"OR");

		$gs->addOrderV3("isA", "DESC");
		$gs->addOrderV3("isL", "DESC");
		$gs->addOrderV3("isR", "DESC");
		$gs->addOrderV3("isG", "DESC");
		$gs->addOrderV3("isM", "DESC");
		if(mUserdata::getUDValueS("multiPrintBasketOrder", "0") == 0)
			$gs->addOrderV3("nummer", "ASC");
		if(mUserdata::getUDValueS("multiPrintBasketOrder", "0") == 1)
			$gs->addOrderV3("GRLBMpayedDate", "ASC");

		if($ignoreAlreadySent)
			$gs->addAssocV3 ("isEMailed", "=", "0", "AND", "123");
		
		return $gs;
	}
	
	function getID(){
		return "";
	}
	
	function getHTML($id){
		T::load(__DIR__, "Auftraege");
		
		$bps = $this->getMyBPSData();
		#if($bps != -1 AND isset($bps["add"]) AND $bps["add"] != "")
		#	$this->addToList();
			

		$pSpecData = mUserdata::getPluginSpecificData("Auftraege");

		$BE = new Button("Liste\nleeren","clear", "icon");
		$BE->onclick("contentManager.loadFrame('editDetailsContentmultiPrintBasket','multiPrintBasket','',0,'multiPrintBasketGUI;-');");
		$BE->style("float:right;");
		
		#$BK = new Button("Neue Kalkulationen hinzufügen","kalkulation");
		#$BK->type("icon");
		#$BK->style("float:right;margin-right:3px;");
		#$BK->onclick("contentManager.loadFrame('editDetailsContentmultiPrintBasket','multiPrintBasket','',0,'_multiPrintBasketGUI;add:Kalk');");

		$BM = new Button("Neue Mahnungen hinzufügen", "mahnung", "icon");
		$BM->style("margin-right:5px;");
		#$BM->onclick("contentManager.loadFrame('editDetailsContentmultiPrintBasket','multiPrintBasket','',0,'_multiPrintBasketGUI;add:M');");
		$BM->rmePCR("multiPrintBasket", "-1", "addToList", array("'M'", "\$j('[name=conditionFromDate]').val()", "\$j('[name=conditionPrefix]').val()"), "contentManager.editInPopup('multiPrintBasket','','multiDruck-Liste', '', {width:800});");
		
		$BG = new Button("Neue Gutschriften hinzufügen", "gutschrift", "icon");
		$BG->style("margin-right:5px;");
		#$BG->onclick("contentManager.loadFrame('editDetailsContentmultiPrintBasket','multiPrintBasket','',0,'_multiPrintBasketGUI;add:G');");
		$BG->rmePCR("multiPrintBasket", "-1", "addToList", array("'G'", "\$j('[name=conditionFromDate]').val()", "\$j('[name=conditionPrefix]').val()"), "contentManager.editInPopup('multiPrintBasket','','multiDruck-Liste', '', {width:800});");
		
		$BR = new Button("Neue Rechnungen hinzufügen","rechnung", "icon");
		$BR->style("margin-right:5px;");
		#$BR->onclick("contentManager.loadFrame('editDetailsContentmultiPrintBasket','multiPrintBasket','',0,'_multiPrintBasketGUI;add:R');");
		$BR->rmePCR("multiPrintBasket", "-1", "addToList", array("'R'", "\$j('[name=conditionFromDate]').val()", "\$j('[name=conditionPrefix]').val()"), "contentManager.editInPopup('multiPrintBasket','','multiDruck-Liste', '', {width:800});");
		
		Aspect::joinPoint("buttonRechnungen", $this, __METHOD__, array($BR));
		
		$BL = new Button("Neue Lieferscheine hinzufügen", "lieferschein", "icon");
		$BL->style("margin-right:5px;");
		#$BL->onclick("contentManager.loadFrame('editDetailsContentmultiPrintBasket','multiPrintBasket','',0,'_multiPrintBasketGUI;add:L');");
		$BL->rmePCR("multiPrintBasket", "-1", "addToList", array("'L'", "\$j('[name=conditionFromDate]').val()", "\$j('[name=conditionPrefix]').val()"), "contentManager.editInPopup('multiPrintBasket','','multiDruck-Liste', '', {width:800});");
		
		$BA = new Button("Neue Angebote hinzufügen","angebot", "icon");
		$BA->style("margin-right:5px;");
		#$BA->onclick("contentManager.loadFrame('editDetailsContentmultiPrintBasket','multiPrintBasket','',0,'_multiPrintBasketGUI;add:A');");
		$BA->rmePCR("multiPrintBasket", "-1", "addToList", array("'A'", "\$j('[name=conditionFromDate]').val()", "\$j('[name=conditionPrefix]').val()"), "contentManager.editInPopup('multiPrintBasket','','multiDruck-Liste', '', {width:800});");
		
		#<input type=\"button\" class=\"bigButton backgroundColor2\" value=\"\" style=\"background-image:url(./images/navi/clear.png);\" onclick=\"\" />
		

		$T = new HTMLTable(1);
		$T->addRow(($_SESSION["applications"]->getActiveApplication() == "open3A" ? "
					".(!isset($pSpecData["pluginSpecificCanOnlySeeKalk"]) ? "
					$BM$BG$BR$BL$BA" : "")." " : "")."
					$BE");
		$T->addRowClass("backgroundColor4");
		
		$ID = new HTMLInput("conditionFromDate", "date", BPS::getProperty("mpb", "fromDate"));
		$ID->style("width:100px;text-align:right;");
		
		$IP = new HTMLInput("conditionPrefix", "text", BPS::getProperty("mpb", "prefix"));
		$IP->style("width:50px;");
		
		$T->addRow("<div style=\"width:170px;display:inline-block;\">".T::_("Ab").": ".$ID."</div><div style=\"width:150px;display:inline-block;margin-left:10px;\">".T::_("Präfix").": ".$IP."</div>");
		$T->addRowClass("backgroundColor4");
		
		#$html = $T;
		
		$htmlB = "<table>
			<colgroup>
				<col class=\"backgroundColor3\" />
				<col class=\"backgroundColor2\" style=\"width:25px;\" />
				<col class=\"backgroundColor0\" style=\"width:20px;\" />
			</colgroup>";

		$gs = $this->getGRLBMS();
	
		$BPL = "";
		if($_SESSION["S"]->checkForPlugin("PL")){
			$BPL = new Button("mit PixelLetter\nverschicken","./open3A/PixelLetter/pl.png", "bigButton");
			$BPL->contextMenu("PL", "sendViaMultiPrint", "Versenden via", "right", "up");
			$BPL->loading();
			$BPL->className("backgroundColor2");
			$BPL->style("float:right;");
			#$BPL->onclick("if(confirm('Rechnungen jetzt mit PixelLetter signieren und verschicken?')) ");
			#$BPL->popup("mpbLog", "PL-Versand Logbuch", "multiPrintBasket", "", "sendViaPL");
			#$BPL->rme("multiPrintBasket", "", "sendViaPL","","if(checkResponse(transport)) { Popup.create(12346, \'mpbLog\', \'PL-Versand Logbuch\'); Popup.update(transport, 12346, \'mpbLog\'); }");
		}

		$ids = [];
		while(($t = $gs->getNextEntry())){
			$M = "";
			if($t->getMyPrefix() == "M"){
				$GRLBM = new GRLBM($t->A("AuftragID"));
				$M = $GRLBM->A("nummer")."/";
			}

			if($_SESSION["S"]->checkForPlugin("PL") AND $t->getMyPrefix() != "R")
				$BPL->disabled(true);


			$subFromMultiPrint = "contentManager.loadFrame('editDetailsContentmultiPrintBasket','multiPrintBasket',0,0,'_multiPrintBasketGUI;-ids:".$t->getID()."'); if($('subID".$t->getID()."')) $('subID".$t->getID()."').style.display = 'none'; if($('addID".$t->getID()."')) $('addID".$t->getID()."').style.display = 'block';";

			$OK = "";
			if($t->A("isPrinted"))
				$OK = new Button("Beleg gedruckt","./images/i2/printeds.png", "icon");
				#$OK->type("icon");
				#$OK->rmePCR("multiPrintBasket", "", "setPrinted", $t->getID(), $subFromMultiPrint);#"subFromMultiPrint(\'".$t->getID()."\');"
			


			#$BUP = new Button("Als unerledigt markieren","./images/i2/okCatch.png");
			#$BUP->rmePCR("GRLBM", $t->getID(), "markMeAsUnprinted", "", "contentManager.loadFrame('editDetailsContentmultiPrintBasket','multiPrintBasket');");
			#$BUP->type("icon");
			#<img id=\"printedSymbol".$t->getID()."\" class=\"mouseoverFade\" onclick=\"rme('GRLBM','".$t->getID()."','markMeAsUnprinted','','$(\'printedSymbol".$t->getID()."\').style.display=\'none\';');\" src=\"./images/i2/printeds.png\" title=\"bereits gedruckt (klicken Sie, um den gedruckt-Status wieder aufzuheben)\" />

			$BD = new Button("Von Liste entfernen", "./images/i2/delete.gif", "icon");
			$BD->onclick($subFromMultiPrint);
			
			$htmlB .= "
			<tr>
				<td>".str_replace("Kalk","K",$t->getMyPrefix()).$M.$t->getA()->nummer."</td>
				<td>$OK</td>
				<td>$BD</td>
			</tr>";
			
			$ids[] = $t->getID();
		}

		$BM = new Button("per E-Mail\nverschicken","mail");
		$BM->loading();
		$BM->className("backgroundColor2");
		$BM->onclick("if(confirm('Belege jetzt per E-Mail verschicken?')) ");
		$BM->popup("mpbLog", "E-Mail-Versand Logbuch", "multiPrintBasket", "", "sendVia", "Email");
		#$BM->rme("multiPrintBasket", "", "sendVia","Email","if(checkResponse(transport)) { Popup.create(12345, \'mpbLog\', \'E-Mail-Versand Logbuch\'); Popup.update(transport, 12345, \'mpbLog\'); }");

		#$BP = new Button("Liste als erledigt\nmarkieren","printed");
		#$BP->className("backgroundColor2");
		#$BP->rmePCR("multiPrintBasket", "", "markListAsPrinted","","contentManager.loadFrame('editDetailsContentmultiPrintBasket','multiPrintBasket');");

		$Tab = new HTMLTable(1);

		if($gs->numLoaded() > 0) {
			#windowWithRme('multiPrintBasket', '', 'getFPDF', 'false');
			$BO = new Button("Vorschau\nOriginal", "pdf");
			$BO->windowRme("multiPrintBasket", "", "getFPDF", array("'false'", "\$j('[name=ohneMails]').prop('checked') ? '1' : '0'", "1"));
			$BO->className("backgroundColor2");
			
			$BK = new Button("Vorschau\nKopie", "pdf");
			$BK->windowRme("multiPrintBasket", "", "getFPDF", array("'true'", "\$j('[name=ohneMails]').prop('checked') ? '1' : '0'", "1"));
			$BK->style("float:right;");
			$BK->className("backgroundColor2");
			
			$BS = new Button("Einstellungen", "wrench", "iconicG");
			$BS->onclick("phynxContextMenu.start(this, 'GRLBM','1','Kopie:');");
			$BS->style("float:right;");
			
			$IW = new HTMLInput("ohneMails", "checkbox");
			$IW->style("vertical-align:middle;");
			
			$BPO = new Button("Original\ndrucken", "printer");
			$BPO->onclick(OnEvent::window($this, "getFPDF", array("false", "'+(\$j('[name=ohneMails]').prop('checked') ? '1' : '0')+'", "0"))."contentManager.editInPopup('multiPrintBasket','','multiDruck-Liste', '', {width:800});");#windowRme("multiPrintBasket", "", "getFPDF", array("'false'", "\$j('[name=ohneMails]').prop('checked') ? '1' : '0'", "0"), "", "window", "{onload: function(){ alert('hi'); }}");
			$BPO->className("backgroundColor2");
			$BPO->style("margin-top:10px;");
			
			$BPK = new Button("Kopie\ndrucken", "printer");
			$BPK->windowRme("multiPrintBasket", "", "getFPDF", array("'true'", "\$j('[name=ohneMails]').prop('checked') ? '1' : '0'", "0"));
			$BPK->style("float:right;margin-top:10px;");
			$BPK->className("backgroundColor2");
			
			$Tab->addRow("
				$BK
				$BS
				$BO
				$BPK$BPO<br>$IW ".T::_("Ohne bereits per E-Mail verschickte Belege"));
			
			$Tab->addRowClass("backgroundColor3");

			if(!$this->hasStandardversand){
				$Tab->addRow($BPL.$BM);
				$Tab->addRowClass("backgroundColor3");
			}

			/*if(Session::isPluginLoaded("mESR")){
				$BESR = new Button("ESR-\nDruck", "./open3A/ESR/ESR.png");
				$BESR->windowRme("mESR", "-1", "printESRMultiPrint", $ids);
				$BESR->className("backgroundColor2");
				
				$Tab->addRow($BESR);
				$Tab->addRowClass("backgroundColor3");
			}*/
				
			if($this->hasStandardversand){
				$BD = new Button("Standardversand\nverwenden","daytime");
				$BD->className("backgroundColor2");
				$BD->rme("multiPrintBasket", "", "sendVia","Default","if(checkResponse(transport)) { Popup.create(12345, \'mpbLog\', \'Standard-Versand Logbuch\'); Popup.update(transport, 12345, \'mpbLog\'); }");
				$BD->style("float:left;");
				
				$BDS = $BD->settings("CustomizerStandardversand", "1");
				$BDS->style("margin-left:2px;");
				$BDS->onclick("new Effect.BlindToggle('CustomizerStandardversandSettings');");
				
				$Tab->addRow($BD.  CustomizerStandardversandGUI::getSettings());
				$Tab->addRowClass("backgroundColor3");
			}
			
			$BDP = "";
			if(Session::isPluginLoaded("mDrucker")){
				$BDP = DruckerWindowGUI::getButton("multiPrintBasket", -1, "printEm", "'+(\$j('[name=ohneMails]').prop('checked') ? '1' : '0')+'", true, false);
				$BDP->className("backgroundColor2");
			}
			
			$BE = "";
			if(Session::isPluginLoaded("mEtikette")){
				$BE = Etikette::getButton("multiPrintBasketGUI", "-1");
				$BE->style("float:right;");
				$BE->className("backgroundColor2");
			}
			
			if($BE OR $BDP){
				$Tab->addRow($BE.$BDP);
				$Tab->addRowClass("backgroundColor3");
			}
			
			if(Session::isPluginLoaded("Uebersicht")){
				$IO = new HTMLInput("multiPrintBasketOrder", "select", mUserdata::getUDValueS("multiPrintBasketOrder", "0"), ["Belegnummer", "Bezahlt-Datum"]);
				$IO->style("width:200px;");
				$IO->onchange(OnEvent::rme($this, "saveOrder", ["this.value"], "function(){ contentManager.editInPopup('multiPrintBasket','','multiDruck-Liste', '', {width:800}); }"));

				$Tab->addRow("Sortierung: ".$IO);
				$Tab->addRowClass("backgroundColor4");
			}
		}


		else {
			$htmlB .= "
		<tr>
			<td colspan=\"4\">".T::_("keine Einträge")."</td>
		</tr>";
		}

		$htmlB .= "</table>";


		$html = "<div style=\"width:400px;vertical-align:top;display:inline-block;overflow:auto;max-height:500px;\">$htmlB</div><div style=\"width:400px;vertical-align:top;display:inline-block;\">$T$Tab</div>";

		return $html;
	}
	
	public function saveOrder($order){
		mUserdata::setUserdataS("multiPrintBasketOrder", $order);
	}

	public function setPrinted($GRLBMID){
		$G = new GRLBM($GRLBMID);
		$G->changeA("isPrinted", "1");
		$G->changeA("isPrintedTime", time());
		$G->saveMe();
	}

	public function markListAsPrinted(){
		$gs = $this->getGRLBMS();
		while(($t = $gs->getNextEntry()))
			$t->markMeAsPrinted();
			
		echo $gs->numLoaded();
	}
	
	function printEm($ignoreAlreadySent, $copy, $die = true){
		try {
			$drucker = mDrucker::getStandardPrinter($copy == "true" ? true : false);
		} catch (NoStandardPrinterInstalledException $e){
			echo -1;
			return -1;
		}

		$filename = $this->getFPDF($copy, $ignoreAlreadySent, false, true);

		$drucker->makePaper($filename, true);
		
		if($die)
			Red::messageD("Druckauftrag übergeben");
	}
	
	public function sendVia($mode){
		$U = new Util();
		$gs = $this->getGRLBMS();

		$defaults = array();
		$defaults["A"] = mUserdata::getUDValueS("CustomVersandA", "none");
		$defaults["L"] = mUserdata::getUDValueS("CustomVersandL", "none");
		$defaults["R"] = mUserdata::getUDValueS("CustomVersandR", "none");
		$defaults["G"] = mUserdata::getUDValueS("CustomVersandG", "none");
		$defaults["M1"] = mUserdata::getUDValueS("CustomVersandM1", "none");
		$defaults["M2"] = mUserdata::getUDValueS("CustomVersandM2", "none");
		$defaults["M3"] = mUserdata::getUDValueS("CustomVersandM3", "none");
		
		while($GRLBM = $gs->getNextEntry()){
			
			$AuftragID = $GRLBM->getA()->AuftragID;
			$M = "";
			if($GRLBM->getMyPrefix() == "M") {
				$G = new GRLBM($GRLBM->A("AuftragID"));
				$AuftragID = $G->A("AuftragID");
				$M = $G->A("nummer")."/";
			}
			
			$A = new AuftragGUI($AuftragID);
			switch($mode){
				case "Email":
					$U->logStatusMessages(array($GRLBM->getMyPrefix().$M.$GRLBM->A("nummer")), $A, "sendViaEmail", array($GRLBM->getID(), "", "", "", false));
				break;

				case "Default":
					$prefix = $GRLBM->getMyPrefix();
					if($prefix == "M")
						$prefix .= $GRLBM->A("nummer");
					
					if($defaults[$prefix] != "none")
						$U->logStatusMessages(array($GRLBM->getMyPrefix().$M.$GRLBM->A("nummer")), $A, "sendGRLBMToCustomer", array($GRLBM->getID(), $defaults[$prefix], false));
					else
						$U->logStatusMessages(array($GRLBM->getMyPrefix().$M.$GRLBM->A("nummer")), $this, "noDefault", array());
					
				break;
			}
		}
		$tab = $U->getStatusMessagesLog(2);
		$tab->setColWidth(1, 80);
		echo "<div style=\"overflow:auto;max-height:500px;\">".$tab."</div>";
	}
	
	public function noDefault(){
		throw new Exception("Kein Standardversand");
	}
	
	public function sendViaPL($mode){
		echo "<p class=\"prettyTitle\">PixelLetter-Versand</p>";
		$U = new Util();
		$gs = $this->getGRLBMS();

		while($GRLBM = $gs->getNextEntry()){
			if($GRLBM->getMyPrefix() != "R") continue;
			
			$AuftragID = $GRLBM->getA()->AuftragID;
			$_SESSION["BPS"]->registerClass("Brief");
			$_SESSION["BPS"]->setProperty("Brief","GRLBMID",$GRLBM->getID());
			
			
			if($mode == "Brief")
				$U->logStatusMessages(array($GRLBM->getMyPrefix().$GRLBM->A("nummer")), new Auftrag($AuftragID), "sendViaMail", array($GRLBM->getID(), false, ""));
			
			if($mode == "Einschreiben" OR $mode == "Einschreiben,Rückschein")
				$U->logStatusMessages(array($GRLBM->getMyPrefix().$GRLBM->A("nummer")), new Auftrag($AuftragID), "sendViaMail", array($GRLBM->getID(), false, $mode));
			
			if($mode == "EMail")
				$U->logStatusMessages(array($GRLBM->getMyPrefix().$GRLBM->A("nummer")), new Auftrag($AuftragID), "signLetter", array($GRLBM->getID(), "", "", "", false));
		}
		
		echo $U->getStatusMessagesLog(2);
	}
	
	public function getFPDF($copy, $ignoreAlreadySent = false, $getPreview = false, $save = false){
		$fpdi = new PDFMergerMPB();
		
		$AC = $this->getGRLBMS($ignoreAlreadySent);
		$i = 0;
		while($t = $AC->n()){
			$AuftragID = $t->A("AuftragID");
			if($t->getMyPrefix() == "M") {
				$GRLBM = new GRLBM($t->A("AuftragID"));
				$AuftragID = $GRLBM->A("AuftragID");
			}
			
			$A = new Auftrag($AuftragID);
			$brief = $A->getLetter("", $copy == "true", $t->getID(), false, null, $getPreview);
			$file = $brief->generate(true);
			
			$count = $fpdi->setSourceFile($file);
			for ($i = 1; $i <= $count; $i++) {
				$template = $fpdi->importPage($i, "/MediaBox");
				$fpdi->AddPage();
				$fpdi->useTemplate($template, 0, 0, 210);
			}
			
			unlink($file);
			
			if(!$getPreview)
				$t->markMeAsPrinted();
			
			if(Session::isPluginLoaded("mESR") AND $t->getMyPrefix() == "R"){
				$ESR = new mESRGUI();
				$file = $ESR->printESR($t->A("GRLBMID"), false);
				$count = $fpdi->setSourceFile($file);
				for ($i = 1; $i <= $count; $i++) {
					$template = $fpdi->importPage($i, "/MediaBox");
					$fpdi->AddPage();
					$fpdi->useTemplate($template, 0, 0, 210);
				}
			}
			
		}
		
		Aspect::joinPoint("after", $this, __METHOD__, array($fpdi));
		
		$filename = Util::getTempDir()."/Belege_".date("Ymd_His").".pdf";
		$fpdi->Output($filename, "F");
		if($save)
			return $filename;
		
		Util::PDFViewer($filename);
	}
	
	public function getEtiketten(){
		$array = array();
		$AC = $this->getGRLBMS();
		
		while($G = $AC->getNextEntry()){
			$a = $G->getEtiketten();
			$array[] = $a[0];
		}

		return $array;
	}
}
?>