<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2022, open3A GmbH - Support@open3A.de
 */
class mPostenGUI extends mPosten implements iGUIHTML2, icontextMenu {

	public $CustomizerPostenPercentGUI = false;
	public $additionalCalculatorFields = "";
	public $showRabatt = false;
	public $showPostenTable = true;
	private $GRLBM;
	
	
	function __construct(){
		$this->setParser("menge","Util::CLNumberParserZ");
		$this->setParser("preis","Util::CLNumberParserZ");
		$this->setParser("EK1","Util::CLNumberParserZ");
		$this->setParser("EK2","Util::CLNumberParserZ");
		parent::__construct();
	}
	
	public static function getNewPostenButton($GRLBMID, $kundennummer, $lieferantennummer = null){
		$addBPS = "addBefore:-1";
		$addBPS .= (($kundennummer != "" AND $kundennummer > 0) ? ";kundennummer:$kundennummer" : "");
		$addBPS .= (($lieferantennummer != null AND $lieferantennummer != "0") ? ";lieferantFilter:$lieferantennummer" : "");
		
		$BPosten = new Button("Artikel\nhinzufügen", "package");
		$BPosten->customSelect("contentRight", $GRLBMID, "mArtikel", "Auftrag.addArtikel", $addBPS);
		$BPosten->id("grlbmAddArtikel");
		
		return $BPosten;
	}
	
	public static function getNew1PostenButton(){
		// <editor-fold defaultstate="collapsed" desc="Aspect:jP">
		try {
			$MArgs = func_get_args();
			return Aspect::joinPoint("around", __CLASS__, __METHOD__, $MArgs);
		} catch (AOPNoAdviceException $e) {}
		Aspect::joinPoint("before", __CLASS__, __METHOD__, $MArgs);
		// </editor-fold>
		
		$B1Posten = new Button("1x-Posten\nhinzufügen", "1xPosten");
		$B1Posten->onclick("contentManager.editInPopup('Posten', '-1', '".T::_("Posten bearbeiten")."');");
		$B1Posten->id("grlbmAdd1xPosten");
		
		return $B1Posten;
	}
	
	function getHTML($id){
		T::load(__DIR__, "Auftraege");
		$bps = $this->getMyBPSData();
		$this->GRLBM = $GRLBM = new GRLBM($bps["loadGRLBMID"]);
		
		$pSpecData = mUserdata::getPluginSpecificData("Auftraege");
		/*if(isset($pSpecData["pluginSpecificRLocksAuftrag"]) AND $GRLBM->getMyPrefix() != "R"){
			$AC = anyC::get("GRLBM", "AuftragID", $GRLBM->A("AuftragID"));
			$AC->addAssocV3("isR", "=", "1");
			$AC->setLimitV3(1);
			$R = $AC->n();
			if($R)
				$GRLBM->changeA("isPayed", "1");
		}*/
		
		// <editor-fold defaultstate="collapsed" desc="Aspect:jP">
		try {
			$MArgs = array($id, $GRLBM);
			return Aspect::joinPoint("around", $this, __METHOD__, $MArgs);
		} catch (AOPNoAdviceException $e) {}
		Aspect::joinPoint("before", $this, __METHOD__, $MArgs);
		// </editor-fold>

		$ud = new mUserdata();
		$aT = $ud->getUDValue("GRLBMAnsicht");
		
		if($aT == null)
			$view = "2";
		else $view = $aT;
		
		$Stammdaten = mStammdaten::getActiveStammdaten();
		try {
			$CurrentVorlage = $Stammdaten->A("ownTemplate");
			$Vorlage = new $CurrentVorlage($Stammdaten);
		} catch (ClassNotFoundException $e){
			$Vorlage = new Vorlage_de_DE_leer($Stammdaten);
		}

		$showPrices = true;
		if(in_array($GRLBM->getMyPrefix(), $Vorlage->sumHideOn))
			$showPrices = false;
		
		$message = array();
		$message["R"] = T::_("Diese Rechnung wurde als gedruckt/verschickt/bezahlt markiert und kann daher nicht mehr bearbeitet werden.");
		$message["G"] = T::_("Diese Gutschrift wurde als gedruckt/verschickt/bezahlt markiert und kann daher nicht mehr bearbeitet werden.");
		$message["B"] = T::_("Diese Auftragsbestätigung wurde gesperrt.");
		$message["A"] = T::_("Für dieses Angebot wurde eine Auftragsbestätigung erstellt. Die Posten können daher nicht mehr verändert werden.");
		$message["L"] = T::_("Dieser Lieferschein wurde gesperrt.");
		$message["T"] = T::_("Diese Stornorechnung wurde als gedruckt/verschickt/bezahlt markiert und kann daher nicht mehr bearbeitet werden.");
		
		$message = Aspect::joinPoint("messages", $this, __METHOD__, array($message, $GRLBM), $message);
		
		if($bps["GRLBMType"] == "Kalk" AND $view < 3) $view = 3;
		#print_r($this->getMyBPSData());
		$this->setAssocV3("GRLBMID","=",$bps["loadGRLBMID"]);
		
		$tempPosten = new Posten(-1);
		$PostenAttributes = $tempPosten->newAttributes();
		
		//Be sure this field exists else the Rechnung will show 0,00€ total
		if(!isset($PostenAttributes->bruttopreis))
			throw new FieldDoesNotExistException("bruttopreis","");
		
		unset($tempPosten);
		$PostenAttributes = PMReflector::getAttributesArrayAnyObject($PostenAttributes);
		#unset($PostenAttributes[array_search("createArtikel", $PostenAttributes)]);
		$PostenAttributes[] = "menge AS mengeUnparsed";
		$PostenAttributes[] = "preis AS preisUnparsed";
		$PostenAttributes[] = "EK1 AS EK1Unparsed";
		$PostenAttributes[] = "EK2 AS EK2Unparsed";
		$PostenAttributes[] = "mwst AS mwstUnparsed";
		if(in_array("rabatt", $PostenAttributes))
			$PostenAttributes[] = "rabatt AS rabattUnparsed";
		
		$this->setFieldsV3($PostenAttributes);
		Aspect::joinPoint("alter", $this, __METHOD__, array());

		$Auftrag = new Auftrag($GRLBM->A("AuftragID"));
		
		if($this->A == null)
			$this->lCV3($id);
		
		$userLabels = mUserdata::getRelabels("Artikel");
		$userHiddenFields = mUserdata::getHides("Artikel");

		$gui = new HTMLGUI();
		$gui->setObject($this);
		$gui->customize($this->customizer);


		$BPosten = self::getNewPostenButton($bps["loadGRLBMID"], $Auftrag->A("kundennummer"), $Auftrag->A("lieferantennummer"));
		#$BPosten->style("margin-left:10px;");

		$B1Posten = self::getNew1PostenButton();
		#$B1Posten->settings("mPosten", "100:$bps[loadGRLBMID]");

		$L = new HTMLList();
		$L->setItemsStyle("display:inline-block;margin-top:0px;margin-right:15px;vertical-align:top;margin-left:0;");
	
            	/* Posten bearbeiten selbst hinzugefügt umgebaut neuer Eintrag besser */
                $L->addListStyle("list-style-type:none; position:absolute; bottom:547px; ");


 /*		$L->addListStyle("list-style-type:none;"); */

		$L->addItem($BPosten);
		$L->addItem($B1Posten);
				
		if(Session::isPluginLoaded("mTimeular") AND $Auftrag->A("kundennummer") > 0){
			$K = Kappendix::getKappendixToKundennummer($Auftrag->A("kundennummer"));

			if($K->A("KappendixTimeularActivity") != ""){
				#$data = json_decode(base64_decode($K->A("KappendixTimeularActivity")));
				$BTI = new Button("Zeiten\nhinzufügen", "./open3A/Timeular/Timeular.svg");
				$BTI->popup("", "Zeiten importieren", "Timeular", -1, "importTimesPopup", [$GRLBM->getID()]);

				$L->addItem($BTI);
			}
		}
		
		Aspect::joinPoint("PostenSideTable", $this, __METHOD__, array($GRLBM, $L, $Auftrag));
		
		
		$IMenge = new HTMLInput("addPostenFromArtikelMenge", "text", "1");
		$IMenge->style("width:25px;text-align:right;margin-right:5px;");
		$IMenge->onEnter("\$j('[name=addPostenFromArtikel]').trigger('focus');");
		
		$IPosten = new HTMLInput("addPostenFromArtikel");
		$IPosten->placeholder("Artikelsuche...");
		$IPosten->style("width:100px;");
		$IPosten->autocomplete("mArtikel", "function(selection){ if(!selection) return; Auftrag.addArtikel('".$bps["loadGRLBMID"]."', selection.ArtikelID, function(){ \$j('[name=addPostenFromArtikel]').trigger('focus'); }, \$j('[name=addPostenFromArtikelMenge]').val()) }");
		$IPosten->onkeyup("if(event.keyCode == 38 || event.keyCode == 40) Auftrag.skipEnter = true; else if(event.keyCode != 13) Auftrag.skipEnter = false; if(event.keyCode == 13 && !Auftrag.skipEnter) ".OnEvent::rme($this, "findArtikel", array("this.value"), "function(t){ if(t.responseText == '') return; Auftrag.addArtikel('".$bps["loadGRLBMID"]."', t.responseText, function(){ \$j('[name=addPostenFromArtikel]').trigger('focus'); }, \$j('[name=addPostenFromArtikelMenge]').val()) }"));
		$L->addItem("<div style=\"margin-top:10px;\">$IMenge$IPosten</div>");

		
		$T = "";
		if($this->showPostenTable)
			if(!$GRLBM->isLocked()) 
				$T .= "<div style=\"padding-left:10px;\" class=\"AuftragBelegContent\">".$L."</div>";
			else{
				$unlock = "";
				if(isset($pSpecData["pluginSpecificCanRemovePayed"]))
					$unlock = "<span style=\"float:right;\"><a href=\"#\" onclick=\"".OnEvent::rme($GRLBM, "unlock", "", "function(){ Auftrag.reloadBeleg(".$GRLBM->getID().") }")." return false;\" style=\"color:grey;\">Markierung aufheben</a></span>";
				
				$T .= "<p class=\"highlight\" style=\"margin-right:10px;\">$unlock".$message[$bps["GRLBMType"]]."</p>";
			}
		
		$BOP = new Button("Operationen", "wrench", "iconicG");
		$BOP->onclick("phynxContextMenu.start(this, 'mPosten','100:$bps[loadGRLBMID]','".T::_("Optionen anzeigen").":');");
		$BOP->style("margin-top:5px;margin-left:5px;");
		
		$html = Aspect::joinPoint("prepend", $this, __METHOD__, $MArgs, "")."<div style=\"clear:right;padding-top:60px;\" class=\"prettySubtitle\"> ".T::_("Posten von")." ".$GRLBM->A("prefix").$GRLBM->A("nummer")."$BOP</div>$T<div class=\"Tab backgroundColor1\" style=\"font-weight:bold;\"><p>".T::_(Stammdaten::getLongType($bps["GRLBMType"],true)."posten").":"."</p></div>";

		#$tabC1 = new HTMLTable(2);
		#$tabC1->addTableClass("AuftragBelegContent");
		#$tabC1->setColWidth(1, 120);
		
		#$tabC2 = new HTMLTable(2);
		#$tabC2->setColWidth(1, 120);
		#$tabC2->setTableStyle("width:530px;");
		#$tabC2->addTableClass("AuftragBelegContent");
		#$tabC2->addColStyle(2, "text-align:right");
		#$tabC2->addColStyle(3, "text-align:right");
		$divC1  = "";
		$divC2 = "";
		if($this->numLoaded() == 0 OR $view > 2){
			$ICO = array();
			$BelegArten = Auftrag::getBelegArten(null, true);
			if(Applications::activeApplication() == "openWaWi"){
				$BelegArten = LBestellungGUI::getBelegArten(null, true);
				$BelegArten[] = "B";
				$BelegArten[] = "A";
				$BelegArten = array_unique($BelegArten);
			}
			
			foreach($BelegArten AS $B){
				if(isset($pSpecData["pluginSpecificCantCreate$B"]))
					continue;
				
				$ICO[$B] = new HTMLInput(T::_(Stammdaten::getLongType($B)), "option", $B);
			}

			$IC = new HTMLInput("CopyPostenDD", "select", "A", $ICO);
			$IC->style("width:calc(100% - 40px);margin-top:5px;");
			$IC->id("CopyPostenDD");

			$ICN = new HTMLInput("CopyPostenNumer");
			$ICN->style("width:120px;margin-top:5px;");
			$ICN->placeholder("Belegnummer");
			$ICN->id("CopyPostenNumer");
			$ICN->onEnter("Auftrag.copyPostenByTypeAndNumber($('CopyPostenNumer').value, $('CopyPostenDD').value, '".$GRLBM->getID()."', 'subframe');");

			#$BCS = new Button("Posten aus diesem Beleg kopieren","seiten", "icon");
			#$BCS->style("float:left;margin-right:10px;");
			#$BCS->onclick("Auftrag.copyPostenByTypeAndNumber($('CopyPostenNumer').value, $('CopyPostenDD').value, '".$GRLBM->getID()."', 'subframe');");

			$BSa = new Button("Posten kopieren","seiten", "icon");
			$BSa->style("float:right;margin-top:5px;");
			$BSa->onclick("Auftrag.copyPostenByTypeAndNumber($('CopyPostenNumer').value, $('CopyPostenDD').value, '".$GRLBM->getID()."', 'subframe');");
			
			$BD = "";
			if($this->numLoaded() != 0) {
				$BD = new Button("Belege aus diesem Auftrag anzeigen", "down", "icon");
				$BD->style("float:right;");
				$BD->onclick("\$j('#copyList').slideToggle();");
			}
			
			$divC1 = "<div style=\"margin-left:10px;margin-top:10px;\">";
			
			$add = Aspect::joinPoint("addContainer", $this, __METHOD__, [$GRLBM]);
			if(is_array($add))
				$divC1 .= implode("", $add);
			else
				$divC1 .= $add;
			
			#$tabC1->addRow(array(""));
			#$tabC1->addRowClass("backgroundColor0");
			
			#$tabC1->addRow(array("Belegdaten übernehmen"));
			#$tabC1->addRowClass("backgroundColor0");
			#$tabC1->addRowColspan(1, 2);
			
			#$tabC1->addLV("Kopieren aus:", "$BSa$BD $IC $ICN");
			#$tabC1->addRowColspan(1, 2);
			$divC1 .= $this->belegAction("Posten kopieren", "$BSa$BD $IC $ICN");
			
			if(Session::isPluginLoaded("mGaeb") AND $GRLBM->getMyPrefix() != "O"){
				$FUGL = new HTMLInput("UGLUpload", "file");
				$FUGL->onchange(OnEvent::popup("UGL-Import", "Gaeb", "-1", "importToBelegPopup", array("fileName", $GRLBM->getID())));
				#$tabC1->addLV("UGL-Datei:", $FUGL);
				
				$divC1 .= $this->belegAction("UGL-Datei importieren", $FUGL);
			}
			
			if(Session::isPluginLoaded("mGaeb") AND ($GRLBM->getMyPrefix() == "P" OR $GRLBM->getMyPrefix() == "A") AND $this->numLoaded() == 0){
				$FUGL = new HTMLInput("X83Upload", "file");
				$FUGL->onchange(OnEvent::popup("X83 Import", "mGaeb", "-1", "X83", array("fileName", $GRLBM->getID()), "", "{width:900, top:20}"));
				#$tabC1->addLV("X83-Datei:", $FUGL);
				
				$divC1 .= $this->belegAction("X83-Datei importieren", $FUGL);
			}
		
			if(Session::isPluginLoaded("mImportExcel")){
				$FUGL = new HTMLInput("ExcelUpload", "file");
				$FUGL->onchange(OnEvent::popup("Excel-Import", "ImportExcel", "-1", "importToBelegPopup", array("fileName", $GRLBM->getID()), "", "{width:600}"));
				#$tabC1->addLV("Excel-Datei:", $FUGL);
				
				$divC1 .= $this->belegAction("Excel-Datei importieren", $FUGL);
			}
			
			if(Session::isPluginLoaded("mLager") AND $GRLBM->getMyPrefix() != "O" AND !Session::isPluginLoaded("mLagerbestandWare")){
				$IL = new HTMLInput("lager", "select", mUserdata::getUDValueS("userMainLager", "0"));
				$LD = anyC::getFirst("Lager", "LagerIsHauptlager", "1");
				
				$IL->setOptions(anyC::get("Lager"), "LagerName", T::_("Standardlager").($LD ? " (".$LD->A("LagerName").")" : ""), array("-1" => T::_("Ohne Lagerbuchung")));
				$IL->onchange(OnEvent::rme("mUserdata", "setUserdata", array("'userMainLager'", "this.value")));
				#$tabC1->addLV("Entnahme aus:", $IL);
				
				$divC1 .= $this->belegAction(T::_("Warenentnahme aus"), $IL);
			}
			
			if(Session::isPluginLoaded("mEingangsbeleg") AND Session::isPluginLoaded("mProjekt")){
				$AC = anyC::get("Eingangsbeleg", "EingangsbelegOriginClass", "Projekt");
				$AC->addAssocV3("EingangsbelegOriginClassID", "=", $Auftrag->A("ProjektID"));
				$AC->setLimitV3(1);
				$E = $AC->n();
				
				$BE = new Button("Belege\nanzeigen", "./openFiBu/Eingangsbeleg/Eingangsbeleg.png");
				$BE->popup("", "Eingangsbelege", "mEingangsbeleg", -1, "addToRechnungPopup", array("'Projekt'", $Auftrag->A("ProjektID"), $GRLBM->getID()));
				$divC1 .= $this->belegAction("Eingangsrechnungen", !$E ? "Keine Belege" : $BE);
			}
			
			if(Session::isPluginLoaded("mBelegvorlage")){
				$IGo = new Button("Vorlage verwenden", "navigation", "icon");
				$IGo->style("float:right;margin-top:5px;");
				$IGo->rmePCR("Belegvorlage", "'+\$j('[name=useBelegvorlageID]').val()+'", "addPostenToBeleg", array("'".$GRLBM->getID()."'"), OnEvent::frame("subframe", "GRLBM", $GRLBM->getID()));
				
				$Vs = array(0 => "Bitte auswählen...");
				$AC = anyC::get("Belegvorlage");
				$AC->addOrderV3("BelegvorlageName");
				while($V = $AC->n())
					$Vs[$V->getID()] = $V->A("BelegvorlageName");
				
				
				$IV = new HTMLInput("useBelegvorlageID", "select", 0, $Vs);
				$IV->style("width:calc(100% - 40px);margin-top:5px;");
				
				$divC1 .= $this->belegAction("Vorlagen", "$IGo$IV");
			}
			
			if(Session::isPluginLoaded("Abschlussrechnung") AND ($GRLBM->getMyPrefix() == "R" OR $GRLBM->getMyPrefix() == "L") AND $this->numLoaded() == 0){
				#$tabC1->addRow(array("",""));
				#$tabC1->addRowClass("backgroundColor0");
			
				$Belege = anyC::get("GRLBM");
				$Belege->addAssocV3("AuftragID", "=", $GRLBM->A("AuftragID"));
				$Belege->addAssocV3("GRLBMID", "!=", $GRLBM->getID());
				$Belege->addAssocV3("isB", "=", "1");
				$Belege->addOrderV3("datum", "DESC");
			
				$Bel = array("0" => T::_("Bestätigung auswählen"));
				while($B = $Belege->getNextEntry())
					$Bel[$B->getID()] = $B->getMyPrefix().$B->A("nummer")." vom ".Util::CLDateParser($B->A("datum")).", ".Util::CLFormatCurrency($B->A("bruttobetrag") * 1, true);
				$Bel["-1"] = T::_("ohne Bestätigung");
				
				$IL = new HTMLInput("abschlagsrechnungBeleg", "select", "0", $Bel);
				$IL->style("width:calc(100% - 40px);margin-top:5px;");
				$IL->id("abschlagsrechnungBeleg");
				
				$IV = new HTMLInput("abschlagsrechnungProzent", "text", "50");
				$IV->style("margin-left:10px;width:40px;text-align:right;margin-top:5px;");
				$IV->id("abschlagsrechnungProzent");
				
				$IA = new HTMLInput("abschlagsrechnungAbsolut", "text", "");
				$IA->style("width:50px;text-align:right;margin-top:5px;");
				$IA->id("abschlagsrechnungAbsolut");
				
				
				$IGo = new Button("Abschlagsrechnung erstellen", "navigation", "icon");
				$IGo->style("float:right;margin-top:5px;");
				$IGo->id("abschlagsrechnungLos");
				$IGo->rmePCR("Abschlagsrechnung", "-1", "createNewFromBeleg", array("\$j('#abschlagsrechnungBeleg').val()", $GRLBM->getID(), "\$j('#abschlagsrechnungProzent').val()", "\$j('#abschlagsrechnungAbsolut').val()"), OnEvent::frame("subframe", "GRLBM", $GRLBM->getID()));
				
				$format = Util::getLangCurrencyFormat();
				#$tabC1->addLV("Abschlagsre.:", );
				$divC1 .= "<br>";
				if($GRLBM->getMyPrefix() == "R")
					$divC1 .= $this->belegAction(T::_("Abschlagsrechnung erstellen"), $IGo.$IL.$IV."% <span style=\"color:grey;\">oder</span> $IA$format[0]<br /><small style=\"color:grey;\">".T::_("Eine Abschlagsrechnung ist für die Zahlung eines bestimmten Betrags.")."</small>");
				
				$IL = new HTMLInput("teilrechnungBeleg", "select", "0", $Bel);
				$IL->style("width:calc(100% - 40px);margin-top:5px;");
				$IL->id("teilrechnungBeleg");
				
				$labelTeilrechnung = "Teilrechnung";
				$labelSchlussrechnung = "Schlussrechnung";
				$descSchluss = "Von diesem Beleg werden Abschlags- und Teilrechnungen abgezogen.";
				if($GRLBM->getMyPrefix() == "L"){
					$labelTeilrechnung = "Teillieferschein";
					$labelSchlussrechnung = "Schlusslieferschein";
					$descSchluss = "Von diesem Beleg werden und Teillieferscheine abgezogen.";
				}
				
				$IGo = new Button("$labelTeilrechnung erstellen", "navigation", "icon");
				$IGo->style("float:right;margin-top:5px;");
				$IGo->id("teilrechnungLos");
				$IGo->rmePCR("Teilrechnung", "-1", "createNewFromBeleg", array("\$j('#teilrechnungBeleg').val()", $GRLBM->getID()), OnEvent::frame("subframe", "GRLBM", $GRLBM->getID()));
				
				#$tabC1->addLV("Teilrechnung:", $IGo.$IL."<br /><small style=\"color:grey;\">Eine Teilrechnung enthält bestimmte Positionen des Gesamtauftrags.</small>");
				$divC1 .= $this->belegAction(T::_("$labelTeilrechnung erstellen"), $IGo.$IL."<br><small style=\"color:grey;\">".T::_("Enthält bestimmte Positionen des Gesamtauftrags.")."</small>");
						
				$IL = new HTMLInput("abschlussrechnungBeleg", "select", "0", $Bel);
				$IL->style("width:calc(100% - 40px);margin-top:5px;");
				$IL->id("abschlussrechnungBeleg");
				
				$IGo = new Button("$labelSchlussrechnung erstellen", "navigation", "icon");
				$IGo->style("float:right;margin-top:5px;");
				$IGo->id("abschlussrechnungLos");
				$IGo->rmePCR("Abschlussrechnung", "-1", "createNewFromBeleg", array("\$j('#abschlussrechnungBeleg').val()", $GRLBM->getID()), OnEvent::frame("subframe", "GRLBM", $GRLBM->getID()));
				
				#$tabC1->addLV("Schlussre.:", $IGo.$IL."<br /><small style=\"color:grey;\">Von der Schlussrechnung werden Abschlags- und Teilrechnungen abgezogen.</small>");
				$divC1 .= $this->belegAction(T::_("$labelSchlussrechnung erstellen"), $IGo.$IL."<br><small style=\"color:grey;\">".T::_($descSchluss)."</small>");
			}
			
			$divC1 .= "</div>";#.OnEvent::script("console.log(\$j('.AuftragBelegAction').map(function(){ return \$j(this).height(); })); \$j('.AuftragBelegAction').css('height', Math.max.apply(null, \$j('.AuftragBelegAction').map(function(){ return \$j(this).height(); }).get())+'px');");
			
			$Belege = $this->getCopyBelege($GRLBM);
		
			if($Belege->numLoaded() > 0){
				$BC = new Button("Auswahl\nkopieren", "seiten");#OnEvent::rme($GRLBM, "copyFromMulti", array("joinFormFieldsToString('AuftragCopyBelege')"))
				$BC->rmePCR("GRLBM", $GRLBM->getID(), "copyPostenFromMulti", array("joinFormFieldsToString('AuftragCopyBelege')"), "function(){ contentManager.loadFrame('subframe', 'GRLBM', ".$GRLBM->getID()."); }");
				$BC->style("margin-right:5px;");
				$BC->disabled(true);
				$BC->id("AuftragCopyBelegeButton");
				$BC->className("backgroundColor0");
				
				$BI = new Button("Alle\nauswählen", "new");
				$BI->style("margin-right:10px;");
				$BI->onclick("\$j('#AuftragCopyBelege input').prop('checked', true).trigger('change');");
				$BI->className("backgroundColor0");
				
				$BN = new Button("Keinen\nauswählen", "clear");
				$BN->style("margin-right:10px;");
				$BN->onclick("\$j('#AuftragCopyBelege input').prop('checked', false).trigger('change');");
				$BN->className("backgroundColor0");
				
				#$tabC2->addRow(array("",""));
				#$tabC2->addRowClass("backgroundColor0");
				$divC2 = "<div class=\"spell\"><p class=\"backgroundColor3\">";
				if($GRLBM->getMyPrefix() != "O" AND $GRLBM->getMyPrefix() != "P")
					$divC2 .= T::_("Posten aus Beleg aus diesem Auftrag kopieren");
				else
					$divC2 .= T::_("Aktuelle Angebote und Auftragsbestätigungen");
				
				
				$divC2 .= "</p><div class=\"backgroundColor4\" style=\"margin-bottom:10px;padding:5px;\">$BI$BN$BC<div style=\"clear:both;\"></div></div><div style=\"max-height:300px;overflow:auto;\"><form id=\"AuftragCopyBelege\">";
				#$tabC2->addRowClass("backgroundColor0");
				#$tabC2->addRowColspan(1, 2);
			}
			
			while($B = $Belege->getNextEntry()){
				$B->resetParsers();
				
				
				#$BCS = new Button("Posten aus diesem Beleg kopieren", "seiten", "icon");
				#$BCS->className("copyFromButton");
				#$BCS->style("float:right;margin-left:10px;");
				#$BCS->onclick("Auftrag.copyPostenFrom('".$B->getID()."','".$GRLBM->getID()."','','subframe');");

				$auftragName = "";
				if($B->A("AuftragID") != $GRLBM->A("AuftragID")){
					$Auftrag = new Auftrag($B->A("AuftragID"));
					$Adresse = new Adresse($Auftrag->A("AdresseID"));
					
					$auftragName = $Adresse->getShortAddress();
				}
				
				$divC2 .= mGRLBMGUI::belegBox($B, $GRLBM, "Auftrag.copyPostenFrom('".$B->getID()."','".$GRLBM->getID()."','','subframe');", $auftragName, "if(\$j('#AuftragCopyBelege input:checked').length) \$j('#AuftragCopyBelegeButton').prop('disabled', false).addClass('highlight'); else \$j('#AuftragCopyBelegeButton').prop('disabled', true).removeClass('highlight');");
				
				#$pre = $B->getMyPrefix();
				#$tabC2->addRow(array(
				#	"<label>".$pre[0].$B->A("nummer").":</label>",
				#	Aspect::joinPoint("copyListEntry", $this, __METHOD__, array($B), "").$BCS."<span style=\"color:grey;\">$auftragName</span><span style=\"float:right;text-align:right;\">".Util::CLDateParser($B->A("datum"))."<br /><span style=\"color:grey;\">".Util::CLFormatCurrency($B->A("bruttobetrag") * 1, true)."</span>"."</span>"));
				#$html .= "<tr>".$tab->getHTMLForUpdate(false)."</tr>";
			}
			
			if($Belege->numLoaded() > 0)
				$divC2 .= "</form></div></div>";
		}

		$html .= $divC1."<div id=\"copyList\" style=\"margin-left:10px;width:95%;".(($this->numLoaded() == 0 OR $view == 4) ? "" : "display:none;")."\">".$divC2."</div>"."
			<form id=\"mPostenForm\">
				<ul class=\"\" style=\"list-style-type:none;padding:0px;max-height:600px;width:100%;width:-webkit-calc(100% - 10px); width:calc(100% - 10px);overflow:auto;\" id=\"PostenSortableContainer\">";

		$postenOptions = array("fold" => true);
		$aspectPostenOptions = Aspect::joinPoint("options", $this, __METHOD__);
		if(is_array($aspectPostenOptions))
			foreach($aspectPostenOptions AS $k => $v)
				$postenOptions[$k] = $v;
		
		$positionsNummern = parent::getPositionsNummern();
		$i = 1;
		$lastID = null;
		if($this->numLoaded() > 0) while($t = $this->getNextEntry()) {
			$ta = $t->getA();

			$postenButtons = Aspect::joinPoint("postenButtons", $this, __METHOD__, $t);
			if(is_array($postenButtons))
				$postenButtons = implode("", $postenButtons);

			if(Session::isPluginLoaded("mPostenKalkulation")){
				$B = new Button("Kalkulation anzeigen", "./ubiquitous/PostenKalkulation/showKalkulation.png", "icon");
				$B->style("float:right;margin-right:10px;");
				$B->popup("", "Kalkulation", "mPostenKalkulation", "-1", "getKalkulation", array("'GRLBM'", $t->A("GRLBMID"), "", $t->getID()), "", "{hPosition: 'center', width:1000, top:30, blackout: true}");
				$postenButtons .= $B;
			}
			
			if(Session::isPluginLoaded("mSeriennummer") AND Seriennummer::has($t->A("oldArtikelID")) AND $GRLBM->getMyPrefix() == Lagerbestand::updateOn($t->A("oldArtikelID")))
				$postenButtons .= Seriennummer::getPostenButton($t);
			
			
			#<img style=\"float:right;\" class=\"calendarIcon mouseoverFade\" style=\"margin-right:0px;\" src=\"./images/i2/delete.gif\" onclick=\"\"/>
			/*$BSettings = new Button("Optionen","./images/i2/settings.png", "icon");
			$BSettings->className("postenOptionsButton");
			$BSettings->style("float:right;margin-right:20px;");
			$BSettings->onclick("if($('optionsPosten".$t->getID()."').style.display == 'none') $('optionsPosten".$t->getID()."').style.display = ''; else $('optionsPosten".$t->getID()."').style.display = 'none';");
			if(!$postenOptions["fold"])
				$BSettings = "";*/

			if($ta->isBrutto == "1") {
				$ta->preis = Util::CLNumberParserZ($ta->bruttopreis);
				$ta->preisUnparsed = $ta->bruttopreis;
			}
			
			$TP = new HTMLTable($view > 1 ? 4 : 3);
			$TP->setColClass(1, "");
			$TP->setColClass(2, "");
			$TP->setColClass(3, "");
			$TP->setColClass(4, "");
			$TP->setTableStyle("max-width:100%;width:100%;margin:0px;border-collapse:collapse;border-spacing:0px;");
			#$TP->addTableClass("AuftragBelegContent");
			
			$TP->setColWidth(1, 80);
			$TP->setColWidth(3, 130);
			$TP->setColWidth(4, 35);
			
			$TP->addRow(array(""));
			$TP->addCellStyle(1, "height:30px;");
			#$TP->addRowClass("backgroundColor0");
			$TP->setRowID("PostenDisplayD".$t->getID()."3");
			
			Aspect::joinPoint("abovePosten", $this, __METHOD__, array($TP, $t));
			
			/**
			 * ROW 1
			 */
			$TP->addRow(array($postenButtons));
			$TP->addRowColspan(1, 4);
			$TP->setRowID("optionsPosten".$t->getID());
			$TP->addRowStyle(trim($postenButtons) == "" ? "display:none;" : "");
			$TP->addCellStyle(1, "padding-right:10px;");
			#$TP->addRowClass("backgroundColor0");

			
			/**
			 * ROW 2
			 */
			$BTrash = new Button("Posten löschen","./images/i2/delete.gif");
			$BTrash->type("icon");
			$BTrash->style("float:right;margin-right:10px;");
			$BTrash->onclick("deleteClass('Posten','".$t->getID()."',function() { $('PostenDisplayD".$t->getID()."1').style.display='none'; $('PostenDisplayD".$t->getID()."2').style.display='none'; if($('PostenDisplayD".$t->getID()."4')) $('PostenDisplayD".$t->getID()."4').style.display='none'; $('PostenDisplayD".$t->getID()."3').style.display='none'; $('optionsPosten".$t->getID()."').style.display='none'; Auftrag.updateNettoBrutto(".$t->A("GRLBMID").", ".$t->getID()."); ".Aspect::joinPoint("onDelete", $this, __METHOD__, array($t), "")." },'".T::_("Posten wirklich löschen?")."');");

			$BEdit = new Button("Posten bearbeiten","./images/i2/edit.png");
			$BEdit->type("icon");
			$BEdit->style("float:right;margin-right:20px;");
			$BEdit->onclick("contentManager.editInPopup('Posten', '{$t->getID()}', '".T::_("Posten bearbeiten")."');");

			
			$IP = new HTMLInput("name", "text", $ta->name);
			$IP->style("width:80%;text-align:left;font-weight:bold;");
			$IP->id("nameID".$t->getID());
			$IP->activateMultiEdit("Posten", $t->getID());
			
			$rowTwoContent = array($BEdit, $BTrash, $IP);
			$rowTwoContent = Aspect::joinPoint("rowTwoContent", $t, __METHOD__, $rowTwoContent, $rowTwoContent);

			$TP->addRow(array("
					<div id=\"posNr".$t->getID()."\">".Aspect::joinPoint("alterPosition", $this, __METHOD__, array($positionsNummern[$t->getID()], $t->getA()), $positionsNummern[$t->getID()])."</div>",
					implode("", $rowTwoContent)));
			$TP->addRowColspan(2, 3);
			$TP->addCellStyle(1, "padding:0px;padding-right:3px;text-align:right;font-weight:bold;");
			$TP->addRowStyle("background-color:#eee;");
			$TP->setRowID("PostenDisplayD".$t->getID()."1");
			#$TP->addRowClass("backgroundColor0");
			
			Aspect::joinPoint("afterSecondRow", $this, __METHOD__, array($TP, $t));
			
			/**
			 * ROW 3
			 */
			$IPreis = new HTMLInput("preis", "text", $ta->preis);
			$IPreis->activateMultiEdit("Posten", $t->getID(), "function(){ Auftrag.updateNettoBrutto(".$t->A("GRLBMID").", ".$t->getID()."); }");
			$IPreis->setClass("multiEditInput2");
			$IPreis->onfocus("setTimeout('continueSearch".$t->getID()." = true;', 10); ");
			$IPreis->onkeydown("if(typeof continueSearch".$t->getID()." == 'boolean' && event.keyCode == 9 && \$j('#quickSearchmArtikel').length) setTimeout(function(){ \$j('#quickSearchmArtikel').trigger('focus');}, 10);");
			$IPreis->style("width:90px;");
			
			$IVK = new HTMLInput("", "readonly", (Util::CLFormatCurrency($t->A("preisUnparsed") * ($t->A("rabatt") != null ? (100 - $t->A("rabattUnparsed")) / 100 : 1))));
			$IVK->style("width:70px;text-align:right;color:black;border:0px;");
			$IVK->id("VKsID".$t->getID());
			
			$IMenge = new HTMLInput("menge", "text", $ta->menge);
			$IMenge->activateMultiEdit("Posten", $t->getID(), "function(t){ Auftrag.checkBestand(t); Auftrag.updateNettoBrutto(".$t->A("GRLBMID").", ".$t->getID()."); }");
			$IMenge->setClass("multiEditInput2");
			$IMenge->style("width:90px;");
			if(Session::isPluginLoaded("mSeriennummer") AND Seriennummer::has($t->A("oldArtikelID")) AND $GRLBM->getMyPrefix() == Lagerbestand::updateOn($t->A("oldArtikelID")))
				$IMenge->isDisabled (true);
			if(Session::isPluginLoaded("mLagerbestandWare") AND LagerbestandWare::has($t->A("oldArtikelID")) AND $GRLBM->getMyPrefix() == Lagerbestand::updateOn($t->A("oldArtikelID")))
				$IMenge->isDisabled (true);
			
			#if($ta->PostenUsedCharge != "")
			#	$IMenge->isDisabled (true);

			$message = "";
			if($ta->message != ""){
				$m = json_decode($ta->message);
				if($m->type == "warning")
					$message = " <a style=\"color:red;font-weight:bold;\" id=\"message".$t->getID()."\" onclick=\"".OnEvent::rme($t, "clearMessage", "", "function(){ \$j('#message".$t->getID()."').remove(); }")."return false;\" href=\"#\">".$m->message."</a>";
			}
			
			
			$rowThreeContent = array($IPreis, $IMenge);
			Aspect::joinPoint("rowThreeContent", $t, __METHOD__, $rowThreeContent);
			
			$TP->addRow(array("",
				Aspect::joinPoint("mengeLabel", $this, __METHOD__, array($t), "M:")." $IMenge ".Aspect::joinPoint("postenDetails", $this, __METHOD__, array($t, $GRLBM), "").(($this->showRabatt AND $showPrices) ? "<span style=\"float:right;margin-left:5px;\">P: $IPreis</span>".CustomizerRabatt::getInput($t) : "<span style=\"color:grey;\">".$t->A("gebinde")."</span>").$message,
				($showPrices ? ($this->showRabatt ? "VK: $IVK" : "P: $IPreis") : ""),
				"<span style=\"".($t->A("mwstCheck") ? "color:red;font-weight:bold;" : "color:grey;")."\">".Util::CLFormatNumber($ta->mwst*1, 2, false, false)."%</span>"));
			$TP->addCellStyle(4, "text-align:right;");
			$TP->setRowID("PostenDisplayD".$t->getID()."2");

			/**
			 * ROW 4A
			 */
			if($view > 2 AND $bps["GRLBMType"] == "Kalk"){
				$TP->addRow(array("",
				"
					".(!isset($userHiddenFields["EK1"]) ? (isset($userLabels["EK1"]) ? $userLabels["EK1"] : "EK1").": <input style=\"margin-right:30px;\" class=\"multiEditInput2\" onfocus=\"oldValue = this.value;\" onblur=\"if(oldValue != this.value) saveMultiEditInput('Posten','".$t->getID()."','EK1');\" value=\"$ta->EK1\" id=\"EK1ID".$t->getID()."\" type=\"text\" onkeydown=\"if(event.keyCode == 13) saveMultiEditInput('Posten','".$t->getID()."','EK1');\"  />" : "")."

					".(!isset($userHiddenFields["EK2"]) ? (isset($userLabels["EK2"]) ? $userLabels["EK2"] : "EK2").": <input class=\"multiEditInput2\" onfocus=\"oldValue = this.value;\" onblur=\"if(oldValue != this.value) saveMultiEditInput('Posten','".$t->getID()."','EK2');\" value=\"$ta->EK2\" id=\"EK2ID".$t->getID()."\" type=\"text\" onkeydown=\"if(event.keyCode == 13) saveMultiEditInput('Posten','".$t->getID()."','EK2');\"  />" : "").""));
				$TP->addRowColspan(2, 3);
				
				if(isset($userHiddenFields["EK1"]) AND isset($userHiddenFields["EK2"]))
					$TP->addRowStyle("display:none;");
				
				$TP->setRowID("PostenDisplayD".$t->getID()."4");
				#$TP->addRowClass("backgroundColor0");
			}
			
			
			/**
			 * ROW 4B
			 */
			if(($view > 2 AND $bps["GRLBMType"] != "Kalk" AND $showPrices)){
			$postenCalculator = Aspect::joinPoint("postenCalculator", $this, __METHOD__, array($t, $TP));
			
				if($postenCalculator == null){
					$TP->addRow(array("",
						(!isset($userHiddenFields["EK1"]) ? (isset($userLabels["EK1"]) ? $userLabels["EK1"] : "EK1").": <input style=\"width:70px;text-align:right;margin-right:20px;\" value=\"".(Util::CLNumberParserZ($ta->mengeUnparsed * $ta->EK1Unparsed))."\" id=\"EK1dID".$t->getID()."\" type=\"text\" readonly=\"readonly\"  /><input value=\"$ta->EK1\" id=\"EK1ID".$t->getID()."\" type=\"hidden\" />" : "")."
						".(!isset($userHiddenFields["EK2"]) ? (isset($userLabels["EK2"]) ? $userLabels["EK2"] : "EK2").": <input style=\"width:70px;text-align:right;margin-right:20px;\" value=\"".(Util::CLNumberParserZ($ta->mengeUnparsed * $ta->EK2Unparsed))."\" id=\"EK2dID".$t->getID()."\" type=\"text\" readonly=\"readonly\"  /><input value=\"$ta->EK2\" id=\"EK2ID".$t->getID()."\" type=\"hidden\" />" : "")."
						VK: <input style=\"width:70px;text-align:right;margin-right:30px;\" value=\"".(Util::CLNumberParserZ($ta->mengeUnparsed * $ta->preisUnparsed * ($t->A("rabatt") != null ? (100 - $t->A("rabatt")) / 100 : 1)))."\" id=\"VKID".$t->getID()."\" type=\"text\" readonly=\"readonly\"  />"));
				
					$TP->addRowColspan(2, 3);
					$TP->addRowStyle("color:grey;");

					if(isset($userHiddenFields["EK1"]) AND isset($userHiddenFields["EK2"]))
						$TP->addRowStyle("display:none;");
					
					#$TP->addRowClass("backgroundColor0");
				}
				$TP->setRowID("PostenDisplayD".$t->getID()."4");
			}
			
			Aspect::joinPoint("belowPosten", $this, __METHOD__, array($TP, $t));

			$html .= "<li style=\"padding:0px;margin:0px;margin-left:10px;\" id=\"Posten_".$t->getID()."\">$TP</li>";
			
			$lastID = $t->getID();
			$i++;
		}

		$autofocus = "<script type=\"text/javascript\">/*$('mengeID$lastID').focus();*/</script>";
		$autofocus = Aspect::joinPoint("autofocus", $this, __METHOD__, array($autofocus), $autofocus);
		$html .= ($lastID != null ? $autofocus : "")."</ul></form>".Aspect::joinPoint("aboveSum", $this, __METHOD__, array($GRLBM), "")."<div id=\"belegSummen\" style=\"".(!$showPrices ? "display:none;" : "")."\">".$this->getSummen()."</div>".OnEvent::script("\$j('#PostenSortableContainer').css('max-height', contentManager.maxHeight()+'px');");
		
		$belowButtons = Aspect::joinPoint("belowSumButtons", $this, __METHOD__, array($GRLBM), array());
		if(!is_array($belowButtons))
			$belowButtons = array($belowButtons);
		
		if(Session::isPluginLoaded("mVersand") AND $GRLBM->getMyPrefix() == "L"){

			$BVerpackung = new Button("Verpackung", "./ubiquitous/Versand/VersandVerpackung.png");
			$BVerpackung->popup("", "Verpackung", "mVersandVerpackung", "-1", "addToBelegPopup", array($GRLBM->getID()));
			$BVerpackung->style("margin-right:15px;");
			
			$belowButtons[] = $BVerpackung;
			
		}
		
		if(count($belowButtons))
			$html .= "<div style=\"padding-top:25px;margin-left:10px;\">".implode("", $belowButtons)."</div>";
		
		
		$below = Aspect::joinPoint("belowSum", $this, __METHOD__, array($GRLBM), "");
		if(!is_array($below))
			$below = array($below);
		
		$html .= "<div>".implode("", $below)."".$this->signature($GRLBM)."</div>";
		
		if($this->CustomizerPostenSort) $html .= "
			<script type=\"text/javascript\">
				\$j('#PostenSortableContainer').sortable({
					axis: 'y', 
					update: function() {
						contentManager.rmePCR('CustomizerPostenSort','', 'saveOrder', Sortable.serialize('PostenSortableContainer').replace(/&/g,'').replace(/Posten/g, ',').replace(/PostenSortableContainer\[\]=/g, ','), function(transport){ Auftrag.updatePositionsNummern(\$j.parseJSON(transport.responseText)); });
					},
					dropOnEmpty: true,
					scroll: true,
					handle: \$j('.PostenSortableHandle')});
			</script>";
/* 
		if($bps["GRLBMType"] == "Kalk") $html .= "
		<table style=\"margin-top:20px;width:530px;\">
			<colgroup>
				<col class=\"backgroundColor2\" style=\"width:120px;\" />
				<col class=\"backgroundColor3\" />
			</colgroup>
			<tr>
				<td class=\"backgroundColor0\"></td>
			</tr>
			".(!isset($userHiddenFields["EK1"]) ? "<tr>
				<td><label>ges. ".(isset($userLabels["EK1"]) ? $userLabels["EK1"] : "EK1").":</label></td>
				<td id=\"gesamtEK1\" style=\"text-align:right;\"></td>
			</tr>" : "")."
			".(!isset($userHiddenFields["EK2"]) ? "<tr>
				<td><label>ges. ".(isset($userLabels["EK2"]) ? $userLabels["EK2"] : "EK2").":</label></td>
				<td id=\"gesamtEK2\" style=\"text-align:right;\"></td>
			</tr>" : "")."
			<tr>
				<td><label>ges. VK:</label></td>
				<td id=\"gesamtVK\" style=\"text-align:right;\"></td>
			</tr>
			<tr>
				<td class=\"backgroundColor0\"></td>
			</tr>
			<tr>
				<td><label>Rabatt in %:</label></td>
				<td id=\"rabattInP\" style=\"text-align:right;\"></td>
			</tr>
			<tr>
				<td><label>Rabatt in €:</label></td>
				<td id=\"rabattInW2\" style=\"text-align:right;\"></td>
			</tr>
			<tr>
				<td><label>ges. VK:</label></td>
				<td id=\"gesamtVK2\" style=\"text-align:right;\"></td>
			</tr>
			<tr>
				<td class=\"backgroundColor0\"></td>
			</tr>
			".(!isset($userHiddenFields["EK1"]) ? "<tr>
				<td><label>VK - ".(isset($userLabels["EK1"]) ? $userLabels["EK1"] : "EK1").":</label></td>
				<td id=\"VKEK1\" style=\"text-align:right;font-weight:bold;\"></td>
			</tr>" : "")."
			".(!isset($userHiddenFields["EK2"]) ? "<tr>
				<td><label>VK - ".(isset($userLabels["EK2"]) ? $userLabels["EK2"] : "EK2").":</label></td>
				<td id=\"VKEK2\" style=\"text-align:right;font-weight:bold;\"></td>
			</tr>" : "")."
			<tr>
				<td><label>Leasingrate:</label></td>
				<td id=\"leasingrate2\" style=\"text-align:right;\"></td>
			</tr>
			$this->additionalCalculatorFields
			<tr>
				<td colspan=\"2\"><input type=\"button\" value=\"Werte berechnen\" onclick=\"calculateKalk();\" /></td>
			</tr>
		</table>";
		elseif($view > 3){
			$html .= "
		<table class=\"AuftragBelegContent\" style=\"margin-top:20px;\">
			<colgroup>
				<col class=\"backgroundColor2\" style=\"width:120px;\" />
				<col class=\"backgroundColor3\" />
			</colgroup>
			".(!isset($userHiddenFields["EK1"]) ? "<tr>
				<td><label>ges. ".(isset($userLabels["EK1"]) ? $userLabels["EK1"] : "EK1").":</label></td>
				<td id=\"gesamtEK1\" style=\"text-align:right;\"></td>
			</tr>" : "")."
			".(!isset($userHiddenFields["EK2"]) ? "<tr>
				<td><label>ges. ".(isset($userLabels["EK2"]) ? $userLabels["EK2"] : "EK2").":</label></td>
				<td id=\"gesamtEK2\" style=\"text-align:right;\"></td>
			</tr>" : "")."
			<tr>
				<td><label>ges. VK:</label></td>
				<td id=\"gesamtVK\" style=\"text-align:right;\"></td>
			</tr>
			<tr>
				<td class=\"backgroundColor0\"></td>
			</tr>
			".(!isset($userHiddenFields["EK1"]) ? "<tr>
				<td><label>VK - ".(isset($userLabels["EK1"]) ? $userLabels["EK1"] : "EK1").":</label></td>
				<td id=\"VKEK1\" style=\"text-align:right;font-weight:bold;\"></td>
			</tr>" : "")."
			".(!isset($userHiddenFields["EK2"]) ? "<tr>
				<td><label>VK - ".(isset($userLabels["EK2"]) ? $userLabels["EK2"] : "EK2").":</label></td>
				<td id=\"VKEK2\" style=\"text-align:right;font-weight:bold;\"></td>
			</tr>" : "")."
			<tr>
				<td colspan=\"2\"><input type=\"button\" value=\"Werte berechnen\" onclick=\"calculateKalk();\" /></td>
			</tr>
		</table>";
		} */
		
		return $html;
	}
	
	public function signature($GRLBM){
		$empty = "iVBORw0KGgoAAAANSUhEUgAAAZAAAACWCAYAAADwkd5lAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gsDDxwtWsnIwwAAABl0RVh0Q29tbWVudABDcmVhdGVkIHdpdGggR0lNUFeBDhcAAAD/SURBVHja7cEBDQAAAMKg909tDwcUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAALwZqkMAAVfFVk8AAAAASUVORK5CYII=";
		
		if(!$GRLBM->A("GRLBMServiceSigAN") AND !$GRLBM->A("GRLBMServiceSigAG"))
			return "";
		
		if($GRLBM->A("GRLBMServiceSigAN") != ""){
			ob_start();
			imagepng(PDFBrief::sigJsonToImage($GRLBM->A("GRLBMServiceSigAN"), array('imageSize' => array(400, 150))));
			$sig1 = base64_encode(ob_get_clean());
		} else
			$sig1 = $empty;
		
		$sig1 = "<img style=\"width:100%;max-width:250px;\" src=\"data:image/png;base64,".$sig1."\" />";
		
		if($GRLBM->A("GRLBMServiceSigAG") != ""){
			ob_start();
			imagepng(PDFBrief::sigJsonToImage($GRLBM->A("GRLBMServiceSigAG"), array('imageSize' => array(400, 150))));
			$sig2 = base64_encode(ob_get_clean());
		} else
			$sig2 = $empty;
		
		$sig2 = "<img style=\"width:100%;max-width:250px;\" src=\"data:image/png;base64,".$sig2."\" />";
		
		return "<div style=\"width:50%;display:inline-block;text-align:center;margin-top:20px;\">".$sig1."<br>Unterschrift Auftragnehmer</div><div style=\"margin-top:20px;text-align:center;width:50%;display:inline-block;\">".$sig2."<br>Unterschrift Auftraggeber</div>";
	}
	
	public function belegAction($title, $content){
		// <editor-fold defaultstate="collapsed" desc="Aspect:jP">
		try {
			$MArgs = func_get_args();
			return Aspect::joinPoint("around", $this, __METHOD__, $MArgs);
		} catch (AOPNoAdviceException $e) {}
		Aspect::joinPoint("before", $this, __METHOD__, $MArgs);
		// </editor-fold>
		
		return "
		<div style=\"width:31%;display:inline-block;vertical-align:top;margin-right:1%;margin-bottom:10px;\" class=\"spell AuftragBelegAction\">
			<p class=\"backgroundColor3\">".T::_($title)."</p>
			<div style=\"padding:10px;\">
				$content
			</div>
		</div>";
	}
	
	public function getCopyBelege(GRLBM $GRLBM){
		if($GRLBM->getMyPrefix() == "O" OR $GRLBM->getMyPrefix() == "P"){
			$Belege = anyC::get("GRLBM");
			$Belege->addAssocV3("GRLBMID", "!=", $GRLBM->getID());
			$Belege->addAssocV3("isA", "=", "1", "AND", "2");
			$Belege->addAssocV3("isB", "=", "1", "OR", "2");
			
			$Belege->addOrderV3("datum", "DESC");
			$Belege->addOrderV3("isA", "DESC");
			$Belege->addOrderV3("isB", "DESC");

			$Belege->setLimitV3("48");
			$Belege->lCV3();
			
			return $Belege;
		}
		
		$pSpecData = mUserdata::getPluginSpecificData("Auftraege");
		
		$Belege = anyC::get("GRLBM");
		$Belege->addAssocV3("AuftragID", "=", $GRLBM->A("AuftragID"));
		$Belege->addAssocV3("GRLBMID", "!=", $GRLBM->getID());
		$Belege->addAssocV3("isM", "=", "0");

		if(Session::isPluginLoaded("mGRLBMService"))
			$Belege->addJoinV3 ("GRLBMService", "GRLBMID", "=", "GRLBMServiceGRLBMID");

		foreach ($pSpecData AS $k => $v){
			if(strpos($k, "pluginSpecificCantCreate") === false)
				continue;
			
			$b = str_replace("pluginSpecificCantCreate", "", $k);
			if(strpos("GRLBMA", $b) !== false)
				$Belege->addAssocV3("is$b", "=", "0");
			else
				$Belege->addAssocV3("isWhat", "!=", $b);
		}
		
		/*if(isset($pSpecData["pluginSpecificCantCreateR"]))
			$Belege->addAssocV3("isR", "=", "0");

		if(isset($pSpecData["pluginSpecificCantCreateL"]))
			$Belege->addAssocV3("isL", "=", "0");

		if(isset($pSpecData["pluginSpecificCantCreateG"]))
			$Belege->addAssocV3("isG", "=", "0");

		if(isset($pSpecData["pluginSpecificCantCreateA"]))
			$Belege->addAssocV3("isA", "=", "0");*/
		
		$Belege->addOrderV3("datum", Aspect::joinPoint("order", $this, __METHOD__, array(), "DESC"));
		$Belege->addOrderV3("isA", "DESC");
		$Belege->addOrderV3("isL", "DESC");
		$Belege->addOrderV3("isR", "DESC");
		$Belege->addOrderV3("isG", "DESC");
		$Belege->addOrderV3("isWhat", "DESC");

		$Belege->setLimitV3("48");
		$Belege->lCV3();

		return $Belege;
	}
	
	public function getPositionsNummern($GRLBMID = null, $echo = false) {
		if($GRLBMID != null)
			$this->addAssocV3 ("GRLBMID", "=", $GRLBMID);
		
		$data = json_encode(parent::getPositionsNummern());
		
		if($echo)
			echo $data;
		
		return $data;
	}

	public function getSummen($GRLBMID = null, $PostenID = null){
		$echo = false;
		if($this->GRLBM == null){
			$this->GRLBM = new GRLBM($GRLBMID);
			$echo = true;
		}
		$t = new HTMLTable(3);
		$t->setColClass(1, "");
		$t->setColClass(2, "");
		$t->setColClass(3, "");
		$t->setTableStyle("margin-top:20px;border-top-style:double;border-left-width:0px;max-width:100%;");
		$t->addTableClass("AuftragBelegContent");
		$t->setColWidth(1, "30%");
		$t->setColWidth(2, "30%");
		$t->setColWidth(3, "40%");
		#$t->addColStyle(2, "text-align:right;");
		$t->addColStyle(3, "text-align:right;");

		$B = new Button("", "bars", "iconicG");
		$B->label("Gewinn (EK1): %1", Util::CLFormatCurrency($this->GRLBM->A("nettobetrag") - $this->GRLBM->A("ek1betrag"), false));
		$t->addRow(array($B, "<span style=\"color:grey;\">".T::_("Netto").": ".Util::CLFormatCurrency($this->GRLBM->A("nettobetrag")*1, false)."</span>", T::_("Brutto").": <b>".Util::CLFormatCurrency($this->GRLBM->A("bruttobetrag")*1, false)."</b>"));
		#$t->addRowClass("backgroundColor0");

		$js = "";
		if($PostenID != null){
			$Posten = new Posten($PostenID, false);
			
			$js = "<script type=\"text/javascript\">";
			
			if($this->CustomizerPostenPercentGUI OR (Session::isPluginLoaded("mStaffelpreis") AND Staffelpreis::useWith($this->GRLBM->getMyPrefix()) AND $Posten->A("oldArtikelID") != "0" AND Staffelpreis::has("Artikel", $Posten->A("oldArtikelID")))){
				#$SP = Staffelpreis::get("Artikel", $Posten->A("oldArtikelID"), $Posten->A("menge"));
				if($Posten->A("isBrutto"))
					$js .= "
					\$j('#preisID$PostenID').val('".Util::CLNumberParserZ($Posten->A("bruttopreis"))."');";
				else
					$js .= "
					\$j('#preisID$PostenID').val('".Util::CLNumberParserZ($Posten->A("preis"))."');";
			}
			
			
			$js .= "
				if($('EK1dID$PostenID')) $('EK1dID$PostenID').value = '".Util::CLFormatCurrency($Posten->A("menge") * $Posten->A("EK1"))."';
				if($('EK2dID$PostenID')) $('EK2dID$PostenID').value = '".Util::CLFormatCurrency($Posten->A("menge") * $Posten->A("EK2"))."';
				if($('EK1sID$PostenID')) $('EK1sID$PostenID').value = '".Util::CLFormatCurrency($Posten->A("EK1")*1)."';
				if($('VKID$PostenID')) $('VKID$PostenID').value = '".Util::CLFormatCurrency($Posten->A("menge") * $Posten->A("preis") * ($Posten->A("rabatt") != null ? (100 - $Posten->A("rabatt")) / 100 : 1))."';
				if($('VKsID$PostenID')) $('VKsID$PostenID').value = '".Util::CLFormatCurrency($Posten->A("preis") * ($Posten->A("rabatt") != null ? (100 - $Posten->A("rabatt")) / 100 : 1))."';
				if($('rabattID$PostenID')) $('rabattID$PostenID').value = '".Util::CLNumberParserZ($Posten->A("rabatt") * 1)."';
			</script>";
		}
		
		if($echo) echo $t.$js;
		return $t;
	}

	public function getContextMenuHTML($identifier){
		T::load(__DIR__, "Auftraege");
		
		$bps = $this->getMyBPSData();

		$ex = explode(":", $identifier);
		if(count($ex) > 1)
			$identifier = $ex[0];

		switch($identifier){
			/* case "1":
				echo "
				<table>
					<tr>
						<td><input type=\"button\" value=\"Angebot\" style=\"background-image:url(./images/navi/angebot.png);\" class=\"bigButton backgroundColor2\" onclick=\"phynxContextMenu.update('mPosten','A','Angebote:');\" /></td>
					</tr>
					<tr>
						<td><input type=\"button\" value=\"Lieferschein\" style=\"background-image:url(./images/navi/lieferschein.png);\" class=\"bigButton backgroundColor2\" onclick=\"phynxContextMenu.update('mPosten','L','Lieferscheine:');\" /></td>
					</tr>
					<tr>
						<td><input type=\"button\" value=\"Rechnung\" style=\"background-image:url(./images/navi/rechnung.png);\" class=\"bigButton backgroundColor2\" onclick=\"phynxContextMenu.update('mPosten','R','Rechnungen:');\" /></td>
					</tr>
					<tr>
						<td><input type=\"button\" value=\"Gutschrift\" style=\"background-image:url(./images/navi/gutschrift.png);\" class=\"bigButton backgroundColor2\" onclick=\"phynxContextMenu.update('mPosten','G','Gutschriften:');\" /></td>
					</tr>
				</table>";
			break;
			
			case "A":
			case "L":
			case "R":
			case "G":
				echo "
				<div id=\"copyContextExtension\" class=\"borderColor1 backgroundColor0\" style=\"float:right;width:200px;margin-right:-207px;padding:5px;border-style:solid;border-width:1px;\"></div>
				<table>
					<colgroup>
						<col style=\"width:20px;\" />
						<col class=\"backgroundColor2\" />
						<col class=\"backgroundColor3\" />
					</colgroup>";
				$G = new mGRLBMGUI();
				$G->addJoinV3("Auftrag","AuftragID","=","AuftragID");
				$G->setAssocV3("is$identifier","=","1");
				if($bps != -1) $G->addAssocV3("GRLBMID","!=",$bps["loadGRLBMID"]);
				$G->addOrderV3("nummer","DESC");
				$G->setLimitV3("10");
				$G->lCV3();
				while(($t = $G->getNextEntry())){

					$Adresse = null;
					if($t->getA()->AdresseID != ""){
						$Adresse = new Adresse($t->getA()->AdresseID);
						$Adresse->loadMe();
					}
					
					echo "
					<tr onclick=\"Auftrag.copyPostenFrom('".$t->getID()."','".$bps["loadGRLBMID"]."','$identifier','subframe');\" class=\"".(($bps != -1 AND $bps["AuftragID"] == $t->getA()->AuftragID) ? "backgroundColor1" : "")."\" onmouseout=\"this.className='".(($bps != -1 AND $bps["AuftragID"] == $t->getA()->AuftragID) ? "backgroundColor1" : "")."';\" style=\"cursor:pointer;\" onmouseover=\"this.className = 'backgroundColor0'; $('copyContextExtension').update('".($Adresse != null ? $Adresse->getA()->firma.($Adresse->getA()->nachname != "" ? "<br />".$Adresse->getA()->nachname." ".$Adresse->getA()->vorname : "") : "keine Daten verfügbar")."');\">
						<td><img src=\"./images/i2/copy.png\" class=\"mouseoverFade\" /></td>
						<td>".$identifier.$t->getA()->nummer."</td>
						<td>".$t->getA()->datum."</td>
					</tr>";
				}
				
				$B = new Button("Posten kopieren","./images/i2/save.gif");
				$B->type("icon");
				$B->style("float:right;");
				$B->onclick("Auftrag.copyPostenByTypeAndNumber($('copyFromNumber').value, '$identifier', '".$bps["loadGRLBMID"]."', 'subframe');");
				
				echo "<tr>
					<td colspan=\"3\">Geben Sie die Nummer ein:</td>
				</tr><tr>
					<td colspan=\"3\">$B<input type=\"text\" style=\"width:80%;\" id=\"copyFromNumber\"></td>
				</tr>
				</table>";
			break;  */
			
			case "100":
				$ud = new mUserdata();
	
				$aT = $ud->getUDValue("GRLBMAnsicht");
				
				if($aT == null)
					$selectedKey = "2";
				else $selectedKey = $aT;
				
				$kAL = array();
				$kAL["1"] = "wenig";
				$kAL["2"] = "normal";
				$kAL["3"] = "viel";
				$kAL["4"] = "sehr viel";
				
				$gui = new HTMLGUI();
				echo $gui->getContextMenu($kAL, "mPosten", "100", $selectedKey, "contentManager.loadFrame(\'subframe\', \'GRLBM\', \'$ex[1]\');");
			break;
		}
	}
	
	public function saveContextMenu($identifier, $key){
		$ud = new mUserdata();
		
		if($identifier == "100") $ud->setUserdata("GRLBMAnsicht",$key);
	}
	
	public function findArtikel($query){
		$mA = new mArtikelGUI();
		$AC = $mA->getACData("", $query, false);
		
		$A = $AC->n();
		if($A == null)
			return;
		
		if($AC->numLoaded() > 1)
			return;
		
		echo $A->getID();
	}
	
}
?>
