<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2022, open3A GmbH - Support@open3A.de
 */
class mPosten extends anyC {
	private $letterType = "";
	#public $postenButtons = "";
	public $CustomizerPostenSort = false;
	public $positions = array(0); //was static but don't know why?
	public $positionsCurrentGRLBMID = 0; //was static but don't know why?
	
	function __construct() {
		$this->customize();

		$this->setCollectionOf("Posten");
		if($this->CustomizerPostenSort)
			$this->addOrderV3("PostenSortOrder");
		$this->addOrderV3("PostenID");
	}
	
	public function setLetterType($type){
		$this->letterType = $type;
	}
	
	public function getLetterType(){
		return $this->letterType;
	}
	
	function getCollector(){
		return $this->collector;
	}
	
	public function getPositionsNummern(){
		$nummern = array();
		
		while($t = $this->getNextEntry()){
			if($t->A("GRLBMID") != $this->positionsCurrentGRLBMID){
				$this->positionsCurrentGRLBMID = $t->A("GRLBMID");
				$this->positions = array(0);
			}

			$ZS = false;
			try {
				if(defined("PHYNX_VIA_INTERFACE") AND !class_exists("CustomizerPostenZwischensummeGUI", false))
					throw new ClassNotFoundException("CustomizerPostenZwischensummeGUI");
				
				$C = new CustomizerPostenZwischensummeGUI(null, false);
				$ZS = true;
			} catch (ClassNotFoundException $e){

			}
			
			$useSub = Aspect::joinPoint("useSub", $this, __METHOD__, array(), true);
			
			if($useSub AND $t->A("PostenAddLine") != "" AND $t->A("PostenAddLine") != "-" AND $ZS){
				if(strpos($t->A("PostenAddLine"), "[") === 0){
					$titles = json_decode($t->A("PostenAddLine"));
					foreach($titles AS $T){
						if($T->label == "")
							continue;
						
						#$step = 1;
						#if(isset($T->step))
						#	$step = $T->step;
						
						if(isset($T->level) AND $T->level != 0)
							while(count($this->positions) > $T->level)
								array_pop ($this->positions);
							
						
						#self::$positions[count(self::$positions) - 1] += $step;
						if(isset($T->number) AND $T->number != "")
							$this->positions[count($this->positions) - 1] = $T->number;
						else
							$this->positions[count($this->positions) - 1]++;
						
						$this->positions[] = 0;
					}
				} else {
					$this->positions[count($this->positions) - 1]++;
					$this->positions[] = 0;
				}
			}

			$this->positions[count($this->positions) - 1]++;

			$nummern[$t->getID()] = implode(".", $this->positions);
			
			if($t->A("PostenAddSum") != "" AND count($this->positions) > 1){
				if($t->A("PostenAddSum") == "1")
					array_pop($this->positions);
				if($t->A("PostenAddSum") > 1)
					for($i = 0; $i < $t->A("PostenAddSum"); $i++)
						array_pop($this->positions);
			}
				
		}
		
		$this->resetPointer();
		
		return $nummern;
	}
	
	/*public static function numberParser($w,$l){
		if($l == "load") return number_format($w, 2, ",", "");
		if($l == "store") return str_replace(",",".",$w);
	}*/

	function cloneAllToGRLBM($GRLBMID, $updatePrices = false, $kundennummer = 0){
		$this->addAssocV3("GRLBMID","=",$GRLBMID);
		
		while($t = $this->n())
			$t->cloneMe($updatePrices, $kundennummer);
	}
	
	private $postenBottom = [];
	function addVirtualPostenBottom(){
		$this->postenBottom[] = func_get_args();
	}
	
	function getVirtualPostenBottom(){
		return $this->postenBottom;
	}
	
	function setVirtualPostenBottom(array $posten){
		$this->postenBottom = $posten;
		
		return count($posten) > 0;
	}
	
	function includeVirtualPostenBottom(){
		foreach($this->postenBottom AS $P)
			$this->addVirtualPosten (...$P);
		}
	
	function addVirtualPosten($menge, $einheit, $bezeichnung, $beschreibung, $preis, $mwst, $isBrutto, $bruttopreis = null, $artikelnummer = "", $options = []){
		if($this->collector == null)
			$this->lCV3();
		
		$P = new Posten(-1);
		$PA = $P->newAttributes();
		$PA->name = $bezeichnung;
		$PA->gebinde = $einheit;
		$PA->preis = $preis;
		$PA->menge = $menge;
		$PA->mwst = $mwst;
		$PA->beschreibung = $beschreibung;
		$PA->isBrutto = $isBrutto;
		if($bruttopreis === null)
			$PA->bruttopreis = (float) $PA->preis * (1 + ((float) $PA->mwst / 100));
		else
			$PA->bruttopreis = $bruttopreis;
		$PA->artikelnummer = $artikelnummer;
		
		$P->AA("optionen", $options);
		
		$P->setA($PA);
		$this->collector[] = $P;
		
		return $P;
	}

	public $Xs = array();
	public $Ws = array();
		
	public function getFPDF($fpdf, GRLBM $GRLBM, $resetValues = true, $showHeader = true){
		if($this->letterType == "M")
			return;
		
		$printSerials = Aspect::joinPoint("serials", $this, __METHOD__, array(), true);
		
		$userHiddenFields = mUserdata::getHides("Artikel");
		$noDescription = in_array($GRLBM->getMyPrefix(), explode(" ", $fpdf->showNoDescription));
		
		if($resetValues){
			$fpdf->gesamtEK1 = 0;
			$fpdf->gesamtEK2 = 0;
			$fpdf->gesamt_netto = array();
			$fpdf->gesamt_brutto = array();
			$fpdf->gesamt_mwst = array();
			
			$fpdf->gesamt_Lohnkosten_netto = 0;
			$fpdf->gesamt_Lohnkosten_brutto = 0;
			$fpdf->gesamt_Lohnkosten_steuer = 0;
		}
		#$fpdf->positionPreis = "start";
		
		$positionsNummern = $this->getPositionsNummern();
		$i = 0;
		while($PC = $this->n()){
			if($PC->AA("optionen") === null)
				$PC->AA("optionen", []);
			
			$optionen = $PC->AA("optionen");
			if(isset($optionen) AND $optionen["noPos"])
				$positionsNummern[$PC->getID()] = "";
			
			$noDescription = Aspect::joinPoint("descriptionToggle", $this, __METHOD__, [$fpdf, $GRLBM, $PC, $noDescription], $noDescription);
			
			if($this->letterType == "L" AND $PC->A("lagerort") != "")
				$PC->changeA("beschreibung", $fpdf->labelLager.": ".$PC->A("lagerort")."\n".$PC->A("beschreibung"));
				
			
			$A = $PC->getA();
			
			if(!$fpdf->showPositionen){
				Aspect::joinPoint("abovePosten", $this, __METHOD__, array($fpdf, $PC, $i, $positionsNummern));
				$this->calcPrices($PC, $fpdf, $GRLBM);
				Aspect::joinPoint("belowPosten", $this, __METHOD__, array($fpdf, $PC, null, null, $positionsNummern));
				continue;
			}
			
			if($printSerials AND $PC->A("PostenUsedSerials")){
				$S = json_decode($PC->A("PostenUsedSerials"));
				$PC->changeA("beschreibung", implode("\n", $S)."\n".$PC->A("beschreibung"));
			}
			
			if($PC->A("PostenUsedCharge"))
				$PC->changeA("beschreibung", $PC->A("PostenUsedCharge").$fpdf->separatorChargeDescription.$PC->A("beschreibung"));
			
			
			if($showHeader AND $i == 0 AND (!isset($A->PostenNewPage) OR $A->PostenNewPage == "0" OR $A->PostenNewPage == "" OR $A->PostenNewPage == "2"))
				$fpdf->printPDFHeader();

			if(isset($A->PostenNewPage) AND $A->PostenNewPage == "1")
				$fpdf->AddPage();
			
			$fpdf->SetTextColorArray($fpdf->colorPositionen); //HAS to stay above joinPoint "abovePosten"!
			
			Aspect::joinPoint("abovePosten", $this, __METHOD__, array($fpdf, $PC, $i, $positionsNummern));
			
			$yImage = null;
			$fpdf->currentArticle = $PC;
			
			if($fpdf->GetY() > $fpdf->h - $fpdf->marginBottom - 10){
				$fpdf->ln(2);
				$fpdf->AddPage();
			}
			
			$im = null;
			if($A->bild != "" AND strpos($fpdf->showImagesOn, $this->letterType) !== false){
				$bild = $A->bild;
				if(substr($bild, 0, 5) == "file:"){
					if(file_exists(FileStorage::getFilesDir().substr($bild, 5)))
						$bild = file_get_contents(FileStorage::getFilesDir().substr($bild, 5));
					else
						$bild = base64_decode("iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAIAAACQd1PeAAAACXBIWXMAAC4jAAAuIwF4pT92AAAAB3RJTUUH5QgCCx86FyebFgAAABl0RVh0Q29tbWVudABDcmVhdGVkIHdpdGggR0lNUFeBDhcAAAAMSURBVAjXY/j//z8ABf4C/tzMWecAAAAASUVORK5CYII=");
				} else
					$bild = DBImageGUI::getData($A->bild);
				
				$im = imagecreatefromstring($bild);
				$ratio = imagesx($im) / imagesy($im);
				$imHeight = $fpdf->widthPositionBild / $ratio;
				
				$yImage = $fpdf->GetY() + $imHeight + 10 + 5; //+5 because of first line of text in posten
				
				$fpdf->currentArticle = null;
				if($yImage > $fpdf->h - $fpdf->GetMargin("B")){
					$fpdf->AddPage();
					$yImage = $fpdf->GetY() + $imHeight + 10 + 5;
				}
				$fpdf->currentArticle = $PC;
			}
			
			#if($i != 0) //war ganz oben an die Linie hingequetscht, nicht schön
				$fpdf->SetXY($fpdf->GetX(), $fpdf->GetY() + 2);

			
			Aspect::joinPoint("front", $this, __METHOD__, array($fpdf, $PC, $i));
			
			$yTop = $fpdf->GetY();
			$x = $fpdf->GetX();
			$yBot = array();
			$yBezeichnung = 0;
			foreach($fpdf->orderCols AS $col){
				$width = "width$col";
				$widthAdd = 0;
				if(!$fpdf->$width)
					continue;
				
				#$fpdf->SetXY($x, $yTop);
				$fpdf->SetX($x);#, $yTop);
				$fpdf->SetFont($fpdf->fontPositionen[0], $fpdf->fontPositionen[1], $fpdf->fontPositionen[2]);
				
				if($col != "Bezeichnung"){
					$tempX = $fpdf->GetX();
					$tempY = $fpdf->GetY();
					$fpdf->SetXY($x, $yTop);
				}
				
				if($this->letterType != "Kalk"){
					if($col == "Position"){
						$fpdf->SetAutoPageBreak(false);
						$fpdf->MultiCell8($fpdf->$width, $fpdf->heightPositionenHeader, Aspect::joinPoint("alterPosition", $this, __METHOD__, array($positionsNummern[$PC->getID()], $A), $positionsNummern[$PC->getID()]), 0, $fpdf->alignPosition);
						$fpdf->SetAutoPageBreak(true, $fpdf->marginBottom);
					}
					
					if($col == "Einheit"){
						if($fpdf->widthEinheitMarginLeft){
							$fpdf->Cell($fpdf->widthEinheitMarginLeft, $fpdf->heightPositionenHeader, "");
							$widthAdd += $fpdf->widthEinheitMarginLeft;
						}
						$fpdf->MultiCell8($fpdf->$width, $fpdf->heightPositionenHeader, $A->gebinde, 0, $fpdf->alignEinheit);
					}
					if($col == "Artikelnummer")
						$fpdf->MultiCell8($fpdf->$width, $fpdf->heightPositionenHeader, $A->artikelnummer, 0, "L");
				}
				
				if($col == "Menge"){
					$menge = Util::formatNumber($fpdf->language, Aspect::joinPoint ("menge", $this, __METHOD__, array($A, $fpdf), $A->menge * 1), $fpdf->showDezimalstellenMenge == "" ? 2 : $fpdf->showDezimalstellenMenge, true, $fpdf->showZeroesMenge);
					if(isset($optionen) AND $optionen["hideAmount"])
						$menge = "";
					
					$fpdf->MultiCell8($fpdf->$width, $fpdf->heightPositionenHeader, $menge, 0, $fpdf->alignMenge);
				}
				
				if($col == "Menge2")
					$fpdf->MultiCell8($fpdf->$width, $fpdf->heightPositionenHeader, Aspect::joinPoint("menge2", $this, __METHOD__, array($A, $fpdf), $A->menge2), 0, $fpdf->alignMenge2);
				
				if($col != "Bezeichnung")
					$fpdf->SetXY($tempX, $tempY);
				
			
				if($col == "Bezeichnung"){
					$this->Xs[$col] = $fpdf->GetX();
					$this->Ws[$col] = $fpdf->$width;
					
					$fpdf->isInPostenBezeichnung = true;
					$fpdf->SetFont($fpdf->fontPositionenArtikelname[0], $fpdf->fontPositionenArtikelname[1], $fpdf->fontPositionenArtikelname[2]);
					$fpdf->MultiCell8($fpdf->$width, $fpdf->heightPositionenHeader, $fpdf->cur($A->name), 0, "L");
					$yBezeichnung = $x;
					$fpdf->isInPostenBezeichnung = false;
				}
				
				$x += $fpdf->$width + $widthAdd;
				
				$newY = $fpdf->getY() + $fpdf->heightPositionenHeader;
				if($col == "Bezeichnung")
					$newY = $fpdf->getY();
				
				$yBot[] = $newY;
			}
			
			if($fpdf->positionPreis == "start"){
				$yaNStart2 = $fpdf->getY();
				$fpdf->setXY($x, $yTop);
				Aspect::joinPoint("tail", $this, __METHOD__, array($fpdf, $PC, $i));
				$this->printPrices($fpdf, $PC, $GRLBM);
				$fpdf->setXY($x, $yaNStart2);
			}

			$yBot2 = $yBot;
			#$yImage = 0;
			if($A->bild != "" AND strpos($fpdf->showImagesOn, $this->letterType) !== false){
				$fpdf->ImageGD($im, $fpdf->positionPositionBild, max($yBot), $fpdf->widthPositionBild, $imHeight);
				$yBot2[] = max($yBot) + $imHeight;
				#$yImage = max($yBot) + $imHeight;
			}

			$startPage = $fpdf->PageNo();
			$yBeschreibung = 0;
			if(!$noDescription AND $A->beschreibung != "" AND $fpdf->widthBezeichnung AND $yBezeichnung) {
				$fpdf->isInPostenBeschreibung = true;
				$fpdf->SetFont($fpdf->fontPositionenBeschreibung[0], $fpdf->fontPositionenBeschreibung[1], $fpdf->fontPositionenBeschreibung[2]);
				
				#$fpdf->SetXY($yBezeichnung, max($yBot));
				$fpdf->SetX($yBezeichnung);
				$fpdf->MultiCell8($fpdf->widthBezeichnung, $fpdf->heightPositionenBeschreibung, $fpdf->cur($A->beschreibung),0,"L",0);
				$fpdf->SetFont($fpdf->fontPositionen[0], $fpdf->fontPositionen[1], $fpdf->fontPositionen[2]);
				$yBot2[] = $fpdf->getY();
				$fpdf->isInPostenBeschreibung = false;
				$yBeschreibung = $fpdf->getY();
			}
			

			if($fpdf->positionPreis == "end"){
				#$fpdf->setXY($x, max($yBot2) - 5);
				$fpdf->SetXY($x, $fpdf->GetY() - 5);
				#$fpdf->MultiCell8(0, 5, print_r($yBot, true));
				$this->printPrices($fpdf, $PC, $GRLBM);
				Aspect::joinPoint("tail", $this, __METHOD__, array($fpdf, $PC, $i));
			}

			if($fpdf->positionPreis == "start")
				#$fpdf->setXY($x, max($yBot2) - 5); //Fix space between articles
				$fpdf->SetXY($x, $fpdf->GetY() - 5); //Fix space between articles

			#if($this->letterType == "L")
			#	$fpdf->Cell(0,5,"WHAT!?",0,0,"R");
			
			
			
			if($this->letterType == "Kalk"){
				if($fpdf->widthEK1)
					$fpdf->Cell8($fpdf->widthEK1, 5, (!isset($userHiddenFields["EK1"]) ? $fpdf->cur($fpdf->formatCurrency($fpdf->language,$A->EK1 * 1,$fpdf->showPositionenWaehrung)) : ""), 0, 0, "R");
					
				if($fpdf->widthEK2)
					$fpdf->Cell8($fpdf->widthEK2, 5, (!isset($userHiddenFields["EK2"]) ? $fpdf->cur($fpdf->formatCurrency($fpdf->language,$A->EK2 * 1,$fpdf->showPositionenWaehrung)) : ""), 0, 0, "R");
				
				if($fpdf->widthVK)
					$fpdf->Cell8($fpdf->widthVK, 5, $fpdf->cur($fpdf->formatCurrency($fpdf->language, $A->preis  * 1, $fpdf->showPositionenWaehrung)), 0, 0, "R");
				
				$fpdf->gesamtEK1 += $A->EK1 * $A->menge;
				$fpdf->gesamtEK2 += $A->EK2 * $A->menge;
			}
			
			$next = null;
			if(isset($this->collector[$this->i]))
				$next = $this->collector[$this->i];
			

			$fpdf->ln($fpdf->abstandPositionen);
			Aspect::joinPoint("belowPosten", $this, __METHOD__, array($fpdf, $PC, $next, $yImage, $positionsNummern));
			
			if($yImage != null AND $yImage > $yBeschreibung AND $fpdf->PageNo() == $startPage)
				$fpdf->SetY($yImage);
				#$fpdf->ln(10);
				

			$fpdf->currentArticle = null;
			
			
			if(isset($A->PostenNewPage) AND $A->PostenNewPage == "2")
				$fpdf->AddPage();
			
			if($fpdf->GetY() > $fpdf->h - $fpdf->marginBottom - 10){
				$fpdf->ln(2);
				$fpdf->AddPage();
			}

			$i++;
		}
		#$fpdf->ln(1);

		/*if($this->numLoaded() > 0 AND $this->letterType == "R" AND $GRLBM->A("versandkosten") != 0 AND $fpdf->positionVersandkosten == "above"){

			$parsedMwSt = $GRLBM->A("versandkostenMwSt");
			$mwstFaktor = 1 + $parsedMwSt / 100;
			
			$fpdf->addPriceToSum($GRLBM->A("versandkosten"), $GRLBM->A("versandkostenMwSt"));

			$fpdf->SetDrawColor(100, 100, 100);
			$fpdf->Line($fpdf->GetMargin("L") , $fpdf->getY(), 210-$fpdf->GetMargin("R") , $fpdf->getY());
			$fpdf->SetDrawColor(0, 0, 0);
			$fpdf->Cell($yBezeichnung - $fpdf->getLeftMargin(), 5, "", 0, 0, "L");
			$fpdf->Cell8($fpdf->widthBezeichnung, 5, $fpdf->labelVersandkosten, 0, 0, "L");
			$fpdf->Cell8($fpdf->widthEinzelpreis, 5, $fpdf->cur($fpdf->formatCurrency($fpdf->language, $GRLBM->getA()->versandkosten * 1 * ($fpdf->showBruttoPreise ? $mwstFaktor : 1), true)), 0, 0, "R");
			$fpdf->Cell8($fpdf->widthGesamt, 5, $fpdf->cur($fpdf->formatCurrency($fpdf->language, $GRLBM->getA()->versandkosten * 1 * ($fpdf->showBruttoPreise ? $mwstFaktor : 1), true)), 0, 0, "R");
			$fpdf->ln();
		}*/
		
		$fpdf->ln(3);
		if($fpdf->showPositionen){
			if($fpdf->paddingLinesPosten)
				$fpdf->Ln($fpdf->paddingLinesPosten / 2);
			
			$fpdf->SetDrawColorArray($fpdf->colorSumLines);
			$fpdf->Line($fpdf->GetMargin("L") , $fpdf->getY(), 210-$fpdf->GetMargin("R") , $fpdf->getY());
		
			if($fpdf->paddingLinesPosten)
				$fpdf->Ln($fpdf->paddingLinesPosten / 2);
		}
	}

	private function calcPrices($Posten, PDFBrief $fpdf, GRLBM $GRLBM){
		$prices = $Posten->prices($GRLBM);

		if(!isset($fpdf->all_netto[$Posten->A("mwst")]))
			$fpdf->all_netto[$Posten->A("mwst")] = 0;
		
		
		if(!isset($fpdf->all_brutto[$Posten->A("mwst")]))
			$fpdf->all_brutto[$Posten->A("mwst")] = 0;
		
		$fpdf->all_netto[$Posten->A("mwst")] += $prices["nettoGesamt"];
		$fpdf->all_brutto[$Posten->A("mwst")] += $prices["bruttoGesamt"];
		
		if($Posten->A("PostenIsAlternative") !== null AND $Posten->A("PostenIsAlternative") > 0)
			return $prices;
		#"nettoPreis" => $nettoPreis, 
		#"nettoGesamt" => $nettoSumme, 
		#"brutto" => $bruttoPreis, 
		#"nettoOhneRabatt" => $nettoOhneRabatt, 
		#"bruttoGesamt" => $bruttoGesamt, 
		#"mwstFaktor" => $mwstFaktor, 
		#"mwstBetragGesamt" => $mwstBetrag, 
		#"rabattFaktor" => $rabatt, 
		#"rabattBetrag" => $rabattBetrag);
		
		if(!isset($fpdf->gesamt_netto[$Posten->A("mwst")]))
			$fpdf->gesamt_netto[$Posten->A("mwst")] = 0;
		
		if(!isset($fpdf->gesamt_mwst[$Posten->A("mwst")]))
			$fpdf->gesamt_mwst[$Posten->A("mwst")] = 0;
		
		if(!isset($fpdf->gesamt_brutto[$Posten->A("mwst")]))
			$fpdf->gesamt_brutto[$Posten->A("mwst")] = 0;
		

		$fpdf->gesamt_netto[$Posten->A("mwst")] += $prices["nettoGesamt"];
		$fpdf->gesamt_brutto[$Posten->A("mwst")] += $prices["bruttoGesamt"];
		$fpdf->gesamt_mwst[$Posten->A("mwst")] += $prices["mwstBetragGesamt"];
		
		
		$fpdf->gesamt_Lohnkosten_netto += (float) $Posten->A("PostenLohnkosten") * $Posten->A("menge");
		$LohnkostenSteuer = Util::kRound((float) $Posten->A("PostenLohnkosten") * ((float) $Posten->A("PostenLohnkostenMwSt") / 100) * $Posten->A("menge"));
		$fpdf->gesamt_Lohnkosten_brutto += (float) $Posten->A("PostenLohnkosten") * $Posten->A("menge") + $LohnkostenSteuer;
		$fpdf->gesamt_Lohnkosten_steuer += $LohnkostenSteuer;
			
		return $prices;
	}
	
	private function printPrices($fpdf, $Posten, $GRLBM){
		$A = $Posten->getA();
		$prices = $this->calcPrices($Posten, $fpdf, $GRLBM);

		$priceCols = $fpdf->orderColsPrice;
		
		$menge2 = $A->menge2 != 0 ? (float) $A->menge2 : 1;
		
		#if($this->letterType == "L") return;
		if(in_array($this->letterType, $fpdf->sumHideOn))
			return;
		
		$nettoPreis = $prices["netto"];
		$bruttoPreis = $prices["brutto"];
		$rabattBetrag = $prices["rabattBetrag"];
		$mwstBetragGesamt = $prices["mwstBetragGesamt"];
		$mwstFaktor = $prices["mwstFaktor"];
		
		$dispEinzelpreis = $nettoPreis + $rabattBetrag;
		
		$einzelpreis = $nettoPreis;
		
		$gesamtpreis = $prices["nettoGesamt"];
		if($fpdf->showBruttoPreise){
			$gesamtpreis = $prices["bruttoGesamt"];
			$einzelpreis = $bruttoPreis;
			$dispEinzelpreis = ($nettoPreis + $rabattBetrag) * $mwstFaktor;
		}
		
		if($this->letterType != "Kalk"){
			$fpdf->SetFont($fpdf->fontPositionenPreise[0], $fpdf->fontPositionenPreise[1], $fpdf->fontPositionenPreise[2]);

			$priceColsContent = array(
				"widthEinzelpreis" => (!(!$fpdf->showNullPreise AND $dispEinzelpreis == 0)) ? $fpdf->formatCurrency($fpdf->language, $dispEinzelpreis, $fpdf->showPositionenWaehrung, $fpdf->showDezimalstellen) : "",
				"widthEinzelpreisNetto" => (!(!$fpdf->showNullPreise AND $nettoPreis == 0)) ? $fpdf->formatCurrency($fpdf->language, $nettoPreis, $fpdf->showPositionenWaehrung, $fpdf->showDezimalstellen) : "",
				"widthRabatt" => ((isset($A->rabatt) AND (float) $A->rabatt != 0) ? Util::formatNumber($fpdf->language, (float) $A->rabatt, 2)."%" : ""),
				"widthRabattpreis" => $fpdf->formatCurrency($fpdf->language, $einzelpreis, true),
				"widthGesamtNettoPosten" => (!(!$fpdf->showNullPreise AND (float) $A->menge * $einzelpreis == 0)) ? $fpdf->formatCurrency($fpdf->language, (float) $A->menge * $menge2 * $nettoPreis, $fpdf->showPositionenWaehrung, $fpdf->showDezimalstellen) : "",
				"widthMwStBetrag" => ((float) $A->mwst != 0 ? $fpdf->formatCurrency($fpdf->language, $mwstBetragGesamt, $fpdf->showPositionenWaehrung) : ""),
				"widthGesamt" => (!(!$fpdf->showNullPreise AND $A->menge * $gesamtpreis == 0)) ? $fpdf->formatCurrency($fpdf->language, $gesamtpreis, $fpdf->showPositionenWaehrung) : "",
				"widthMwSt" => Util::formatNumber($fpdf->language, (float) $A->mwst, 2)."%"
			);

			$priceColsContent = Aspect::joinPoint("prices", $this, __METHOD__, array($fpdf, $A, $priceColsContent), $priceColsContent);
			if(isset($priceColsContent[0]) AND is_array($priceColsContent[0])){
				$final = array();
				foreach($priceColsContent AS $sub)
					foreach($sub AS $l => $v){
						if(!isset($final[$l]))
							$final[$l] = $v;
						elseif(isset($final[$l]) AND $final[$l] != "" AND trim($v) == "")
							$final[$l] = $v;
					}
				
				$priceColsContent = $final;
			}
			#die();
			foreach($priceCols AS $col){
				$this->Xs[$col] = $fpdf->GetX();
				$wcol = "width$col";
				$this->Ws[$col] = $fpdf->$wcol;
					
				if($fpdf->$wcol)
					$fpdf->Cell8($fpdf->$wcol, 5, $fpdf->cur($priceColsContent[$wcol]), 0, 0, "R");
			}
		}
	}
}
?>
