<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

class Bericht_AlleBelegeNachKundeGUI extends Bericht_default implements iBerichtDescriptor {
	protected $typ = "A";
	protected $dateStart = "useBAAnKStart";
	protected $dateEnde = "useBAAnKEnde";
	
	function __construct() {
		$this->useVariables(array("useBAAnKStart", "useBAAnKEnde", "useBAAnKArt", "useBAAnKKunde"));
		
 		parent::__construct();
		$this->customize();
		
		if(Applications::activeApplication() != "open3A" AND Applications::activeApplication() != "openFiBu") 
			return;
		
 		if(!Session::isPluginLoaded("Auftraege"))
			return;
 		
 		
		$DB = new DBStorage();
		$C = $DB->getConnection();
		$C->query("SET SQL_BIG_SELECTS=1");
		
 		$ac = anyC::get("GRLBM");
		if($this->userdata["useBAAnKArt"] != ""){
			if(strpos("GRLBMA", $this->userdata["useBAAnKArt"]) !== false)
		 		$ac->addAssocV3("is".$this->userdata["useBAAnKArt"], "=", "1");
			else
				$ac->addAssocV3("isWhat", "=", $this->userdata["useBAAnKArt"]);
		} else
			$ac->addAssocV3("isM","=","0");
		$ac->addJoinV3("Auftrag", "AuftragID", "=", "AuftragID");
 		#$ac->addAssocV3("isG","=","1","OR","2");
		$ac->addOrderV3("datum","ASC");
		$ac->addOrderV3("nummer","ASC");
		$ac->addJoinV3("Posten","t1.GRLBMID","=","GRLBMID");
		#$ac->addJoinV3("Auftrag","AuftragID","=","AuftragID");
		$ac->addJoinV3("Adresse","t2.AdresseID","=","AdresseID");
		$ac->addGroupV3("t1.GRLBMID");
		$ac->addAssocV3("datum", ">=", Util::CLDateParser($this->userdata[$this->dateStart], "store"));
		$ac->addAssocV3("datum", "<=", Util::CLDateParser($this->userdata[$this->dateEnde], "store"));

		if($this->userdata["useBAAnKKunde"]){
			$K = Kappendix::getKappendixIDToAdresse($this->userdata["useBAAnKKunde"], true);
			$ac->addAssocV3("kundennummer", "=", $K);
		}
		
		$ac->setFieldsV3(array(
			"nummer",
			"datum",
			"bruttobetrag AS Summe",
			"steuern AS USt",
			"nettobetrag AS Netto",
			"firma",
			"beschreibung",
			#"isA",
			#"isAbschlussrechnung",
			"t1.AuftragID",
			#"GRLBMpayedDate",
			#"GRLBMpayedVia",
			#"isPayed",
			"t1.GRLBMID",
			"prefix AS belegTyp",
			"CONCAT(IF(firma='', CONCAT(vorname, ' ', nachname), firma), '\n', strasse, ' ', nr, '\n', plz, ' ', ort) AS Name",
			"IF(kundennummer > 0, kundennummer, '') AS kundennummer"));
		
		$ac->setParser("datum","Util::CLDateParser");

		Aspect::joinPoint("alter", $this, __METHOD__, array($ac));
		
 		$this->collection = $ac;
		
		Aspect::joinPoint("after", $this, __METHOD__, array($ac));
 	}
	
	public function getCategory(){
		return "Aufträge";
	}
	
	public function setCollection($c){
		$this->collection = $c;
	}
	
 	public function getLabel(){
		return "Belege Kunden";
 	}
	
 	public function getHTML($id){
 		$phtml = parent::getHTML($id);

		$F = new HTMLForm("BC", array_merge($this->variables, array("useBAAnKKundeDisplay")), "Zeitraum");
		$F->getTable()->setColWidth(1, 120);
		
		$Adresse = new Adresse(($this->userdata != null AND isset($this->userdata["useBAAnKKunde"])) ? $this->userdata["useBAAnKKunde"] : "");
		$F->setValue("useBAAnKKundeDisplay", $Adresse->getShortAddress());
		
		$arten = array("" => "Alle", "R" => "Rechnungen", "A" => "Angebote", "B" => "Bestätigungen", "G" => "Gutschriften");
		$new = Aspect::joinPoint("belegartenNeu", $this, __METHOD__, array($arten), []);
		foreach($new AS $b => $n)
			$arten[$b] = $n;
		
		$F->setType("useBAAnKStart", "date", $this->userdata["useBAAnKStart"]);
		$F->setType("useBAAnKEnde", "date", $this->userdata["useBAAnKEnde"]);
		$F->setType("useBAAnKArt", "select", $this->userdata["useBAAnKArt"], $arten);
		
		$F->setLabel("useBAAnKStart", "Start");
		$F->setLabel("useBAAnKEnde", "Ende");
		$F->setLabel("useBAAnKArt", "Belegart");
		$F->setLabel("useBAAnKKundeDisplay", "Kunde");
		
		$F->inputLineStyle("useBAAnKKunde", "display:none;");
		
		$F->setAutoComplete("useBAAnKKundeDisplay", "mAdresse", "function(s){ \$j('[name=useBAAnKKunde]').val(s.AdresseID); \$j('[name=useBAAnKKundeDisplay]').val(s.label); return false; }");
		
		$F->setSaveBericht($this);
		$F->useRecentlyChanged();
		
 		return $phtml.$F;
 	}
	
 	public function getPDF($save = false){
 				
 		$this->setAlignment("Summe","R");
 		$this->setAlignment("nummer","R");
 		$this->setAlignment("USt","R");
 		$this->setAlignment("Netto","R");
 		$this->setAlignment("kundennummer","R");

		$this->fieldsToShow = array("nummer","belegTyp","datum","Netto","USt","Summe","Name", "kundennummer");
 		$this->setLabel("nummer", "Beleg Nr.");
 		$this->setLabel("Name","Kunde");
 		$this->setLabel("Summe","Brutto");
 		$this->setLabel("belegTyp","");
 		$this->setLabel("kundennummer","KdNr");
		
 		$this->setColWidth("Name","50");
 		$this->setColWidth("belegTyp","5");
 		$this->setColWidth("kundennummer","10");
 	
		$this->setLineParser("after", "Bericht_AlleBelegeNachKundeGUI::parserLine");
		
		$this->setFieldParser("Summe","Util::PDFCurrencyParser");
		$this->setFieldParser("USt","Util::PDFCurrencyParser");
		$this->setFieldParser("Netto","Util::PDFCurrencyParser");
		
		$this->calcSum("Summe",array("Netto","USt","Summe"));
		
		$this->setSumParser("Netto", "Util::PDFCurrencyParser");
		$this->setSumParser("USt", "Util::PDFCurrencyParser");
		$this->setSumParser("Summe", "Util::PDFCurrencyParser");

		$this->sumFontSize = 8;
		
 		$this->setType("Name","MultiCell");
		
 		$this->setPageBreakMargin(260);
 		
		#if(get_class($this) == "Bericht_AlleBelegeNachKundeGUI")
		if($this->userdata["useBAAnKArt"] != "")
			$this->setHeader(Stammdaten::getPluralType($this->userdata["useBAAnKArt"])." im Zeitraum ".$this->userdata["useBAAnKStart"]." - ".$this->userdata["useBAAnKEnde"]);
		else
			$this->setHeader("Alle Belege im Zeitraum ".$this->userdata["useBAAnKStart"]." - ".$this->userdata["useBAAnKEnde"]);

 		return parent::getPDF($save);
 	}
	
	public static function parserLine(FPDF $fpdf, $E){
		$fpdf->SetDrawColor(190, 190, 190);
		$fpdf->Line(10,$fpdf->GetY(),200, $fpdf->GetY());
		$fpdf->SetDrawColor(0, 0, 0);
		
		$fpdf->SetFontSize(8);
		$fpdf->SetTextColor(100);
		$AC = anyC::get("Posten", "GRLBMID", $E->A("GRLBMID"));
		while($P = $AC->getNextEntry()){
			if($fpdf->GetY() > 280)
				$fpdf->AddPage ();
			
			$fpdf->Cell8(20, 4.5, "");
			$fpdf->Cell8(25, 4.5, mb_substr($P->A("name"), 0, 18));
			$fpdf->Cell(20, 4.5, Util::PDFCurrencyParser($P->A("preis") * $P->A("menge")), "", 0, "R");
			$fpdf->Cell(20, 4.5, Util::PDFCurrencyParser(($P->A("bruttopreis") - $P->A("preis")) * $P->A("menge")), "", 0, "R");
			$fpdf->Cell(20, 4.5, Util::PDFCurrencyParser($P->A("bruttopreis") * $P->A("menge")), "", 0, "R");
			$ex = explode("\n", $P->A("beschreibung"));
			$fpdf->Cell8(0, 4.5, mb_substr($ex[0], 0, 50).(mb_strlen($ex[0]) > 50 ? "..." : ""), "", 1);
		}
		if($AC->numLoaded() == 0){
			$fpdf->Cell8(20, 4.5, "");
			$fpdf->Cell8(25, 4.5, "Keine Positionen", "", 1);
		}
		
		$fpdf->SetTextColor(0);
		$fpdf->SetFontSize(9);
		$fpdf->ln(5);
	}
 } 
 ?>