<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class BelegnummernEditor extends Auftrag implements iReNr {
	private static $time;
	
	function getLabel() {
		return "Belegnummerneditor";
	}

	function time($timestamp){
		self::$time = $timestamp;
	}
	
	public static function rewind(GRLBM $GRLBM, Auftrag $Auftrag, Stammdaten $Stammdaten){
		$type = $GRLBM->getMyPrefix();
		
		$next = mUserdata::getGlobalSettingValue("belegNummerNext$type", 1);
		if($next == 1)
			return;
		
		$current = $GRLBM->A("nummer");
		
		$nummer = self::replace($Stammdaten, $next - 1, false, $Auftrag);

		if($current != $nummer)
			return;
		
		mUserdata::setUserdataS("belegNummerNext$type", --$next, "belegNummer", -1);
	}
	
	public static function getNextNumber($type, Auftrag $Auftrag = null) {
		#do {
			$nummer = self::getNext($type, $Auftrag);
		#} while($nummer !== null AND self::exists($type, $nummer));
		
		return $nummer;
	}
	
	private static function exists($type, $nummer){
		$is = array("R", "L", "G", "B", "M", "A");
		$AC = anyC::get("GRLBM");
		
		$AC->addAssocV3("TRIM(nummer)", "LIKE", $nummer);
		
		if(in_array($type, $is)){
			$AC->addAssocV3("is$type", "=", "1", "AND", "2");
			
			if($type == "A" AND !in_array("B", Auftrag::getBelegArten()))
				$AC->addAssocV3("isB", "=", "1", "OR", "2");
		} else
			$AC->addAssocV3 ("isWhat", "=", $type);

		if($type == "A" AND !in_array("B", Auftrag::getBelegArten()))
			$AC->addAssocV3("isB", "=", "1", "OR");
		$AC->setFieldsV3(array("nummer"));
		
		$F = $AC->n();
		
		return $F !== null;
	}
	
	private static function getNext($type, Auftrag $Auftrag = null){
		$S = Stammdaten::getActiveStammdaten();
		#$DB = new DBStorage();
		#$C = $DB->getConnection();
		
		switch ($S->A("belegNummerResetR")) {
			case "":
				#$C->query("")
				$next = mUserdata::getGlobalSettingValue("belegNummerNext$type", 1);
				
				$nummer = self::replace($S, $next, false, $Auftrag);
				
				mUserdata::setUserdataS("belegNummerNext$type", ++$next, "belegNummer", -1);
				
				return $nummer;
			break;
			
			case "yearly":
			case "monthly":
			#case "daily":
				$next = mUserdata::getGlobalSettingValue("belegNummerNext$type", 1);
				
				/*
				$test = self::replace($S, $next > 1 ? $next - 1 : 1, $S->A("belegNummerResetR") == "yearly", $Auftrag);
				$AC = anyC::get("GRLBM");
				if(strpos("RLGBMA", $type) !== false)
					$AC->addAssocV3("is$type", "=", "1");
				else
					$AC->addAssocV3("isWhat", "=", $type);

				if($type == "A" AND !in_array("B", Auftrag::getBelegArten()))
					$AC->addAssocV3("isB", "=", "1", "OR");

				$AC->addAssocV3("TRIM(nummer)", "LIKE", $test);
				$AC->setFieldsV3(array("nummer"));


				$E = $AC->getNextEntry();
				if($E == null)
					$next = 1;*/
				
				$nummer = self::replace($S, $next, false, $Auftrag);
				
				
				mUserdata::setUserdataS("belegNummerNext$type", ++$next, "belegNummer", -1);
				
				return $nummer;
			break;
		
			case "daily":
				$next = mUserdata::getGlobalSettingValue("belegNummerNext$type", 1);
				
				/*
				$test = self::replace($S, $next > 1 ? $next - 1 : 1, $S->A("belegNummerResetR") == "yearly", $Auftrag);
				$AC = anyC::get("GRLBM");
				if(strpos("RLGBMA", $type) !== false)
					$AC->addAssocV3("is$type", "=", "1");
				else
					$AC->addAssocV3("isWhat", "=", $type);

				if($type == "A" AND !in_array("B", Auftrag::getBelegArten()))
					$AC->addAssocV3("isB", "=", "1", "OR");

				$AC->addAssocV3("TRIM(nummer)", "LIKE", $test);
				$AC->setFieldsV3(array("nummer"));


				$E = $AC->getNextEntry();
				if($E == null)
					$next = 1;*/
				
				$test = self::replace($S, 1, false, $Auftrag);
				if(!self::exists($type, $test, $Auftrag->A("AuftragStammdatenID"))) { 
					$nummer = $test;
					$next = 1;
				} else
					$nummer = self::replace($S, $next, false, $Auftrag);
				
				#$nummer = self::replace($S, $next, false, $Auftrag);
				
				
				mUserdata::setUserdataS("belegNummerNext$type", ++$next, "belegNummer", -1);
				
				return $nummer;
			break;
			
		}
		
		return null;
	}
	
	private static function replace($S, $next, $wildcardMonth = false, Auftrag $Auftrag = null){
		$time = time();
		if(self::$time)
			$time = self::$time;
		
		$replace = array(
			"{J}" => date("Y", $time),
			"{J2}" => date("y", $time),
			"{T}" => str_pad(date("z", $time), 3, "0", STR_PAD_LEFT),
			"{TM}" => str_pad(date("d", $time), 2, "0", STR_PAD_LEFT),
			"{M}" => $wildcardMonth ? "%" : date("m", $time),
			"{M1}" => $wildcardMonth ? "%" : date("m", $time) * 1
		);
		
		if($Auftrag != null)
			$replace["{K}"] = $Auftrag->A("kundennummer") > 0 ? $Auftrag->A("kundennummer") : 0;

		$nummer = $S->A("belegNummerFormatR");
		if($nummer == "")
			$nummer = "{J}{N:3}";
		foreach($replace AS $k => $v)
			$nummer = str_replace($k, $v, $nummer);

		$useNext = $next;
		preg_match("/\{N:([0-9]+)\}/", $nummer, $matches);
		if(isset($matches[1])){
			$useNext = str_pad($next, $matches[1], "0", STR_PAD_LEFT);
			$nummer = str_replace($matches[0], $useNext, $nummer);
		}
		
		return $nummer;
	}

}

?>