<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class AuftragGUI extends Auftrag implements iGUIHTML2 {
	public $newDisplayedFields = array();
	protected $showRowKundennummer = true;
	protected $showRowLieferantennummer = false;
	protected $showRowUStIdNr = true;
	public $showButtonEditAdresse = true;
	protected $showButtonsBeleg = true;
	
	public function newDisplayedFields(array $fields){
		$this->newDisplayedFields = array_merge($this->newDisplayedFields, $fields);
	}

	function getHTML($id){
		T::load(__DIR__, "Auftraege");
		$pSpecData = mUserdata::getPluginSpecificData("Auftraege");
		$bps = $this->getMyBPSData();

		$gui = new HTMLGUI();
		$gui->setObject($this);
		
		if($this->A ==  null AND $id != -1) $this->loadMe();
		
		if($id == -1)
			$id = $this->newWithDefaultValues();
		
		$this->checkUserRestrictions($pSpecData);

		$_SESSION["BPS"]->registerClass("mGRLBMGUI");
		$_SESSION["BPS"]->setACProperty("AuftragID", $this->ID);
		
		$d = null;
		#$BelegeTab = new HTMLSideTable("right");
		$L = new HTMLList();
		$L->addListStyle("list-style-type:none;padding-top:0px;margin-left:10px;");
		
		if(Session::isPluginLoaded("mMail")){
			$AC = anyC::get("DBMail2Object", "DBMail2ObjectTargetClass", "Auftrag");
			$AC->addAssocV3("DBMail2ObjectTargetClassID", "=", $this->getID());
			$M = $AC->n();
			if($M){
				$Bu = new Button("E-Mails", "mail");
				$Bu->id("EMailButton");
				#$Bu->className("backgroundColor2");
				$Bu->rmePCR("Auftrag", $this->getID(), "listEMails", "", "function(t){ \$j('#subframe').html(t.responseText); }");
				#$Bu->onclick("Auftrag.createGRLBM('$this->ID','Auftrag','$B');");
				
				
				$Bu->style("width:100%;min-width:120px;background-position: calc(100% - 3px) center;");
				
				$L->addItem ($Bu);
				$L->addItemStyle("display:inline-block;margin-top:10px;max-width:150px;margin-left:0px;margin-right:15px;width:calc(25% - 15px);");
			}
		}
		
		$i = 0;
		foreach($this->getBelegArten() AS $B){
			if(isset($pSpecData["pluginSpecificCanOnlySeeKalk"]) AND $B != "Kalk") 
				continue;
			
			if(isset($pSpecData["pluginSpecificCantCreate$B"])) 
				continue;
			
			#if(isset($pSpecData["pluginSpecificCantCreateR"]) AND $B == "R") continue;
			#if(isset($pSpecData["pluginSpecificCantCreateL"]) AND $B == "L") continue;
			#if(isset($pSpecData["pluginSpecificCantCreateG"]) AND $B == "G") continue;
			#if(isset($pSpecData["pluginSpecificCantCreateA"]) AND $B == "A") continue;

			$_SESSION["BPS"]->setACProperty("type", $B);
			$tests = new mGRLBMGUI();
			$tests->addAssocV3("AuftragID", "=", $this->ID);
			
			$tests->lCV3();
			$test = $tests->getNextEntry();

			if($this->showButtonsBeleg){
				if($tests->numLoaded() <= 1)
					$label = Stammdaten::getLongType($B);
				else
					$label = Stammdaten::getPluralType($B);
				
				$Bu = new Button($label, Stammdaten::getIconType($B));
				$Bu->onclick("Auftrag.createGRLBM('$this->ID','Auftrag','$B');");
				$Bu->name($test == null ? "1" : "2");
				$Bu->id($B."Button");
				$Bu->style("width:100%;min-width:120px;background-position: calc(100% - 3px) center;");
				
				Aspect::joinPoint("belegButtons", $this, __METHOD__, array($Bu));
				
				if($test == null)
					$Bu->className("backgroundColor0");

				$L->addItem($Bu);
				$L->addItemStyle("display:inline-block;margin-top:10px;max-width:150px;margin-left:0px;margin-right:15px;width:calc(25% - 15px);");#.($i > 0 ? "margin-left:15px;" : "margin-left:10px;"));
			}
			
			if($test != null AND ($B != "Kalk" OR $d == null))
				$d = $tests;

			$i++;
		}

		$js = "";
		if($bps != -1 AND isset($bps["GRLBMID"])){ //Load specific GRLBM
			$d = new GRLBMGUI($bps["GRLBMID"]);
			BPS::unsetProperty("AuftragGUI", "GRLBMID");
			$js .= OnEvent::script("\$j('#".$d->getMyPrefix()."Button').removeClass('backgroundColor3').removeClass('backgroundColor0').addClass('backgroundColor1');");
		}
		

		$html = "";

		$ADTab = new HTMLTable(2);
		$ADTab->setTableStyle("width:100%;border:0px;");
		$ADTab->setColWidth(1, 150);
		$ADTab->weight("light");
		
		$ADTab2 = new HTMLTable(2);
		$ADTab2->setTableStyle("width:100%;border:0px;");
		$ADTab2->setColWidth(1, 120);
		$ADTab2->weight("light");
		

		$anyC = anyC::get("Auftrag", "AdresseID", $this->A("AdresseID"));
		$AdresseUsed = $anyC->getTotalNum();
		
		
		$confirmMessage = "if(confirm('Achtung: Beim Bearbeiten der Adresse über diesen Knopf geht die Verbindung zur Kundennummer und die USt-IdNr verloren! Die Adressänderung wirkt sich auf alle Belege in diesem Auftrag aus. Fortfahren?'))";
		$confirmChange = Aspect::joinPoint("changeAdresseConfirm", $this, __METHOD__, array($confirmMessage), $confirmMessage);
		
		
		$ButtonEditAdresse = new Button("Adresse bearbeiten","./images/i2/edit.png", "icon");
		$ButtonEditAdresse->style("float:right;");
		if($AdresseUsed == 1){
			$ButtonEditAdresse->doBefore("$confirmChange %AFTER");
			$ButtonEditAdresse->editInPopup("AuftragAdresse", $this->A("AdresseID"));#"contentManager.loadFrame('contentRight','Adresse',{$this->A->AdresseID},0,'AdresseGUI;displayMode:auftragsAdresse;AuftragID:$this->ID')");
		} else
			$ButtonEditAdresse->onclick("alert('Diese Adresse kann nicht bearbeitet werden, da sie in ".($AdresseUsed - 1)." anderen ".($AdresseUsed == 2 ? "Auftrag" : "Aufträgen")." verwendet wird.');");

		if(!$this->showButtonEditAdresse)
			$ButtonEditAdresse = "";
		
		
		$Adresse = new Adresse($this->A("AdresseID"));

		$AspectAdresse = Aspect::joinPoint("adresse", $this, __METHOD__, $Adresse);
		if($AspectAdresse != null) $Adresse = $AspectAdresse;

		
		$BKlickTel = "";
		if(Session::isPluginLoaded("mklickTel")){
			$BKlickTel = klickTel::getButtonSmall($this->A("AdresseID"));
			$BKlickTel->style("float:right;margin-right:10px;");
		}
		
		$BA = "";
		if($this->A("kundennummer") > 0){
			$AdresseID = Kappendix::getAdresseIDToKundennummer($this->A("kundennummer"));
			$BA = new Button("Adresse öffnen", "./images/i2/redo.png", "icon");
			$BA->loadPlugin("contentRight", "Adressen", "", $AdresseID, "{single:'Adresse'}");
			$BA->style("float:right;margin-right:10px;");
		}
		
		$BNew = new Button("In Kunde umwandeln", "./images/i2/kunde.png", "icon");
		$BNew->style("float:right;");
		$BNew->onclick("if(confirm('Möchten Sie diese Adresse in die Datenbank übernehmen und eine Kundennummer anlegen?')) ".OnEvent::rme($this, "makeToCustomer", array(), OnEvent::reload("Left")));
		if($this->A("kundennummer") > 0)
			$BNew = "";
		
		$ADTab->addRow(
			($this->A("AdresseID") != "0" ? "<div style=\"float:right;\">".$this->alterAdresseButtons()."<br />".$ButtonEditAdresse."</div>$BKlickTel".($this->A("AdresseID") != "0" ? $Adresse : "") : "<div style=\"float:right;\">".$this->alterAdresseButtons()."</div>").
			($this->showRowKundennummer ? "<div style=\"clear:both;\"><span style=\"color:grey;\">{$BNew}".T::_("Kundennummer").": ". ($this->A("kundennummer") > 0 ? AdressenGUI::getContactButton($this->A("kundennummer")).$BA.$this->A("kundennummer") : "keine")."</span></div>" : ""));
		$ADTab->addRowColspan(1, 2);
		$ADTab->addCellStyle(1, "padding-left:0px;");
		
		if(Session::isPluginLoaded("mStatistik") AND Session::isPluginLoaded("Uebersicht") AND $this->A("kundennummer") > 0){
			$Zahlungsmoral = ZahlungsmoralGUI::getAverage($this->A("kundennummer"));
			$ADTab->addRow(array(T::_("Zahlungsmoral").": ".$Zahlungsmoral." Tag".($Zahlungsmoral == 1 ? "" : "e")));
			$ADTab->addRowColspan(1, 2);
			$ADTab->addCellStyle(1, "padding-left:0px;");

		}
		
		$userHiddenPlugins = mUserdata::getHiddenPlugins(true);
		if(Session::isPluginLoaded("Uebersicht") AND $this->A("kundennummer") > 0 AND !isset($userHiddenPlugins["Uebersicht"])){
			$AC = anyC::get("Auftrag", "kundennummer", $this->A("kundennummer"));
			$AC->addJoinV3("GRLBM", "AuftragID", "=", "AuftragID");
			$AC->addAssocV3("GRLBMID", "IS NOT", "NULL");
			$AC->addAssocV3("isPayed", "=", "0");
			$AC->addAssocV3("isR", "=", "1", "AND", "2");
			$AC->addAssocV3("isG", "=", "1", "OR", "2");
			$AC->setFieldsV3(array("SUM(bruttobetrag) AS bruttobetrag2", "isG", "GRLBMID", "COUNT(*) AS anz", "GROUP_CONCAT(DISTINCT GRLBMID SEPARATOR ',') AS ids"));
			$AC->addGroupV3("isR");
			$AC->addGroupV3("isG");
			
			$mahnungen = 0;
			$op = 0;
			$opi = 0;
			while($G = $AC->n()){
				$op += $G->A("bruttobetrag2") * ($G->A("isG") ? -1 : 1);
				$opi += $G->A("anz");
				#echo $G->A("ids");
				$ACM = anyC::get("GRLBM", "isM", "1");
				$ACM->addAssocV3("AuftragID", "IN", "(".trim($G->A("ids"), ",").")");
				$ACM->setFieldsV3(array("COUNT(DISTINCT AuftragID) AS anz"));
				$ACM->addGroupV3("isM");
				$count = $ACM->n();
				if($count)
					$mahnungen += $count->A("anz");
			}
			
			$gemahnt = "";
			if($mahnungen > 0)
				$gemahnt = "<br><span style=\"text-align:center;width:100%;background-color:rgba(220, 50, 0, 0.8);display:inline-block;padding:5px;color:white;font-weight:bold;\">Davon gemahnt: $mahnungen</span>";
			
			$ADTab->addRow(array(T::_("Aktuell offene Posten").": ".$opi." (".Util::CLFormatCurrency($op).")$gemahnt"));
			$ADTab->addRowColspan(1, 2);
			$ADTab->addCellStyle(1, "padding-left:0px;");

		}
		
		if(Session::isPluginLoaded("mAdresseNiederlassung") AND $this->A("kundennummer") > 0){
			$AC = AdresseNiederlassung::get(Kappendix::getAdresseIDToKundennummer($this->A("kundennummer")));

			if($AC->numLoaded() > 0){
				$options = array("0" => "Keine");
				
				while($N = $AC->n()){
					$l = $N->A("AdresseNiederlassungPLZ")." ".$N->A("AdresseNiederlassungOrt").($N->A("AdresseNiederlassungStrasse") != "" ? ", ".$N->A("AdresseNiederlassungStrasse")." ".$N->A("AdresseNiederlassungNr") : "");
					if($N->A("AdresseNiederlassungBelegtext") != "")
						$l = $N->A("AdresseNiederlassungBelegtext");
					
					$options[$N->getID()] = $l;
				}
				if(!isset($options[$this->A("AuftragAdresseNiederlassungID")]))
					$options[$this->A("AuftragAdresseNiederlassungID")] = "Unbekannt (wurde evtl. gelöscht)";
				
				$I = new HTMLInput("AuftragAdresseNiederlassungID", "select", $this->A("AuftragAdresseNiederlassungID"), $options);
				$I->activateMultiEdit("Auftrag", $this->getID());
				
				$ADTab2->addLV("Filiale:", $I);
			}
			
		}
		
		
		if($this->showRowLieferantennummer)
			$ADTab2->addLV(T::_("LieferantenNr.").":", $this->A->lieferantennummer != -2 ? $this->A("lieferantennummer") : "keine");
		
		
		if($this->showRowUStIdNr)
			$ADTab2->addLV(T::_("USt-IdNr/St.Nr.").":", "<input type=\"text\" value=\"".$this->A->UStIdNr."\" ".(Aspect::joinPoint ("ustidReadonly", $this, __METHOD__, null, $this->A->kundennummer == -2) ? " class=\"multiEditInput2\" onfocus=\"oldValue = this.value;\" onblur=\"if(oldValue != this.value) saveMultiEditInput('Auftrag','".$this->getID()."','UStIdNr');\" id=\"UStIdNrID".$this->getID()."\" type=\"text\" onkeydown=\"if(event.keyCode == 13) saveMultiEditInput('Auftrag','".$this->getID()."','UStIdNr');\" style=\"width:95%;text-align:left;\"" : "readonly=\"readonly\"")." />");

		
		if(Session::isPluginLoaded("mProjekt") AND $this->A("kundennummer") > 0){
			$O = array("kein Projekt");
			$AC = anyC::get("Projekt", "ProjektKunde", Kappendix::getAdresseIDToKundennummer($this->A("kundennummer")));
			$AC->addAssocV3("ProjektStatus", "=", "0", "AND", "2");
			$AC->addAssocV3("ProjektStatus", "=", "1", "OR", "2");
			$AC->addOrderV3("ProjektName");
			Aspect::joinPoint("projects", $this, __METHOD__, array($AC));
			while($P = $AC->getNextEntry())
				$O[$P->getID()] = $P->A("ProjektName");
			
			$P = new Projekt($this->A("ProjektID"));
			$O[$P->getID()] = $P->A("ProjektName");
			
			$PI = new HTMLInput("ProjektID", "select", $this->A("ProjektID"), $O);
			$PI->onchange("if(\$j(this).val() != 0) { \$j('#AuftragProjektEditButton').show(); \$j('#AuftragProjektNewButton').hide(); } else { \$j('#AuftragProjektEditButton').hide(); \$j('#AuftragProjektNewButton').show(); }");
			$PI->activateMultiEdit("Auftrag", $this->getID());
			
			
			$BNew = new Button("Projekt erstellen", "./images/i2/new.png", "icon");
			$BNew->style("float:right;margin-top:4px;");
			$BNew->popup("", "Projekt erstellen", "Projekt", "-1", "newForAuftragPopup", array($this->getID()));
			$BNew->id("AuftragProjektNewButton");
			if($this->A("ProjektID") != "0")
				$BNew->style("float:right;margin-top:4px;display:none;");
			
			
			$BEdit = new Button("Projekt bearbeiten", "./images/i2/edit.png", "icon");
			$BEdit->style("float:right;margin-top:4px;");
			$BEdit->popup("", "Projekt bearbeiten", "Projekt", "'+\$j('#ProjektIDID".$this->getID()."').val()+'", "editForAuftragPopup", array($this->getID()));
			$BEdit->id("AuftragProjektEditButton");
			if($this->A("ProjektID") == "0")
				$BEdit->style("float:right;margin-top:4px;display:none;");
			
			
			Aspect::joinPoint("alterProjekt", $this, __METHOD__, array($BNew, $BEdit, $PI));
			
			$ADTab2->addLV("Projekt:", $BNew.$BEdit.$PI);
		}
		
		
		if(Session::isPluginLoaded("mBestellung")){
			if(!Session::isPluginLoaded("mProjekt")){
				$ADTab2->addRow(array());
				$ADTab2->addRowClass("backgroundColor0");
			}
			
			$Order = anyC::getFirst("Bestellung", "BestellungAuftragID", $this->getID());
			if($Order != null){
				$BOrder = new Button("Bestellung anzeigen", "./ubiquitous/Bestellungen/Bestellung18.png", "icon");
				$BOrder->style("float:right;");
				$BOrder->loadPlugin("contentRight", "mBestellung", "", $Order->getID());
				
				$O = $BOrder."Bestellnummer ".($Order->getNummer());
			} else {
				$BOrder = new Button("Bestellung erstellen", "./ubiquitous/Bestellungen/Bestellung18.png", "icon");
				$BOrder->style("float:right;");
				$BOrder->rmePCR("Bestellung", "-1", "createFromAuftrag", $this->getID(), "function(transport){ contentManager.loadPlugin('contentRight', 'mBestellung', '', transport.responseText); }");
				
				$O = $BOrder."keine Bestellung zugeordnet";
			}
			
			$ADTab2->addLV("Bestellung:", $O);
		}
		
		
		$gui->customize($this->customizer);
		
		foreach($this->newDisplayedFields AS $label => $value)
			$ADTab2->addLV($label, $value);

		$html .= "$js
	<div style=\"min-height:50px;\" id=\"subframe\">".($d != null ? $d->getHTML(-1,0) : "")."</div>";

		$BOP = $gui->getOperationsHTML(get_parent_class($this),$this->ID);
		$BOP->type("iconicG");
		$BOP->style("margin-top:13px;margin-left:5px;");
		
		return "<div class=\"prettyTitle\">".T::_("Auftrag").$BOP."</div>
			<div class=\"AuftragBelegContent\">
				<div style=\"width:270px;display:inline-block;vertical-align:top;\">
					<div style=\"padding-left:10px;padding-right:10px;\">".$ADTab."</div>
				</div>
				<div style=\"width:calc(100% - 275px);display:inline-block;vertical-align:top;\">
					<div style=\"padding-left:10px;padding-right:10px;border-left:1px solid #DDD;\">".$ADTab2."</div>
				</div>
			</div>
			".($this->showButtonsBeleg ? "<div style=\"height:40px;\"></div><div id=\"AuftragMessage\"></div><div style=\"padding-right:10px;\" class=\"AuftragBelegContent backgroundColor4\"><div class=\"prettySubtitle\" style=\"\">".T::_("Belege des Auftrags")."</div><div class=\"AuftragBelegContent backgroundColor3\" id=\"AuftragBelegeOperations\" style=\"padding-right:10px;\">".$L."</div></div>" : "").$html.OnEvent::script("Auftrag.reWidth();");
	}
	
	public function listEMails(){
		#echo $this->getID();
		$Mail = new mDBMail2ObjectGUI(-1);
		$Mail->setOwner("Auftrag", $this->ID);#
		echo "<div style=\"clear:right;padding-top:60px;\" class=\"prettySubtitle\">E-Mails zu diesem Auftrag</div><div style=\"min-height:300px;\">".$Mail->getTable()."</div>";
		echo OnEvent::script("Auftrag.highlightSection('EMail');Auftrag.reWidth();");
		#$GUIF->addTab($Mail, "Mails", "./lightCRM/Mail/Mail.png");
	}
	
	public function makeToCustomer(){
		$A = new Adresse($this->A("AdresseID"));
		$A->changeA("AuftragID", "-1");
		$A->changeA("type", "default");
		$id = $A->newMe();
		
		$Kunden = new Kunden();
		$KID = $Kunden->createKundeToAdresse($id);
		$K = new Kappendix($KID);
		
		$this->changeA("kundennummer", $K->A("kundennummer"));
		$this->saveMe();
	}
	
	public function alterAdresseButtons(){
		$BAdresse = new Button("Adresse\n".($this->A->AdresseID != 0 ? "ändern" : "hinzufügen"), "./open3A/Auftraege/lieferAdresse.png", "icon");
		#$BAdresse->loadFrame("contentRight", "Adressen", -1, 0, "AdressenGUI;selectionMode:singleSelection,Auftrag,$this->ID,getAdresseCopy,Auftraege,contentLeft,Auftrag,$this->ID");
		$BAdresse->select(false, "Adressen", "Auftrag", $this->getID(), "getAdresseCopy");
		#$B1xAdresse = new Button("1x-Adresse\nerstellen", "1xAddress");
		#$B1xAdresse->style("float:right;");
		#$B1xAdresse->loadFrame('contentRight', 'Adresse', -1, 0, "AdresseGUI;AuftragID:$this->ID;displayMode:auftragsAdresse");
		#$B1xAdresse->id("Button1xAdresse");
		
		return $BAdresse;
	}
/*
	public static function renrParser($w,$l,$p){
		$s = HTMLGUI::getArrayFromParametersString($p);
		if($w != "") return "<input type=\"text\" value=\"$w\" id=\"rechnungNummer\" name=\"rechnungNummer\" readonly=\"readonly\" />";
		else return "<input type=\"button\" value=\"Rechnung erstellen\" onclick=\"createRechnung('$s[0]','".$s[1]."');\" />";
	}*/

	public function getAdresseCopy($AdresseID){
		parent::getAdresseCopy($AdresseID);
		echo "Adresse übernommen";
	}

	public function createGRLBM($type, $returnID = false, $belegNummer = false, $referenz = "", $datum = null, $additional = array()){
		echo parent::createGRLBM($type, $returnID, $belegNummer, $referenz, $datum, $additional);
	}

	function getGRLBMPDF($copy, $pdf = null, $GRLBMID = null, $print = false, $subBeleg = null, $isPreview = false){
		try {
			Aspect::joinPoint("checks", $this, __METHOD__, array($copy, $GRLBMID));

			if($GRLBMID == null)
				throw new Exception("No GRLBM ID given in ".__FILE__." in method ".__METHOD__);

			if($pdf == "") 
				$pdf = "";

			$brief = $this->getLetter("", $copy == "true" ? true : false, $GRLBMID, $print, $subBeleg, $isPreview);
			if(Util::usePDFViewer() AND $pdf == null){
				$filename = $brief->generate(true, $pdf);
				Util::PDFViewer($filename);
			} else $brief->generate(false, $pdf);
			
			if($print){
				$G = new GRLBM($GRLBMID, false);
				$G->markMeAsPrinted($copy == "true");
				#$G->changeA("isPrinted".($copy == "true" ? "Copy" : ""), "1");
				#$G->changeA("isPrinted".($copy == "true" ? "Copy" : "")."Time", time());
				#$G->saveMe(true, false, false);
				
				#if(Session::isPluginLoaded("mNextcloudUser")){
				#	$NU = NextcloudUser::getUser();
				#	if($NU AND $NU->A("NextcloudUserAutoupload"))
				#		$NU->getFileForUpload("Auftrag", $this->getID(), $GRLBMID, true);
				#}
			}
			
		} catch(TableDoesNotExistException $e){
			echo Util::getBasicHTMLError("<p class=\"error\" style=\"font-size:15px;font-weight:bold;\">".get_class($e).": ".$e->getTable()."</p>", "Es ist ein Fehler aufgetreten!");
		}  catch(ClassNotFoundException $e){
			$S = new SupportGUI();
			echo Util::getBasicHTMLError($S->fatalError($e->getTraceAsString(), "", true, true), "Es ist ein Fehler aufgetreten!");
		} catch (Exception $e){
			$S = new SupportGUI();
			echo Util::getBasicHTMLError($S->fatalError($e->getTraceAsString(), "", true, true), "Es ist ein Fehler aufgetreten!");
			
			#echo Util::getBasicHTMLError("<p class=\"error\" style=\"font-size:15px;font-weight:bold;\">".get_class($e).": ".$e->getMessage()."</p>", "Es ist ein Fehler aufgetreten!");
		}
	}

	function getGRLBMPDFPreview($copy, $pdf = null, $GRLBMID = null){
		if($GRLBMID == null)
			throw new Exception("No GRLBM ID given in ".__FILE__." in method ".__METHOD__);

		if($pdf == "") $pdf = "";

		$brief = $this->getLetter("", $copy == "true" ? true : false, $GRLBMID);
		$brief->generate(false, $pdf);
	}

	public static function getEMailTBs(Adresse $A, Stammdaten $Stammdaten, GRLBM $GRLBM, $die = true){
		$alteredA = Aspect::joinPoint("alterAdresse", __CLASS__, __METHOD__, array($A, $GRLBM), $A);
		#if($alteredA != null) $A = $alteredA;
		
		//removed in 1.6 but still required for automatic recovery [06.11.2011]
		$T = new Textbausteine();
		list($k, $v) = $T->getTBs("emailBetreff", $GRLBM->getMyPrefix(), true);
		$betreff = isset($k[0]) ? $k[0] : null;
		
		
		$T = new Textbausteine();
		list($k, $v) = $T->getTBs("emailText", $GRLBM->getMyPrefix(), true);
		$text = isset($k[0]) ? $k[0] : null;

		$rechnungsdatum = $GRLBM->A("datum");
		$gesamtsumme = $GRLBM->A("bruttobetrag")*1;
		if($GRLBM->getMyPrefix() == "M"){
			$T = new Textbausteine();
			list($k, $v) = $T->getTBs("emailMahnung".$GRLBM->A("nummer"), "", true);
			if(isset($k[0]))
				$text = $k[0];
			
			$G = new GRLBM($GRLBM->A("AuftragID"), false);
			$rechnungsdatum = Util::CLDateParser($G->A("datum"));
			
			
			$AC = anyC::get("GRLBM", "AuftragID", $GRLBM->A("AuftragID"));
			$AC->addAssocV3("isM", "=", "1");
			$AC->setFieldsV3(array("SUM(gebuehren) AS gesamt"));
			$T = $AC->n();
			$gebuehren = 0;
			if($T)
				$gebuehren = $T->A("gesamt");
			
			$gesamtsumme += $gebuehren;
		}
		
		if($text == null)
			$text = -1;
		
	    $replace = array(
			"{Firmenname}",
			"{Vorname}",
			"{Nachname}",
			"{Benutzername}",
			"{BenutzerPosition}",
			"{BenutzerTelefon}",
			"{Anrede}",
			"{Rechnungsdatum}",
			"{Belegdatum}",
			"{Belegnummer}",
			"{Gesamtsumme}",
			"{+1Woche}",
			"{+2Wochen}",
			"{+3Wochen}",
			"{+1Monat}",
			"{ProjektName}",
			"{BelegMonatText}",
			"{BelegJahr}");
		
		$date = Util::CLDateParser($GRLBM->A("datum"), "store");
		if($date == -1) $date = $GRLBM->A("datum");
		
		$D = new Datum($date);
		$D->addMonth();
		
		$lang = "de";
		if($A->A("AdresseSpracheID")){
			$S = new Sprache($A->A("AdresseSpracheID"));
			$lang = $S->A("SpracheSprache");
		}
		
		$projektName = "";
		if(Session::isPluginLoaded("mProjekt")){
			$Auftrag = new Auftrag($GRLBM->A("AuftragID"));
			if($Auftrag->A("ProjektID")){
				$P = new Projekt($Auftrag->A("ProjektID"));
				$projektName = $P->A("ProjektName");
			}
		}
		
		$replaceWith = array(
			$Stammdaten->A("firmaLang"),
			$A->A("vorname"),
			$A->A("nachname"),
			Session::currentUser()->A("name"),
			Session::currentUser()->A("UserPosition"),
			Session::currentUser()->A("UserTel"),
			Util::formatAnrede($lang, $A),
			$rechnungsdatum,
			$GRLBM->A("datum"),
			$GRLBM->A("prefix").$GRLBM->A("nummer").(($GRLBM->A("GRLBMVersion") AND $GRLBM->A("isA")) ? "-".$GRLBM->A("GRLBMVersion") : ""),
			Util::CLFormatCurrency($gesamtsumme, true),
			Util::CLDateParser($date + 7 * 3600 * 24),
			Util::CLDateParser($date + 14 * 3600 * 24),
			Util::CLDateParser($date + 21 * 3600 * 24),
			Util::CLDateParser($D->time()),
			$projektName,
			Util::CLMonthName(date("m", $date)),
			date("Y", $date)
		);
		
		
	    $T = new Textbaustein($text);
	    
		if($betreff != null AND $T->A("betreff") == ""){//fix removal of TB type "E-Mail Betreff"
			$TBetreff = new Textbaustein($betreff);
			$T->changeA("betreff", $TBetreff->A("text"));
			$T->saveMe(true, false);
			
			$TBetreff->deleteMe();
		}
		
		$T = Aspect::joinPoint("alterTB", __CLASS__, __METHOD__, array($T, $GRLBM, $A, $lang), $T);
		
		$Subject = $T->A("betreff");
		$Body    = $T->A("text");
		
		if(Session::isPluginLoaded("mMultiLanguage") AND $A->A("AdresseSpracheID") > 0){
			$S = new Sprache($A->A("AdresseSpracheID"));
			$TText = MultiLanguage::getTranslationL($S->A("SpracheSprache"), "Textbaustein", $T->getID(), "text");
			if($TText)
				$Body = $TText;
			
			$TSubject = MultiLanguage::getTranslationL($S->A("SpracheSprache"), "Textbaustein", $T->getID(), "betreff");
			if($TSubject)
				$Subject = $TSubject;
		}
		
		if(preg_match_all("/{\+([0-9]+)Tage}/", $Body, $regs))
			foreach($regs[1] AS $mv)
				$Body = str_replace("{+{$mv}Tage}", Util::CLDateParser($date + $mv * 3600 * 24), $Body);
			
		
	    if($GRLBM->getMyPrefix() != "M"){
			$Subject = str_ireplace(array("{Rechnungsnummer}", "{Belegnummer}"), $GRLBM->A("prefix").$GRLBM->A("nummer").(($GRLBM->A("GRLBMVersion") AND $GRLBM->A("isA")) ? "-".$GRLBM->A("GRLBMVersion") : ""), $Subject);
			$Body    = str_ireplace(array("{Rechnungsnummer}", "{Belegnummer}"), $GRLBM->A("prefix").$GRLBM->A("nummer").(($GRLBM->A("GRLBMVersion") AND $GRLBM->A("isA")) ? "-".$GRLBM->A("GRLBMVersion") : ""), $Body);
		} else {
			$GRLBMOrig = new GRLBM($GRLBM->A("AuftragID"));
			
			$Subject = str_ireplace("{Rechnungsnummer}", $GRLBMOrig->A("prefix").$GRLBMOrig->A("nummer"), $Subject);
			$Body    = str_ireplace("{Rechnungsnummer}", $GRLBMOrig->A("prefix").$GRLBMOrig->A("nummer"), $Body);
			
			$replaceWith[5] = $GRLBMOrig->A("datum");
			
			if($GRLBMOrig->A("nummer") > 1){
				$AC = anyC::get("GRLBM", "isM", "1");
				$AC->addAssocV3("AuftragID", "=", $GRLBM->A("AuftragID"));
				$AC->addAssocV3("nummer", "=", "1");
				$M1 = $AC->n();
				if($M1){
					$Subject = str_ireplace("{1.Mahnungsdatum}", Util::CLDateParser($M1->A("datum")), $Subject);
					$Body    = str_ireplace("{1.Mahnungsdatum}", Util::CLDateParser($M1->A("datum")), $Body);
				}
			}
			
			if($GRLBMOrig->A("nummer") > 2){
				$AC = anyC::get("GRLBM", "isM", "1");
				$AC->addAssocV3("AuftragID", "=", $GRLBM->A("AuftragID"));
				$AC->addAssocV3("nummer", "=", "2");
				$M2 = $AC->n();
				if($M2){
					$Subject = str_ireplace("{2.Mahnungsdatum}", Util::CLDateParser($M2->A("datum")), $Subject);
					$Body    = str_ireplace("{2.Mahnungsdatum}", Util::CLDateParser($M2->A("datum")), $Body);
				}
			}
			
			
			$Subject = str_ireplace("{Belegnummer}", $GRLBM->A("prefix").$GRLBMOrig->A("nummer")."/".$GRLBM->A("nummer"), $Subject);
			$Body    = str_ireplace("{Belegnummer}", $GRLBM->A("prefix").$GRLBMOrig->A("nummer")."/".$GRLBM->A("nummer"), $Body);
		}
		
		$Subject = str_ireplace($replace, $replaceWith, $Subject);		
	    $Body    = str_ireplace($replace, $replaceWith, $Body);
		
		
		if(Session::isPluginLoaded("mMicropayment")){
			$Body = Micropayment::replace(
				$Body, "Rechnung ".$GRLBM->A("prefix").$GRLBM->A("nummer"),
				$GRLBM->A("bruttobetrag") * 100,
				"Gesamt-Betrag gem. Rechnung ".$GRLBM->A("prefix").$GRLBM->A("nummer"));
		}
		
		#$Subject = str_replace(array("{Rechnungsdatum}","{Belegdatum}"), $GRLBM->A("datum"), $Subject);
		#$Body    = str_replace(array("{Rechnungsdatum}","{Belegdatum}"), $GRLBM->A("datum"), $Body);
	    
		
		$Subject = Aspect::joinPoint("alterSubject", null, __METHOD__, array($A, $Subject, $GRLBM), $Subject);
		$Body = Aspect::joinPoint("alterBody", null, __METHOD__, array($A, $Body, $Stammdaten, $GRLBM), $Body);
		
		return array($Subject, $Body);
	}

	public static function getEMailSender($Stammdaten = null, $die = true){
		if($Stammdaten == null) 
			$Stammdaten = mStammdaten::getActiveStammdaten();

		$ud = new mUserdata();
		$sender = $ud->getUDValue("sendBelegViaEmailSender", "firm");
		if($sender == "firm") {
			$from = $Stammdaten->A("email");
			$fromName = str_replace(",", "", $Stammdaten->A("firmaLang"));
		}
		if($sender == "user") {
			$from = $_SESSION["S"]->getCurrentUser()->A("UserEmail");
			$fromName = $_SESSION["S"]->getCurrentUser()->A("name");
		}

		$fromName = Aspect::joinPoint("senderName", __CLASS__, __METHOD__, array($fromName, $Stammdaten), $fromName);
		$from = Aspect::joinPoint("senderAddress", __CLASS__, __METHOD__, array($from, $Stammdaten), $from);
		
		if($Stammdaten->getA()->email == "" AND $sender == "firm"){
			if($die) 
				Red::errorD ("Bitte überprüfen Sie die Absender-Adresse des Benutzers und in den Stammdaten");
			else 
				throw new Exception("E-Mail: Please check the firms e-mail address in the Stammdaten");
		}
		if($_SESSION["S"]->getCurrentUser()->getA()->UserEmail == "" AND $sender == "user"){
			if($die)
				Red::errorD ("Bitte überprüfen Sie die Absender-Adresse des Benutzers und in den Stammdaten");
			else
				throw new Exception("E-Mail: Please check the users e-mail address");
		}

		return array($fromName, $from);
	}

	function getViaEMailWindow($GRLBMID, $sendVia = "E-Mail", $AnsprechpartnerID = "0"){
		T::load(__DIR__, "Auftraege");
		$G = new GRLBM($GRLBMID);
		$AnAdresse = new Adresse($this->A("AdresseID"));


		$Recipients = array();
		$Recipients[0] = array(
			$AnAdresse->A("firma") != "" ? $AnAdresse->A("firma") : $AnAdresse->A("vorname")." ".$AnAdresse->A("nachname"),
			$AnAdresse->A("email"),
			T::_("Firmenadresse"));
		
		if($AnAdresse->A("email2"))
			$Recipients[-2] = array(($AnAdresse->A("firma") != "" ? $AnAdresse->A("firma") : $AnAdresse->A("vorname")." ".$AnAdresse->A("nachname"))." (privat)",
			$AnAdresse->A("email2"),
			"Privat");
		
		if($this->A("AdresseIDOriginal")){
			$OriginalAdresse = new Adresse($this->A("AdresseIDOriginal"));
			if($AnAdresse->A("email") != $OriginalAdresse->A("email")){
				$Recipients[-3] = array(
					$OriginalAdresse->A("firma") != "" ? $OriginalAdresse->A("firma") : $OriginalAdresse->A("vorname")." ".$OriginalAdresse->A("nachname"),
					$OriginalAdresse->A("email"),
					T::_("Neue E-Mail"));
			}
		}
		
		if(Session::isPluginLoaded("mAnsprechpartner")){
			if($this->A("kundennummer") > 0)
				$ASPs = Ansprechpartner::getAllAnsprechpartner($this->A("kundennummer"));
			if($this->A("lieferantennummer") > 0)
				$ASPs = Ansprechpartner::getAllAnsprechpartnerTo("Lieferant", $this->A("lieferantennummer"));
			
			if($ASPs)
				while($ASP = $ASPs->getNextEntry()){

					$name = trim($ASP->A("AnsprechpartnerVorname")." ".$ASP->A("AnsprechpartnerNachname"));
					if($name == "")
						$name = $ASP->A("AnsprechpartnerPosition");

					$Recipients[$ASP->getID()] = array(
						$name,
						$ASP->A("AnsprechpartnerEmail"),
						"Ansprechpartner für ".($ASP->A("AnsprechpartnerGetsR") ? "Rechnungen" : "")." ".($ASP->A("AnsprechpartnerGetsR") ? " und " : "").($ASP->A("AnsprechpartnerGetsA") ? "Angebote" : ""));
				}
			
			if($AnsprechpartnerID != "0"){
				$ARecipient = new Ansprechpartner($AnsprechpartnerID);

				$AnAdresse->changeA("vorname", $ARecipient->A("AnsprechpartnerVorname"));
				$AnAdresse->changeA("nachname", $ARecipient->A("AnsprechpartnerNachname"));
				$AnAdresse->changeA("anrede", $ARecipient->A("AnsprechpartnerAnrede"));
				$AnAdresse->changeA("email", $ARecipient->A("AnsprechpartnerEmail"));
			}
		}
		
		
		
		$Empfaenger = array();
		$CCEmpfaenger = array(-1 => "Nicht verwenden");
		foreach($Recipients AS $k => $R){
			$Empfaenger[$k] = $R[0]." &lt;$R[1]&gt;";
			$CCEmpfaenger[$R[1]] = $R[0]." &lt;$R[1]&gt;";
		}
		
		$Empfaenger[-1] = T::_("Anderer Empfänger");
		
		$IR = new HTMLInput("EMailRecipientSelection", "select", $AnsprechpartnerID, $Empfaenger);
		$IR->onchange("if(this.value != '-1') Auftrag.windowMail(".$this->getID().", '$GRLBMID', '$sendVia', this.value); else { \$j('[name=otherRecipient]').show(); \$j('#regularRecipient').hide(); }");
		#if(count($Empfaenger) == 1)
		#	$IR = $Empfaenger[0];
		
		$BP0 = new Button("Empfänger hinzufügen", "./images/i2/add.png", "icon");
		$BP0->style("float:right;margin-top:5px;");
		$BP0->onclick("\$j('#EMailCC1Row').toggle();");
		if($sendVia != "E-Mail")
			$BP0 = "";
		
		$BP1 = new Button("Empfänger hinzufügen", "./images/i2/add.png", "icon");
		$BP1->style("float:right;margin-top:5px;");
		$BP1->onclick("\$j('#EMailCC2Row').toggle();");
				
		$Stammdaten = new Stammdaten($this->A("AuftragStammdatenID"));#mStammdaten::getActiveStammdaten();
		if($this->A("AuftragStammdatenID") == 0)
			$Stammdaten = mStammdaten::getActiveStammdaten();
		
		list($Subject, $Body) = AuftragGUI::getEMailTBs($AnAdresse, $Stammdaten, $G);
		list($fromName, $from) = AuftragGUI::getEMailSender($Stammdaten);
		$recipient = $Recipients[$AnsprechpartnerID][1];
		
		$IO = new HTMLInput("otherRecipient", "text");
		$IO->style("display:none;margin-top:5px;");
		$IO->placeholder("E-Mail-Adresse");
		#$Recipients[-1] = array("", "", $IO);
		
		$tab = new HTMLTable(2);
		$tab->setColWidth(1, "120px;");
		$tab->addLV(T::_("Absender").":", "$fromName &lt;$from&gt;");
		$tab->addLV(T::_("Empfänger").":", $BP0.$IR."<br />$IO<div id=\"regularRecipient\"><small style=\"color:grey;\">$recipient<br />".$Recipients[$AnsprechpartnerID][2]."</small></div>");
		
		
		$tab->addLV("CC:", $BP1.new HTMLInput("EMailCC1$this->ID", "select", -1, $CCEmpfaenger));
		$tab->addRowStyle("display:none;");
		$tab->setRowID("EMailCC1Row");
		
		$tab->addLV("CC:", new HTMLInput("EMailCC2$this->ID", "select", -1, $CCEmpfaenger));
		$tab->addRowStyle("display:none;");
		$tab->setRowID("EMailCC2Row");
		
		$ud = new mUserdata();
		if($_SESSION["S"]->getCurrentUser()->A("UserEmail") != "" AND $ud->getUDValue("BCCToUser", "false") == "true" AND trim($Stammdaten->A("alwaysBcc")) == "")
			$tab->addLV("BCC:",$_SESSION["S"]->getCurrentUser()->A("UserEmail"));

		if($Stammdaten->A("alwaysBcc") != "")
			$tab->addLV("BCC:",$Stammdaten->A("alwaysBcc"));
		
		$tab->addLV(T::_("Betreff").":", "<input type=\"text\" id=\"EMailSubject$this->ID\" value=\"$Subject\" />");
		
		$tab->addRow(array("<textarea class=\"tinyMCEEditor\" id=\"EMailBody$this->ID\" style=\"width:100%;height:300px;font-size:10px;\">$Body</textarea>"));
		$tab->addRowColspan(1, 2);
		$tab->addRowClass("backgroundColor0");

		$BAbort = new Button("Abbrechen","stop");
		$BAbort->onclick(OnEvent::closePopup("Auftrag"));

		$BGo = new Button("E-Mail\nsenden","okCatch");
		$BGo->style("float:right;");
		if($sendVia == "E-Mail")
			$BGo->onclick((strpos($Body, "<p") !== false ? "\$j('#EMailBody$this->ID').val(tinyMCE.get('EMailBody$this->ID').getContent());" : "")." Auftrag.directMail('$this->ID', $GRLBMID, '$recipient', $('EMailSubject$this->ID').value, \$j('#EMailBody$this->ID').val(), \$j('#mailAttachments input:checked').serialize(), \$j('[name=otherRecipient]').val(), \$j('[name=EMailCC1$this->ID]').val(), \$j('[name=EMailCC2$this->ID]').val()); ".OnEvent::closePopup("Auftrag"));
		if($sendVia == "sign")
			$BGo->onclick((strpos($Body, "<p") !== false ? "\$j('#EMailBody$this->ID').val(tinyMCE.get('EMailBody$this->ID').getContent());" : "")." Auftrag.plSign('$this->ID', $GRLBMID, '$recipient', $('EMailSubject$this->ID').value, \$j('#EMailBody$this->ID').val(), \$j('[name=otherRecipient]').val()); ".OnEvent::closePopup("Auftrag"));

		Aspect::joinPoint("buttons", $this, __METHOD__, array($BGo, $BAbort));
		
		$tab->addRow(array($BGo.$BAbort));
		$tab->addRowColspan(1, 2);

		echo "<div style=\"width:400px;display:inline-block;vertical-align:top;\">$tab</div>";
		
		if(strpos($Body, "<p") !== false)
			echo OnEvent::script("
				setTimeout(function(){
				".tinyMCEGUI::editorMail ("EMailBody$this->ID", null, "undo redo | pastetext | bold italic underline | fullscreen code")."
			}, 100);");
		
		
		
		$T = new HTMLTable(3, T::_("Anhänge"));
		$T->setTableID("mailAttachments");
		$T->weight("light");
		$T->setColWidth(1, 20);
		$T->setColWidth(3, 20);
		$T->maxHeight(400);
		$B = new Button("PDF", "./images/i2/pdf.gif", "icon");
		$G = new GRLBM($GRLBMID);
		$nummer = $G->A("nummer");
		if($G->getMyPrefix() == "M"){
			$refG = new GRLBM($G->A("AuftragID"));
			$nummer = $refG->A("nummer")."-".$nummer;
		}
			
		$T->addRow(array($B, $G->A("prefix").$nummer.(($G->A("GRLBMVersion") AND $G->A("isA")) ? "-".$G->A("GRLBMVersion") : "")));
		
		if($sendVia == "E-Mail"){
			$AC = anyC::get("GRLBM");
			$AC->addAssocV3("AuftragID", "=", $this->getID(), "AND", "1");
			$AC->addAssocV3("GRLBMID", "!=", $GRLBMID, "AND", "1");
			$AC->addAssocV3("isM", "=", "0", "AND", "1");
			
		
			if($G->getMyPrefix() == "O"){
				$AB = anyC::getFirst("GRLBM", "GRLBMOrderGRLBMIDs", ",$GRLBMID,");
				if($AB){
					$AC->addAssocV3("AuftragID", "=", $AB->A("AuftragID"), "OR", "2");
					$AC->addAssocV3("isM", "=", "0", "AND", "2");
				}
			}
			
			while($G2 = $AC->n()){
				$included = 0;
				if($G->getMyPrefix() == "M" AND mUserdata::getUDValueS("sendBelegViaEmailAttachInvoice", "false") == "true" AND $G2->getID() == $G->A("AuftragID"))
					$included = 1;
				
				$I = new HTMLInput("attach_".$G2->getID(), "checkbox", $included);
				if($included)
					$I->isDisabled (true);
				
				$T->addRow(array($B, $G2->A("prefix").$G2->A("nummer").(($G2->A("GRLBMVersion") AND $G2->A("isA")) ? "-".$G2->A("GRLBMVersion") : ""), $I));
			}
		}
		
    	if($sendVia == "E-Mail" AND Session::isPluginLoaded("mFile") AND mUserdata::getUDValueS("sendBelegViaEmailAttachments", "false") == "true"){
			$B = new Button("Datei", "./plugins/Files/File18.png", "icon");
			$D = new mDateiGUI();
			$D->addAssocV3("DateiClassID", "=", $GRLBMID);
			$D->addAssocV3("DateiClass", "=", "GRLBM");

			while($f = $D->getNextEntry())
				$T->addRow(array($B, basename($f->A("DateiPath")), ""));
			
			$attachmentsDir = FileStorage::getFilesDir()."GRLBMID".str_pad($GRLBMID, 4, "0", STR_PAD_LEFT);
			if(file_exists($attachmentsDir)){
				$dir = new DirectoryIterator($attachmentsDir);
				foreach ($dir as $file) {
					if($file->isDot()) continue;
					if($file->isDir()) continue;

					$T->addRow(array($B, $file->getFilename(), ""));
				}
			}
    	}
		
		Aspect::joinPoint("attachments", $this, __METHOD__, array($T));
		
		echo "<div style=\"width:195px;display:inline-block;vertical-align:top;\">$T</div>";
	}
	
	static function getNextNumber($t){
		return parent::getNextNumber($t);
	}
	
	public function getMyStammdaten(){
		return parent::getMyStammdaten();
	}

	public function saveMultiEditField($field,$value){
		parent::saveMultiEditField($field,$value);
		Red::messageD("Änderung gespeichert");
	}
}
?>