<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class ArtikelGUI extends Artikel implements iGUIHTML2 {
	function __construct($id, $parsers = true) {
		parent::__construct($id, $parsers);
		
		if(!Session::isPluginLoaded("Kategorien"))
			$this->setParser("mwst","Util::CLNumberParserZ");
	}
	
	public static $hasLieferant = false;
	function getHTML($id){
		T::load(__DIR__, "mArtikel");
		
		$gui = new HTMLGUI();
		#$gui->translate($this->loadTranslation());
		
		$this->loadMeOrEmpty();

		$CT = $this->getCalcTable();

		if($this->A->isBrutto == "1")
			$this->A->preis = Util::CLNumberParserZ($this->A->bruttopreis,"load");
			
		$updateJS = "";
		if($id == -1){
			$this->A = $this->newAttributes();
			try {
				$id = $this->newMe(true, false);
			} catch(DuplicateEntryException $e){
				Red::errorDuplicate($e->getDuplicateFieldValue());
			}
			$this->forceReload();
			$updateJS = "<script type=\"text/javascript\">contentManager.setLeftFrame('Artikel', $id); contentManager.reloadFrame('contentRight');</script>";
		}

		$gui->setShowAttributes(array(
			"name",
			"gebinde",
			"artikelnummer",
			#"keinLagerbestand",
			"KategorieID",
			"KategorieID2",
			"beschreibung",
			"ArtikelProduktionLimit",
			"ArtikelProduktionAnzahl",
			"preis",
			"isBrutto",
			"aufschlagListenpreis",
			"aufschlagGesamt",
			"mwStKategorieID",
			"mwst",
			"EK1",
			"EK2",
			"LohngruppeID",
			"Lohnminuten",
			"bild",
			"bemerkung",
			"erloeskonto",
			"hideInReport",
			"bruttopreis",
			"bildDateiName"));
		
		if(Session::isPluginLoaded("mDifferenzbesteuerung"))
			$gui->insertAttribute ("after", "hideInReport", "differenzbesteuert");
		
		
		if(Session::isPluginLoaded("mVersand")){
			$gui->insertAttribute ("after", "bemerkung", "gewicht");
			$gui->setParser("gewicht", "ArtikelGUI::parserGewicht");
		}
		
		$gui->setType("isBrutto","hidden");
		$gui->setLabel("isBrutto","Bruttopreis?");
		$gui->setFieldDescription("isBrutto","Ist der angegebene Preis ein Bruttopreis?");
		if(Session::isPluginLoaded("mBrutto")){
			$gui->setType("isBrutto","checkbox");
			$gui->setLabel("preis","Preis");
			$gui->activateFeature("addSaveDefaultButton", $this, "isBrutto");
		}
		
		if(!Session::isPluginLoaded("ImportDatanorm"))
			$gui->hideAttribute("rabattgruppe");
		
		if(!Session::isPluginLoaded("mexportLexware") AND !Session::isPluginLoaded("mexportDatev"))
			$gui->hideAttribute("erloeskonto");

		
		$gui->setParser("artikelnummer", "ArtikelGUI::parserArtikelnummer");
		
		$gui->setObject($this);
		$gui->setName("Artikel");
		
		$gui->setLabel("erloeskonto", "Erlöskonto");
		$gui->activateFeature("addSaveDefaultButton", $this, "erloeskonto");
		
		$gui->setParser("preis","ArtikelGUI::preisInputParser", array($this->A("preisModus")));
		
		if(Session::isPluginLoaded("Kategorien")){
			$kat = new Kategorien();
			$kat->addAssocV3("type","=","mwst");

			$keys = array();
			$values = $kat->getArrayWithValues();
			for($i=0;$i<count($values);$i++){
				$keys[] = Util::parseFloat("de_DE",str_replace("%","",$values[$i]));
				$values[$i] = Util::CLNumberParserZ(Util::parseFloat("de_DE",str_replace("%","",$values[$i])),"load")."%";
			}

			if(!in_array($this->A("mwst"), $keys)){ //nicht existierenden MwSt-Satz trotzdem zur Auswahl anbieten, sonst erkennt man es nicht
				$keys[] = $this->A("mwst");
				$values[$i] = Util::CLNumberParserZ($this->A("mwst"))."%";
			}
			
			$gui->setType("mwst", "select");
			$gui->setOptions("mwst", $keys, $values);
			
			$B = new Button("MwSt-Sätze bearbeiten", "./images/i2/edit.png", "icon");
			$B->popup("", "MwSt-Sätze bearbeiten", "Artikel", $this->getID(), "mwstEdit");
			
			$gui->activateFeature("addCustomButton", $this, "mwst", $B);
		}
		
		if(Session::isPluginLoaded("Kategorien") AND Session::isPluginLoaded("mMwSt")){
			$kat = new Kategorien();
			$kat->addAssocV3("type","=","mwstsatz");
			$saetze = $kat->getArrayWithKeysAndValues("bitte auswählen");
			$saetze[-1] = "Artikel-MwSt verwenden";
			
			$keys = array_keys($saetze);
			$values = array_values($saetze);

			$gui->setType("mwStKategorieID","select");
			$gui->setOptions("mwStKategorieID", $keys, $values);
			
			$gui->setLabel("mwStKategorieID", "MwSt-Satz");
			
			$gui->setInputJSEvent("mwStKategorieID", "onchange", "contentManager.toggleFormFieldsTest(\$j(this).val() == -1, ['mwst'], [], 'AjaxForm');");
			
			if($this->A("mwStKategorieID") != -1)
				$gui->setLineStyle("mwst", "display:none;");
			$gui->setFieldDescription("mwStKategorieID", "Diese Einträge verwalten Sie im %1.", "<a style=\"color:grey;\" href=\"#\" onclick=\"contentManager.loadPlugin('contentRight', 'mMwSt'); return false;\" >".T::_("MwSt-Plugin")."</a>");
			
			
		}
		else
			$gui->hideAttribute("mwStKategorieID");
		
		$gui->setType("differenzbesteuert","checkbox");
		$gui->setType("beschreibung","textarea");
		
		if(!Session::isPluginLoaded("Provisionen"))
			$gui->setType("EK2", "hidden");
		
		$gui->hideAttribute("bruttopreis");
		$gui->hideAttribute("bild");
		$gui->hideAttribute("lieferantID");
		$gui->hideAttribute("ArtikelID");
		$gui->hideAttribute("bildDateiName");
	
		#$gui->insertSpaceAbove("hideInReport");
		$gui->insertSpaceAbove("EK1", "Einkauf");
		$gui->insertSpaceAbove("bemerkung", "Sonstiges");
		$gui->insertSpaceAbove("preis", "Verkauf");
		#$gui->insertSpaceAbove("aufschlagListenpreis");
		
		if(Session::isPluginLoaded("Berichte"))
			$gui->setType("hideInReport","checkbox");
		else
			$gui->setType("hideInReport","hidden");

		if(Session::isPluginLoaded("mProduktion")) {
			$gui->insertSpaceAbove("ArtikelProduktionLimit", "Produktion");
			$gui->setLabel("ArtikelProduktionLimit", "Maximale Anzahl");
			$gui->setFieldDescription("ArtikelProduktionLimit", "Geben Sie 0 für ein unbegrenzte Anzahl ein.");
			$gui->setLabel("ArtikelProduktionAnzahl", "Bisher produziert");
		} else {
			$gui->setType("ArtikelProduktionLimit","hidden");
			$gui->setType("ArtikelProduktionAnzahl","hidden");
		}
		
		$gui->setType("LohngruppeID","hidden");
		$gui->setType("Lohnminuten","hidden");
		$gui->setType("aufschlagListenpreis","hidden");
		$gui->setType("aufschlagGesamt","hidden");
		if(Session::isPluginLoaded("mLohngruppe")){
			$gui->setLabel("LohngruppeID", "Lohngruppe");
			$gui->setType("LohngruppeID","select");
			$gui->selectWithCollection("LohngruppeID", anyC::get("Lohngruppe"), "LohngruppeName", "bitte auswählen");
			$gui->setType("Lohnminuten","text");
			$gui->insertSpaceAbove("LohngruppeID", "Lohn");
		}

		if(Session::isPluginLoaded("mMultiLanguage")){
			$gui->activateFeature("addAnotherLanguageButton", $this, "name");
			$gui->activateFeature("addAnotherLanguageButton", $this, "gebinde");
			$gui->activateFeature("addAnotherLanguageButton", $this, "beschreibung");
		}
		
		if(Session::isPluginLoaded("Kategorien")){
			$gui->setLabel("KategorieID2", "Kategorie 2");
			if($this->A("KategorieID2") == "0")
				$gui->setLineStyle("KategorieID2", "display:none;");
		
			$gui->setType("KategorieID","select");
			$gui->setType("KategorieID2","select");
			$gui->setFieldDescription("KategorieID", "Diese Einträge verwalten Sie im %1.", "<a style=\"color:grey;\" href=\"#\" onclick=\"contentManager.loadPlugin('contentRight', 'Kategorien');return false;\" >".T::_("Kategorien-Plugin")."</a>");
		
			$kat = new Kategorien();
			$kat->addAssocV3("type","=","2");
			$kat->addOrderV3("name", "ASC");
			$keys = $kat->getArrayWithKeys();
			$keys[] = "0";

			$values = $kat->getArrayWithValues();
			$values[] = $this->texts["bitte auswählen"];

			$gui->setOptions("KategorieID", $keys, $values);
			$gui->setOptions("KategorieID2", $keys, $values);


			$B = new Button("Weitere Kategorie", "./images/i2/add.png", "icon");
			$B->onclick("contentManager.toggleFormFields('show', ['KategorieID2']);");
			$gui->activateFeature("addCustomButton", $this, "KategorieID", $B);
		} else {
			$gui->setType ("KategorieID", "hidden");
			$gui->setType ("KategorieID2", "hidden");
		}
		
		$gui->setType("sachkonto", "hidden"); //Legacy since 24.02.2013
		
		$ST = new HTMLSideTable("right");
		
		$ST->addRow($this->getPic());
		if($this->A("bildDateiName") == "")
			$ST->addCellStyle (1, "display:none;");
		$ST->addCellID(1, "ArtikelBild");
		
		
		#$ST->setTableStyle("float:right;margin: 0 -170px 0 0;width: 160px;");
		#if(Session::isPluginLoaded("mDArtikel"))
		#	$ST->addRow(DArtikel::getButton($this->getID()));
		
		if(Session::isPluginLoaded("mArtikelRG"))
			$ST->addRow(ArtikelRG::getButton($this->getID()));
		
		if(Session::isPluginLoaded("mPostenKalkulation"))
			$ST->addRow(PostenKalkulation::getButton($this->getID()));
		
		if(Session::isPluginLoaded("mPreisgruppe"))
			$ST->addRow(Preisgruppe::getButton("Artikel", $this->getID()));
			
		if(Session::isPluginLoaded("mEtikette"))
			$ST->addRow(Etikette::getButton("Artikel", $this->getID()));
		
		if(Session::isPluginLoaded("mLager"))
			$ST->addRow(Lagerbestand::getButton($this->getID()));
		
		if(Session::isPluginLoaded("mVertrag") AND Session::isPluginLoaded("mStatistik")){
			$B = $ST->addButton("Forecast","./open3A/Vertrag/forecast.png");
			$B->popup("", "Forecast", "mVertrag", $this->getID(), "simulateArtikel", array($this->getID()), "", "{width:800}");
		}
		
		if(Session::isPluginLoaded("mLagerbestandWare") AND Applications::activeApplication() == "upFab")
			$ST->addRow(LagerbestandWare::getButton($this->getID()));
		
		if(Session::isPluginLoaded("mFile"))
			$ST->addRow(mFileGUI::getManagerButton("Artikel", $this->getID(), false, "bildDateiName", OnEvent::rme($this, "getPic", "1", "function(t){ if(t.responseText != '') \$j('#ArtikelBild').html(t.responseText).css('display', ''); else \$j('#ArtikelBild').html(t.responseText).css('display', 'none'); }"), false, "{position: 'left'}"));
		
		if(Session::isPluginLoaded("mStueckliste")/* AND !Applications::isAppLoaded("openWaWi")*/)
			$ST->addRow(Stueckliste::getButton($this->getID()));
		
		if(Session::isPluginLoaded("mStaffelpreis"))
			$ST->addRow(Staffelpreis::getButton($this->getID()));
		
		if(Session::isPluginLoaded("mVariante"))
			$ST->addRow(Variante::getButton($this->getID()));
		
		if(Session::isPluginLoaded("mLieferant")){
			$ST->addRow(Lieferant::getButton($this->getID()));

			if(Lieferant::hasArtikelLieferant($this->getID())){
				self::$hasLieferant = true;
				
				$gui->setType("EK1", "hidden");
				$gui->setType("EK2", "hidden");
				#$gui->setType("preis", "hidden");
				
				$gui->setLabel("aufschlagGesamt", "Aufschlag");
				$gui->setType("aufschlagGesamt","text");
				$gui->setFieldDescription("aufschlagGesamt", "auf Gesamtpreis in Prozent");
				
				$gui->setLabel("aufschlagListenpreis", "Aufschlag");
				$gui->setType("aufschlagListenpreis","text");
				$gui->setFieldDescription("aufschlagListenpreis", "auf Listenpreis in Prozent");
				
				#contentManager.toggleFormFieldsTest(\$j(this).val() == '0', ['aufschlagGesamt', 'aufschlagListenpreis'], []);
				if($this->A("preisModus") == "1"){
					$gui->setLineStyle("aufschlagGesamt", "display:none;");
					$gui->setLineStyle("aufschlagListenpreis", "display:none;");
				}
			}
		}
		
		if(Session::isPluginLoaded("mProduktion") AND Applications::activeApplication() == "upFab")
			$ST->addRow(Produktion::getButton($this->getID()));
		
		if(Session::isPluginLoaded("mProduktion") AND Applications::activeApplication() != "upFab")
			$ST->addRow(Produktion::getInfo($this->getID()));
		
		if(mUserdata::getPluginSpecificData("Provisionen", "pluginSpecificHideEK"))
			$gui->setType("EK2", "hidden");
		
		if(mUserdata::getPluginSpecificData("Provisionen", "pluginSpecificHideEK1"))
			$gui->setType("EK1", "hidden");
		
		if(mUserdata::getPluginSpecificData("mArtikel", "pluginSpecificHidePrices")){
			$gui->setType("preis", "hidden");
			$gui->setType("isBrutto", "hidden");
			$gui->setType("mwst", "hidden");
			$gui->setType("aufschlagGesamt", "hidden");
			$gui->setType("aufschlagListenpreis", "hidden");
			$gui->setType("mwStKategorieID", "hidden");
		}		
		
		if(Session::isPluginLoaded("mVermietet"))
			$ST->addRow(Vermietet::getButton("Artikel", $this->getID()));
		
		Aspect::joinPoint("buttons", $this, __METHOD__, array($ST));
		
		$ST->addRow(array("&nbsp;"));
		
		$ST->addRow($CT);
		$ST->addCellID(1, "CalcTable");
		
		$gui->customize($this->customizer);
		$gui->setJSEvent("onSave", "function(){ contentManager.updateLine('AjaxForm', ".$this->getID()."); contentManager.rmePCR('Artikel', ".$this->getID().", 'getCalcTable', ['1'], function(transport){ $('CalcTable').update(transport.responseText); });}");
		$gui->setStandardSaveButton($this);

		$message = "";
		if(Session::isPluginLoaded("mVertrag")){
			$VP = anyC::getFirst("VertragPosten", "VertragPostenArtikelID", $this->getID());
			
			$B = $ST->addButton("Verträge mit\nArtikel", "./open3A/Vertrag/vertrag.png");
			$B->popup("", "Verträge", "Artikel", -1, "vertraegePopup", array($this->getID()));
			$B->style("float:right;");
			
			if($VP)
				$message = "<p class=\"highlight\">$B Dieser Artikel wird als Position in mindestens einem Vertrag verwendet! Bitte prüfen Sie daher bei Änderungen auch die Verträge.</p>";
		}
		
		return $ST.$message.$updateJS.$gui->getEditHTML()/*.($_SESSION["S"]->checkForPlugin("mFile") ? "<div style=\"margin-top:20px;\">".$D->getHTML(-1, 0)."</div>" : "")*/;
	}
	
	public function mwstEdit(){
		$AC = anyC::get("Kategorie", "type", "mwst");
		$AC->addOrderV3("KategorieID", "DESC");
		
		$GUI = new HTMLGUIX($AC);
		$GUI->attributes(array("isDefault", "name"));
		$GUI->options(true, false);
		
		$GUI->colStyle("name", "text-align:right;");
		$GUI->displayMode("popup");
		$GUI->colWidth("isDefault", 20);
		$GUI->parser("name", "ArtikelGUI::parserMwStEntry");
		$GUI->parser("isDefault", "ArtikelGUI::parserMwStDefault");
		$GUI->addToEvent("onDelete", OnEvent::reload("Left").OnEvent::reloadPopup("Artikel"));
		
		$B = new Button("Neuer\nMwSt-Satz", "new");
		$B->style("margin:10px;");
		$B->rmePCR("Artikel", $this->getID(), "mwstNew", array(), OnEvent::reloadPopup("Artikel"));
		
		$TC = new HTMLTable(2);
		$TC->setColWidth(1, 32);

		$BC = new Button("Standard", "./images/i2/thisRow.png", "icon");
		$BC->style("margin-left:5px;");

		$TC->addRow(array($BC, "Als Standard verwenden"));
		$TC->addRowClass("backgroundColor0");

		$GUI->append($TC);
			
		echo $B.$GUI->getBrowserHTML();
	}
	
	public function mwstNew(){
		$F = new Factory("Kategorie");
		$F->sA("type", "mwst");
		$F->sA("name", "0,00%");
		$F->store();
	}
	
	public static function parserMwStDefault($w, $E){
		$I = new HTMLInput("isDefault", "checkbox", $w);
		$I->activateMultiEdit("Kategorie", $E->getID(), OnEvent::reloadPopup("Artikel"));
		return $I;
	}
	
	public static function parserMwStEntry($w, $E){
		$I = new HTMLInput("name", "text", $w);
		$I->style("text-align:right;");
		$I->activateMultiEdit("Kategorie", $E->getID(), OnEvent::reload("Left"));
		
		return $I;
	}
	
	public function vertraegePopup($ArtikelID){
		T::load(__DIR__, "mArtikel");
		$current = BPS::getProperty("ArtikelVertraegeGUI", "current", "all");
		$TK = new HTMLTable(3);
		
		$TK->addRow(array(
			T::_("Alle"),
			T::_("Aktiv"),
			T::_("Beendet")
		));
		$TK->addCellEvent(1, "click", OnEvent::reloadPopup("Artikel", "ArtikelVertraegeGUI;current:all"));
		$TK->addCellEvent(2, "click", OnEvent::reloadPopup("Artikel", "ArtikelVertraegeGUI;current:active"));
		$TK->addCellEvent(3, "click", OnEvent::reloadPopup("Artikel", "ArtikelVertraegeGUI;current:ended"));
		
		$TK->addCellStyle(1, "cursor:pointer;padding:10px;");
		$TK->addCellStyle(2, "cursor:pointer;padding:10px;");
		$TK->addCellStyle(3, "cursor:pointer;padding:10px;");
		
		$TK->setColWidth(1, "33.3%");
		$TK->setColWidth(2, "33.3%");
		$TK->setColWidth(3, "33.3%");
		$TK->addRowClass("backgroundColor0");
		
		if($current == "all")
			$TK->addCellClass (1, "highlight");
		
		if($current == "active")
			$TK->addCellClass (2, "highlight");
		
		if($current == "ended")
			$TK->addCellClass (3, "highlight");
		
		$T = new HTMLTable(2);
		$T->useForSelection(false);
		$T->setColWidth(1, 20);
		$T->maxHeight(500);
		
		$AC = anyC::get("VertragPosten");
		$AC->addAssocV3("VertragPostenArtikelID", "=", $ArtikelID, "AND", "1");
		$AC->addJoinV3("Vertrag", "VertragPostenVertragID", "=", "VertragID");
		$AC->addJoinV3("Adresse", "t2.VertragAdresseID", "=", "AdresseID");
		$AC->addJoinV3("VertragPostenKunde", "VertragPostenVertragPostenKundeID", "=", "VertragPostenKundeID");
		$AC->addGroupV3("VertragAdresseID");
		$AC->addOrderV3("firma");
		$AC->addOrderV3("nachname");
		$AC->setFieldsV3(array(
			"firma",
			"nachname",
			"vorname",
			"VertragID",
			"GROUP_CONCAT(DISTINCT VertragPostenVertragPostenKundeID SEPARATOR ',') AS subs",
			"GROUP_CONCAT(DISTINCT VertragPostenKundeKundennummer SEPARATOR ',') AS ksubs",
			"COUNT(*) AS anzahl"
		));
		
		if($current == "active"){
			$AC->addAssocV3 ("VertragPostenUseTimeLimit", "=", "0", "AND", "1");
			
			$AC->addAssocV3("VertragPostenArtikelID", "=", $ArtikelID, "OR", "2");
			$AC->addAssocV3 ("VertragPostenUseTimeLimit", "=", "1", "AND", "2");
			$AC->addAssocV3 ("VertragPostenTimeLimit", ">", time(), "AND", "2");
		}
		
		if($current == "ended"){
			$AC->addAssocV3 ("VertragPostenUseTimeLimit", "=", "1", "AND", "1");
			$AC->addAssocV3 ("VertragPostenTimeLimit", "<", time(), "AND", "1");
		}
		
		while($V = $AC->n()){
			$B = new Button("Vertrag anzeigen", "arrow_left", "iconic");
			
			$A = new Adresse(-1);
			$A->setA($V->getA());
			
			$ex = explode(",", $V->A("ksubs"));
			$ex2 = explode(",", $V->A("subs"));
			
			$subs = "";
			if(count($ex) > 1 OR $V->A("subs") != $V->A("VertragID")){
				asort($ex);
				foreach($ex AS $k => $v)
					$subs .= ($subs != "" ? ", " : "")."<a href=\"#\" onclick=\"event.preventDefault(); event.stopPropagation(); ".OnEvent::frame("contentLeft", "Vertrag", $V->A("VertragID"), 0, null, "Vertrag".$V->A("VertragID").";activeKategorie:".$ex2[$k])."\">$v</a>";
			}
			if($subs)
				$subs = "<br>$subs";
			
			$T->addRow(array(
				$B,
				$A->getShortAddress()." <span style=\"color:grey;\">(".$V->A("anzahl").")</span>".$subs
			));
			
			$T->addRowEvent("click", OnEvent::frame("contentLeft", "Vertrag", $V->A("VertragID")));
		}
		
		if($AC->numLoaded() == 0){
			$T->addRow(array(
				T::_("Keine Einträge")
			));
			$T->addRowColspan(1, 2);
		}
		
		echo "<p class=\"prettySubtitle\">".T::_("Verträge")."</p>$TK".$T;
	}
	
	public static function parserGewicht($w, $l, $E){
		$I = new HTMLInput("gewicht", "text", $w);
		
		return $I."<span style=\"color:grey;\"> kg</span>";
	}

	public static function parserArtikelnummer($w){
		if(!mUserdata::isDisallowedTo("cantEditArtikel"))
			return $w;
		
		$I = new HTMLInput("artikelnummer", "text", $w);
		$I->autocomplete("mArtikel", "function(){ return false; }");
		
		return $I;
	}


	public function getCalcTable($echo = "0"){
		T::load(__DIR__, "mArtikel");
		$hideEK = false;
		if(mUserdata::getPluginSpecificData("Provisionen", "pluginSpecificHideEK"))
			$hideEK = true;
		
		if(mUserdata::getPluginSpecificData("Provisionen", "pluginSpecificHideEK1"))
			$hideEK = true;
		
		$CT = new HTMLTable(2);
		$CT->setColClass(1, "");
		$CT->setColClass(2, "");
		$CT->addColStyle(2, "text-align:right;");

		$CT->addRow(array(T::_("Einkauf")));
		$CT->addRowColspan(1, 2);
		$CT->addCellClass(1, "backgroundColor3");

		$ArtikelEK = $this->getArtikelEK1();
		$CT->addRow(array("<b>".T::_("Artikel").":</b>", Util::CLNumberParserZ($ArtikelEK)));
		
		$Lohn = 0;
		if($this->A("LohngruppeID") != "0" AND Session::isPluginLoaded("mLohngruppe")){
			$Lohn = $this->getLohnNettoEK();
			if($Lohn != 0)
				$CT->addRow(array("<b>".T::_("Lohn").":</b>", Util::CLNumberParserZ($Lohn)));
			
		}

		if(Session::isPluginLoaded("mStueckliste")){
			$EKStueckliste = $this->getGesamtEK1Stueckliste();
			$CT->addRow(array("<b>".T::_("Stückliste").":</b>", Util::CLNumberParserZ($EKStueckliste)));
		}
		
		$nettoEK = $this->getGesamtEK1();
		$CT->addRow(array("<b>".T::_("Netto").":</b>", Util::CLNumberParserZ($nettoEK)));
		$CT->addCellClass(1, "borderColor1");
		$CT->addCellClass(2, "borderColor1");
		$CT->addCellStyle(1, "border-top-style:double;");
		$CT->addCellStyle(2, "border-top-style:double;");
		
		if($hideEK){
			$CT = new HTMLTable(2);
			$CT->setColClass(1, "");
			$CT->setColClass(2, "");
			$CT->addColStyle(2, "text-align:right;");
		}
			
			
		$CT->addRow(array("&nbsp;"));

		$CT->addRow(array(T::_("Verkauf")));
		$CT->addRowColspan(1, 2);
		$CT->addCellClass(1, "backgroundColor3");

		$listenpreis = $this->getArtikelLP();
		if($listenpreis != 0)
			$CT->addRow(array("<b>Listenpreis:</b>", Util::CLNumberParserZ($listenpreis)));
		
		$aufschlagListenpreis = $this->getAufschlagListenpreis();
		if($aufschlagListenpreis != 0 AND $this->A("preisModus") == "0")
			$CT->addRow(array("<b>Aufschlag:</b><br /><small>".$this->A("aufschlagListenpreis")."%</small>", Util::CLNumberParserZ($aufschlagListenpreis)));
		
		
		
		if($Lohn != 0)
			$CT->addRow(array("<b>".T::_("Lohn").":</b>", Util::CLNumberParserZ($this->getLohnNettoVK())));
		
		$aufschlagGesamt = $this->getAufschlagGesamt();
		if($aufschlagGesamt != 0 AND $this->A("preisModus") == "0")
			$CT->addRow(array("<b>Aufschlag:</b><br /><small>".$this->A("aufschlagGesamt")."%</small>", Util::CLNumberParserZ($aufschlagGesamt)));
		
		
		if(Session::isPluginLoaded("mStueckliste"))
			$CT->addRow(array("<b>".T::_("Stückliste").":</b>", Util::CLNumberParserZ($this->getGesamtNettoVKStueckliste())));
		
		$nettoVK = $this->getGesamtNettoVK();
		$CT->addRow(array("<b>".T::_("Netto").":</b>", Util::CLNumberParserZ($nettoVK)));

		#if($aufschlagGesamt != 0 OR $aufschlagListenpreis != 0){
			$CT->addCellClass(1, "borderColor1");
			$CT->addCellClass(2, "borderColor1");
			$CT->addCellStyle(1, "border-top-style:double;");
			$CT->addCellStyle(2, "border-top-style:double;");
		#}
		
		if(!$hideEK)
			$CT->addRow(array("<b>".T::_("Gewinn").":</b>", Util::CLNumberParserZ($nettoVK - $nettoEK)));

		if(!Session::isPluginLoaded("mMwSt"))
			$CT->addRow(array("<b>".T::_("Brutto").":</b>", Util::CLNumberParserZ($this->getGesamtBruttoVK())));

		if($echo == "1")
			echo $CT;

		return $CT;
	}
	
	public static function preisInputParser($w, $l, $p){
		if(!mUserdata::isDisallowedTo("cantEditArtikel"))
			return $w;
		
		if(is_object($p))
			$p = $p->A("preisModus");
		
		$B = new Button("Brutto- in Nettopreis umrechnen", "./images/i2/calc.png", "icon");
		#$B->rmePCR("Artikel", "-1", "calcBruttoPreis", array("\$j('input[name=preis]').val()", "\$j('select[name=mwst]').val()"), "function(transport){ $('preis').value = transport.responseText; }");
		$B->style("float:right;");
		$B->contextMenu("Calculator", "input[name=preis]", "Rechner", "right", "down");
		if(Session::isPluginLoaded("mMwSt"))
			$B = "";
		
		$I = new HTMLInput("preis", "text", $w);
		if(self::$hasLieferant){
			$I->onkeyup(OnEvent::rme($l, "calcAufschlag", array("\$j(this).val()"), "function(t){ \$j('#calcAufschlag').html(t.responseText); }"));
			$I->onblur("\$j('#calcAufschlag').html('');");
		}
		
		if(self::$hasLieferant AND $p == "0")
			$I->isDisabled(true);
		
		$IM = "";
		if(self::$hasLieferant){
			$I->style("width:40%;");
			
			$IM = new HTMLInput("preisModus", "select", $p, array("0" => "Nach Lieferant", "1" => "Festpreis"));
			$IM->style("width:45%;margin-left:5%;");
			$IM->onchange("contentManager.toggleFormFieldsTest(\$j(this).val() == '0', ['aufschlagGesamt', 'aufschlagListenpreis'], ['isBrutto']); if(\$j(this).val() == '1') { \$j('input[name=preis]').prop('disabled', ''); } else { \$j('input[name=preis]').prop('disabled', 'disabled'); }");
		}
		
		return "$B$I$IM<br><small style=\"color:grey;\" id=\"calcAufschlag\"></small>";
	}

	public function calcAufschlag($currentPrice){
		T::load(__DIR__, "mArtikel");
		
		$currentPrice = Util::CLNumberParserZ($currentPrice, "store");
		$ek = $this->getArtikelEK1();
		
		echo T::_("Entspricht Aufschlag").": ".Util::CLNumberParserZ(100 / $ek * $currentPrice - 100)."%";
	}
	
	public function calcBruttoPreis($preis, $mwst){
		$preis = Util::CLNumberParserZ($preis, "store");
		$mwst = Util::CLNumberParserZ($mwst, "store");

		$netto = $preis / (100 + $mwst) * 100;

		echo Util::CLFormatNumber($netto, 3);
	}
	
	public function addFile($id){
		parent::addFile($id);
		Red::messageSaved();
	}

	public function getJSON(){
		echo parent::getJSON();
	}
	
	/*public function saveDefaultSachkonto($sachkonto){
		$F = new Factory("Userdata");
		$F->sA("name", "DVArtikelSachkonto");
		$F->sA("UserID", "-1");
		$U = $F->exists(true);
		if($U){
			$U->changeA ("wert", $sachkonto);
			$U->saveMe();
		} else {
			$F->sA("wert", $sachkonto);
			$F->store();
		}
		
		Red::messageSaved();
	}*/
	
	public function saveMultiEditField($fieldName, $value){
		if($fieldName == "bildDateiName" AND $value != "" AND Util::ext($value) != "jpg" AND Util::ext($value) != "png")
			Red::alertD("Es können nur jpg oder png-Dateien als Standard-Bild verwendet werden");
		
		$this->changeA($fieldName, $value);
		$this->saveMe(true, true);
	}
	
	public function getPic($echo = false){
		if($this->A("bildDateiName") == "")
			return "";
		
		$data = file_get_contents($this->A("bildDateiName"));
		
		$Image = "<img style=\"max-width:150px;\" src=\"data:image/".Util::ext($this->A("bildDateiName")).";base64,".base64_encode($data)."\">";
		
		if($echo)
			echo $Image;
		
		return $Image;
	}
	
	public function ACLabel(){
		return $this->A("name");
	}
}
?>