<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class mAdresseGUI extends AdressenGUI {
	//This class exists for compatibility reasons (autocomplete)!
	
	function getHTML($id, $page, $frame = null) {
		T::load(__DIR__, "Adressen");
		
		$this->addOrderV3("KategorieID","ASC");
		$this->addOrderV3("firma","ASC");
		$this->addOrderV3("nachname","ASC");
		
		Aspect::joinPoint("alter", $this, __METHOD__, array());
		
		$this->filterCategories();
		$this->loadMultiPageMode($id, $page, 0);
		
		$gui = new HTMLGUIX($this);#, "Adressen");
		$gui->screenHeight();
		
		if(Session::isPluginLoaded("mAdressBuch") AND $id == -1)
			$gui->prepend(mAdressBuchGUI::getSelectionMenu($this, $frame, false, true));
		
		
		$gui->displayGroup("KategorieID", "AdressenGUI::DGParser");
		$gui->options(true, true, true, true);
		$gui->parser("firma","mAdresseGUI::parserFirma");
		
		if($frame != null)
			$gui->targetFrame($frame);
		
		$gui->attributes(array("firma"));
		
		$bps = $this->getMyBPSData();
		if(isset($bps["selectionMode"]) AND strpos($bps["selectionMode"], "selectForZahlungsmoral") !== false){ //In Statistik
			$gui->options(false, true, true, true);
			$gui->prepend("<div class=\"browserContainerSubHeight\" style=\"height:50px;display:none;\"></div>");
		}
		
		$gui->customize($this->customizer);
		
		return $gui->getBrowserHTML($id);
	}
	
	public static function parserFirma($w, $E){
		return $E->getShortAddress()."<br><small style=\"color:grey;\">".$E->A("plz")." ".$E->A("ort")."</small>";
	}
	
	function getClearClass() {
		return "mAdresse";
	}
	
	public function getOrderByFields() {
		$o = new stdClass();
		$o->label = "Firma/Nachname gemischt";
		$o->orderBy = array("KategorieID", "CONCAT(firma, nachname)");
		
		#$o2 = new stdClass();
		#$o2->label = "Kundennummer";
		#$o2->orderBy = array("KategorieID", "kundennummer", "CONCAT(firma, nachname)");
		
		return array($o);#, $o2);
	}
}
?>
