<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

class TeilrechnungGUI {
	public function createNewFromBeleg($fromGRLBMID, $toGRLBMID){
		if($fromGRLBMID == "0")
			Red::alertD ("Bitte wählen Sie eine Bestätigung aus.");
		
		
		$toGRLBM = new GRLBM($toGRLBMID);
		if($fromGRLBMID != -1){
			$restValueIDs = array();
			
			$AC = anyC::get("GRLBM", "isR", "1");
			$AC->addAssocV3("AuftragID", "=", $toGRLBM->A("AuftragID"));
			$AC->addAssocV3("t1.GRLBMID", "!=", $toGRLBMID);
			$AC->addAssocV3("isTeilrechnung", "=", "1");
			$AC->addJoinV3("Posten", "GRLBMID", "=", "GRLBMID");
			$AC->addGroupV3("PostenByPostenID");
			$AC->setFieldsV3(array("PostenByPostenID"));
			while($P = $AC->n())
				$restValueIDs[] = $P->A("PostenByPostenID");
			
			$toGRLBM->copyPostenFrom($fromGRLBMID, [], $restValueIDs);
		} else {
			$mwst = Util::CLNumberParserZ(str_replace("%", "", Kategorien::getDefault("mwst", 0)), "store");
			$toGRLBM->addPosten("", "Stück", 1, 0, $mwst);
		}
		
		$AC = anyC::get("Posten", "GRLBMID", $toGRLBMID);
		while($P = $AC->n()){
			$P->resetParsers();
			$P->changeA("EK1", $P->A("preis"));
			$P->saveMe();
		}
		
		$toGRLBM = new GRLBM($toGRLBMID); //or else bruttogesamt will be 0
		$toGRLBM->changeA("isAbschlussrechnung", "0");
		$toGRLBM->changeA("isAbschlagsrechnung", "0");
		$toGRLBM->changeA("isTeilrechnung", "1");
		$toGRLBM->getSumOfPosten(false, true);
		
		$Auftrag = new Auftrag($toGRLBM->A("AuftragID"));
		$Auftrag->updateStatus("RT");
		
	}
}
?>