<?php
/*
 *  This file is part of lightCRM.

 *  lightCRM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  lightCRM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class WAdresseCRMGUI extends Adresse implements iGUIHTMLMP2 {
	
	
	public function getHTML($id, $page){
		$I = new HTMLInput("AdresseBemerkung", "textarea", $this->A("bemerkung"));
		$I->style("width:100%;height:230px;");
		$I->id("AdresseBemerkung$this->ID");
		$I->placeholder("Bitte tragen Sie hier Ihre Notizen zu dieser Adresse ein...");
		
		$B = new Button("Notiz speichern");
		$B->type("save");
		$B->rmePCR("WAdresse", $this->ID, "saveNote", array("$('AdresseBemerkung$this->ID').value"), " ");

		$T = new HTMLTable(1);
		
		$widths = Aspect::joinPoint("changeWidths", $this, "CRMHTMLGUI::getEditHTML");
		if($widths == null) $widths = array(700, 132, 218);

		$T->setTableStyle("width:$widths[0]px;max-width:$widths[0]px;margin-left:10px;");
		
		$T->addRow($I);
		$T->addRowClass("backgroundColor0");
		
		$T->addRow($B);
		return "<div style=\"width:730px;\">".$T."</div>";
	}
	
	
}

?>