<?php
/**
 *  This file is part of lightCRM.

 *  lightCRM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  lightCRM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class WAdresseAnalyse {
	private $ownerID;
	public function setOwner($class, $classID){
		$this->ownerID = $classID;
	}
	
	public function getHTML(){
		$html = "";
		
		if(Session::isPluginLoaded("Auftraege")){
			
			$BN = new Button("Neues\nAngebot","angebot");
			#$BN->onclick("Auftrag.createEmpty(function(transport){ contentManager.loadPlugin('contentRight', 'Auftraege', 'AuftraegeGUI;-'); ".OnEvent::frame("Left", "Auftrag", "transport.responseText")." }, 'A', '$this->ownerID');");
			$BN->onclick("contentManager.rmePCR('Auftraege', -1, 'createEmpty', ['A', '$this->ownerID'], function(transport){ contentManager.loadFrame('contentLeft', 'Auftrag', transport.responseText);});");
			$BN->style("float:right;margin-top:-50px;margin-right:5px;");
			$html .= $BN;
			
			$kundennummer = Kappendix::getKappendixIDToAdresse($this->ownerID, true);
			if($kundennummer === null)
				$kundennummer = -100;
			$AC = anyC::get("Auftrag", "kundennummer", $kundennummer);
			$AC->addAssocV3("status", "=", "open");
			$AC->addJoinV3("GRLBM", "AuftragID", "=", "AuftragID");
			
			$L = new HTMLList();
			$L->addListStyle("color:grey;");
			while($G = $AC->n())
				$L->addItem($G->A("prefix").$G->A("nummer")." über ".Util::CLFormatCurrency($G->A("bruttobetrag"))."<br><small>vom ".Util::CLDateParser($G->A("datum"))."</small>");
			
			$html .= "<div style=\"width:33.333%;display:inline-block;vertical-align:top;\">
				<div class=\"backgroundColor3\" style=\"margin:5px;padding:5px;height:150px;overflow:auto;\">
				<p>Offene Angebote: ".$AC->numLoaded()."</p>
				$L
				</div>
				</div>";
			
			
			$AC = anyC::get("GRLBM", "isPayed", "0");
			$AC->addJoinV3("Auftrag", "AuftragID", "=", "AuftragID");
			$AC->addAssocV3("isR", "=", "1");
			$AC->addAssocV3("kundennummer", "=", $kundennummer);
			
			$L = new HTMLList();
			$L->addListStyle("color:grey;");
			while($G = $AC->n())
				$L->addItem($G->A("prefix").$G->A("nummer")." über ".Util::CLFormatCurrency($G->A("bruttobetrag"))."<br><small>vom ".Util::CLDateParser($G->A("datum"))."</small>");
				
			
			$html .= "<div style=\"width:33.333%;display:inline-block;vertical-align:top;\">
				<div class=\"backgroundColor3\" style=\"margin:5px;padding:5px;height:150px;overflow:auto;\">
				<p>Offene Rechnungen: ".$AC->numLoaded()."</p>
				$L
				</div>
				</div>";
		}
		
		if(Session::isPluginLoaded("mVertrag")){
			$AC = anyC::get("Vertrag", "VertragAdresseID", $this->ownerID);
			$AC->addAssocV3("VertragTyp", "=", "1");
			$AC->addAssocV3("VertragEnde", "=", "0", "AND", "2");
			$AC->addAssocV3("VertragEnde", ">", time(), "OR", "2");
			
			$L = new HTMLList();
			$L->addListStyle("color:grey;");
			while($G = $AC->n())
				$L->addItem($G->A("VertragNummer")." seit ".Util::CLDateParser($G->A("VertragStart")));
			
			$html .= "<div style=\"width:33.333%;display:inline-block;vertical-align:top;\">
				<div class=\"backgroundColor3\" style=\"margin:5px;padding:5px;height:150px;overflow:auto;\">
				<p>Aktive Verträge: ".$AC->numLoaded()."</p>
				$L
				</div>
				</div>";
		}
		
		if(Session::isPluginLoaded("mStatistik")){
			ZahlungsmoralGUI::getAverage($kundennummer);
			$ZM = ZahlungsmoralGUI::getAverage($kundennummer);
			
			$html .= "<div style=\"width:33.333%;display:inline-block;vertical-align:top;\">
				<div class=\"backgroundColor3\" style=\"margin:5px;padding:5px;height:150px;overflow:auto;\">
				<p>Zahlungsmoral: <span style=\"float:right;\">$ZM ".($ZM != 1 ? "Tage" : "Tag")."</span></p>
				<p>Gesamtumsatz: <span style=\"float:right;\">".Util::CLFormatCurrency(KundenStatsGUI::getTotal($kundennummer))."</span></p>
				<p>Umsatz ".date("Y").": <span style=\"float:right;\">".Util::CLFormatCurrency(KundenStatsGUI::getTotal($kundennummer, date("Y")))."</span></p>
				<p>Umsatz ".(date("Y") - 1).": <span style=\"float:right;\">".Util::CLFormatCurrency(KundenStatsGUI::getTotal($kundennummer, date("Y") - 1))."</span></p>
				</div>
				</div>";
		}
		
		return "<div style=\"margin-left:5px;width:710px;\">".$html."</div>";
	}
}
?>