<?php
/**
 *  This file is part of lightCRM.

 *  lightCRM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  lightCRM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class HistorieTable extends HTMLTable {
	private $entries = array();
	private $counter = 0;
	
	function __construct() {
		parent::__construct(3);
		
		$widths = Aspect::joinPoint("changeWidths", $this, "CRMHTMLGUI::getEditHTML");
		if($widths == null) $widths = array(700, 132, 218);

		$this->setColWidth(1, 50);
		$this->setColWidth(3, 38);
		#$this->setColWidth(3, 220);
		$this->setTableStyle("border-collapse:collapse;border-spacing:0px;width:$widths[0]px;margin-left:10px;max-width:$widths[0]px;");
		
		$this->setColClass(1, "");
		$this->setColClass(2, "");
		$this->setColClass(3, "");
		#$this->setColClass(3, "");
		
		$this->maxHeight(500);
	}
	
	public function addHistorie($type, $icon, $datum, $text, $openButton = "", $details = "", $UserID = ""){
		$this->entries[$datum + $this->counter++] = array($type, $icon, $datum, $text, $openButton, $details, $UserID);
		
	}
	
	public function getHTML() {
		$AC = Users::getUsers();
		$U = array();
		while($user = $AC->n())
			$U[$user->getID()] = $user->A("name");
		
		try {
			$AC = anyC::get("UserOld");
			while($user = $AC->n())
				$U[$user->A("UserOldUserID")] = $user->A("name");
		} catch (TableDoesNotExistException $e){
			
		}
		
		krsort($this->entries);
		$i = 0;
		foreach($this->entries AS $line){
			$this->addRow(array(
				new Button(strip_tags($line[0]), $line[1], "icon"), 
				"<div style=\"width:180px;float:right;color:grey;\"><small>".Util::CLFormatDate($line[2], true).((isset($line[6]) AND $line[6] != "") ? "<br>".$U[$line[6]] : "")."</small></div>$line[0]<small style=\"color:grey;\">".($line[3] != "" ? "<br />".$line[3].($line[5] != "" ? ", " : "") : "<br />")."".nl2br($line[5])."</small>", 
				$line[4]));
			
			$this->addCellStyle(1, "vertical-align:top;padding-bottom:10px;padding-top:10px;");
			$this->addCellStyle(2, "vertical-align:top;padding-bottom:10px;padding-top:10px;");
			$this->addCellStyle(3, "vertical-align:top;padding-bottom:10px;padding-top:10px;");
			if($i % 2 == 1)
				$this->addRowStyle ("background-color:#F8F8F8;");
			$i++;
		}
		
		return "<div style=\"width:730px;\">".parent::getHTML()."</div>";
	}
}

?>
