<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class CustomizerPostenAlternative implements iFileBrowser, iCustomizer {
	protected static $lastNormalPosten;
	protected static $lastAlternativePosten;

	private $ID;
	function  __construct($ID = null) {
		$this->ID = $ID;
		Aspect::registerPointCut("postenButtons", "mPostenGUI::getHTML", "CustomizerPostenAlternative::adviceAddPostenButton");
		Aspect::registerPointCut("abovePosten", "mPosten::getFPDF", "CustomizerPostenAlternative::adviceAddAbovePosten");
		#Aspect::registerPointCut("belowPosten", "mPosten::getFPDF", "CustomizerPostenAlternative::adviceAddBelowPosten");
	}
	
	public function getLabel(){
		return "alternative Posten";
	}
	
	public function getAffectedClasses(){
		return array("Posten");
	}
	
	public function customizerDescription(){
		return "Dieser Customizer ermöglicht alternative Posten auf dem Beleg, die nicht in die Gesamtsumme eingerechnet werden.";
	}

	public static function adviceAddAbovePosten($class, $args){
		$fpdf = $args[0];
		$Posten = $args[1];


		if(
			self::$lastAlternativePosten != null 
			AND self::$lastAlternativePosten->A("PostenIsAlternative") == "1" 
			AND !self::$lastAlternativePosten->A("PostenIsNaturalrabatt")
			AND $Posten->A("PostenIsAlternative") == "0"){
			#if($Posten->A("PostenAddLine" == ""))
			$args[2] = 10;
			
			self::adviceAddBelowPosten($class, $args);

			self::$lastAlternativePosten = null;
		}

		if(
			$Posten->A("PostenIsAlternative") != null 
			AND $Posten->A("PostenIsAlternative") == "1"
			AND !$Posten->A("PostenIsNaturalrabatt")
			){
			$name = "";
			if(self::$lastNormalPosten != null)
				$name = " zu ".self::$lastNormalPosten->A("name");

			if(self::$lastAlternativePosten == null){
				#$Posten->changeA("PostenAddLine", "Alternativen$name:");
				#$args[2] = 1;
				self::printLine($fpdf, "Alternativen$name:", 1);
				#CustomizerPostenAddLineGUI::adviceAddAbovePosten($class, $args); //removed or there will be two lines "Alternativen zu..."
			}

			self::$lastAlternativePosten = $Posten;
		} else {
			self::$lastNormalPosten = $Posten;
		}
	}
	
	public static function adviceAddBelowPosten($class, $args){ //from CustomizerPostenAddLineGUI
		$fpdf = $args[0];
		$Posten = $args[1];
		$lnHeight = null;
		if(isset($args[2]))
			$lnHeight = $args[2];

		$fpdf->SetDrawColor(150, 150, 150);
		$fpdf->Line($fpdf->marginLeft , $fpdf->getY()+1, 210-$fpdf->marginRight , $fpdf->getY()+1); //changed from -1 to +1 because line was in description text
		$fpdf->SetDrawColor(0, 0, 0);
		if($lnHeight == null)
			$fpdf->ln();
		else
			$fpdf->ln($lnHeight);
	}


	public static function printLine($fpdf, $text, $lnHeight = null){ //from CustomizerPostenAddLineGUI

		if($text != ""){
			if($lnHeight == null)
				$fpdf->ln();
			else
				$fpdf->ln($lnHeight);
			
			if($text != "-"){
				$fpdf->SetTextColorArray($fpdf->colorPositionenAlternativHeader);
				$fpdf->SetFont($fpdf->fontPositionenArtikelname[0], $fpdf->fontPositionenArtikelname[1], $fpdf->fontPositionenArtikelname[2]);
				$fpdf->Cell8(0, 5, $text, 0, 1);
				$fpdf->SetFont($fpdf->fontPositionen[0], $fpdf->fontPositionen[1], $fpdf->fontPositionen[2]);
				$fpdf->SetTextColor(0, 0, 0);
			}
			$fpdf->SetDrawColor(150, 150, 150);
			$fpdf->Line($fpdf->marginLeft , $fpdf->getY(), 210-$fpdf->marginRight , $fpdf->getY());
			$fpdf->SetDrawColor(0, 0, 0);
			
			$fpdf->SetTextColorArray($fpdf->colorPositionenAlternativ);
		}
	}

	public static function adviceAddPostenButton($class, Posten $Posten){
		if($Posten->A("PostenIsAlternative") == null) return "";

		$BT = new Button("alternativ-Posten?", DBImageGUI::imageLink("CustomizerPostenAlternative", "PostenAlternativeOK", "image"));
		$BT->type("icon");
		$BT->style("float:right;margin-right:10px;".($Posten->A("PostenIsAlternative") == "0" ? "" : "display:none;"));
		$BT->id("PostenIsAlternativeFalse_".$Posten->getID());
		$BT->rmePCR("Posten", $Posten->getID(), "saveMultiEditField", array("'PostenIsAlternative'","'1'"), "$('PostenIsAlternativeTrue_{$Posten->getID()}').style.display = ''; $('PostenIsAlternativeFalse_{$Posten->getID()}').style.display = 'none'; Auftrag.updateNettoBrutto({$Posten->A("GRLBMID")});");

		$BF = new Button("alternativ-Posten?", DBImageGUI::imageLink("CustomizerPostenAlternative", "PostenAlternative", "image"));
		$BF->type("icon");
		$BF->style("float:right;margin-right:10px;".($Posten->A("PostenIsAlternative") == "0" ? "display:none;" : ""));
		$BF->id("PostenIsAlternativeTrue_".$Posten->getID());
		$BF->rmePCR("Posten", $Posten->getID(), "saveMultiEditField", array("'PostenIsAlternative'","'0'"), "$('PostenIsAlternativeFalse_{$Posten->getID()}').style.display = ''; $('PostenIsAlternativeTrue_{$Posten->getID()}').style.display = 'none'; Auftrag.updateNettoBrutto({$Posten->A("GRLBMID")});");
		return $BT.$BF;
	}
	
	public function customizeClass($class){
		switch(get_class($class)){
			case "mPostenGUI":
				#$class->postenButtons .= "TEST";
			break;
		}
	}
	
	public function customizeNewAttributes($className, $Attributes){
	}
	
	public function customizeGUI($class, $GUI){
	}
	
	public function loadMe(){
		$this->A = new stdClass();

		if($this->ID == "PostenAlternativeOK")
			$this->A->image = "image/png:::703:::iVBORw0KGgpcMFwwXDANSUhEUlwwXDBcMBBcMFwwXDAQCAZcMFwwXDAf8/9hXDBcMFwwAXNSR0JcMK7OHOlcMFwwXDAGYktHRFww/1ww/1ww/6C9p5NcMFwwXDAJcEhZc1wwXDALE1wwXDALEwFcMJqcGFwwXDBcMAd0SU1FB9wCFwwlXCIqr1wi1VwwXDACP0lEQVQ4y8XST0iTcRzH8ffv2bPt2dMmOt3cJjlbaFBQF0GZXSRBCgnqEkT0RyrqXCJSiXUojMCECIKoMAZGx9JDehM7hoESWeDBgyMVWmrG3GOb+/P8OvgoS0bXfqcfX/i+vl++fOB/P1Giphzre9ejOvV+QLFqMp8xLr+/f+oVYP4LsLX1jb5UHM5OgWBtfmZcMMAbOXJbXCIxs5tDE31cJ69cMIWdacVYtGuwRdX0Tm+4nlxcOjU3FesZnor1DOfSqTlvuB5V0y9FuwZbigcXA3atXCLQ7wtHKKQN1hPxMWAJWFpPxMcKaQNfOIJW7n8I2EsBLkV1tFT6fWQ3DIxEfBJIASkjEZ/MbhhU+n0odi0KuLab1FwiwCGlxK25EALsulwnC+Rh6y8EuDUXUkpcMEfJG0hAd9hQhEAoNtO6uHnwaOy6R48Sn1UJhU5w9jmPSgHWShJFCKRpmlww52M8q6lZPd7aDHdO99LaDIFcMBcuDvFiNyDz6dT0r9UVqiq9eIL7GwFFCq421ELSgEPeAZIGNNRCweTaDtDeP64Bm98/jT/5PPOVkN+Hs6zqDKBKCY3BXrqbJFww3U2SxmAvW6f4O0gOIBTtjj3d49vbIYQgk1xcvll34NzjwxH4nYO7bZIHEwLdDl/m4XVcJ8JWBJiAufhxdLosuM9wV9dF7Zq73czEyYsFynVQbBkWf37g2w9ILjMyO84bsSvWCuABqoEKq1bdcY8ubx2tUoIQkF5j5O0tblwwC7sBaSFOKyzbOQlcMG4gZ226AixcMPwB7v+/r2TNYulcMFwwXDBcMElFTkSuQmCC";


		if($this->ID == "PostenAlternative")
			$this->A->image = "image/png:::722:::iVBORw0KGgpcMFwwXDANSUhEUlwwXDBcMBBcMFwwXDAQCAZcMFwwXDAf8/9hXDBcMFwwAXNSR0JcMK7OHOlcMFwwXDAGYktHRFww/1ww/1ww/6C9p5NcMFwwXDAJcEhZc1wwXDALE1wwXDALEwFcMJqcGFwwXDBcMAd0SU1FB9wCFwwlLM0XD9JcMFwwAlJJREFUOMvF0k9I02Ecx/H389t+229r05xu00msFl4qEMouMwopsGgUnTpWUpEXiULoaBCW9AchOhhC0SGk9JAWiNnZSrOkPwchRyluZVa6n27uz/N0cMoS6dpzevjA8/p++T5f+N9HrJNp+1ueNFvtzlZAy2cqmzJPv7h87D4g/wVYDrT03tVs9gaB4OfE2DVcME+o+pJCIdNL9wZbjpwBcqvVCrFwU0et1XA2eIJVZJKJ8eHO5u7hzubuTDIx7glWYTWcp8JNHbWFhQsB3Sgpb/UGQ+SSJvPxaB8wBUzNx6N9uaSJNxjC2Oi7CujrAQ7Naqst9XlJL5iY8egQkFwwEmY8OpReMCn1edF0Iww4Vh5ZC1wwm1IKl+FACNCd7jSQheW7EOAyHCilXDBs6wFCAU6bBU0IhGaRKxO/knrVGOgfRPUrjlwiWDy48/q+/tGTa4G8qNCEQEkpAV4frrlTWqwfCm3fAxYL5HJMfPx04k1kd3LX0+HGwhmobDIx8uvHDGWlHtwVW2tcME0odTZU6UfNxpCxL6jZGKFKP1LKc6tDrG8dMICl2OhA+7ux9wR8XuxFZccBq5IS6lwiiLYutBuPEW1dUBdBLTf411wi2YBA+Hzn7Q3eTREhBKm57xdvfWi/WR1wozIZZE6iWTSErjM2naDm2YiwFFwwEpCTL3tHiiq2mC7/5rBuuOrtv6fxJL5RYpVoSJRSfJ7LMrmY7nk4EX8k1qy1BrgBP1CSz/wP9u5o2lbsqlP5IJ5a6ok8f3sB+LoWUHnEnl+WlV8qB1xcQCbf6QzwFeAP0RHZnHCRDLhcMFwwXDBcMElFTkSuQmCC";

	}

	public function A($val){
		return $this->A->$val;
	}
	
	public function tableUpdatesXML(){
		$xml = '<phynx>
	<collectionOf>Patch</collectionOf>
	<entry>

		<id>6</id>
		<attribute name="PatchID"><![CDATA[7]]></attribute>
		<attribute name="PatchType"><![CDATA[mysql]]></attribute>
		<attribute name="PatchDescription"><![CDATA['.$this->getLabel().']]></attribute>
		<attribute name="PatchValue"><![CDATA[ALTER TABLE `Posten` ADD `PostenIsAlternative` TINYINT(1) NOT NULL DEFAULT \'0\' COMMENT \'CustomizerColumn\']]></attribute>
		<attribute name="PatchExecuted"><![CDATA[0]]></attribute>
		<attribute name="PatchDate"><![CDATA[1274022328]]></attribute>
		<attribute name="PatchApplication"><![CDATA[open3A]]></attribute>

		<attribute name="PatchNummer"><![CDATA[1000015]]></attribute>
		
	</entry>
	
</phynx>';
		
		return $xml;
	}
}
?>