<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class CustomizerPostenAddLineGUI implements iFileBrowser, iCustomizer {
	private $ID;
	public static $labelTexts = array();
	public static $AddLabelInsertOrigin = true;
	
	public function  __construct($ID = null) {
		$this->ID = $ID;
		Aspect::registerPointCut("postenButtons", "mPostenGUI::getHTML", "CustomizerPostenAddLineGUI::adviceAddPostenButton");
		Aspect::registerPointCut("abovePosten", "mPosten::getFPDF", "CustomizerPostenAddLineGUI::adviceAddAbovePosten");

		try {
			$C = new CustomizerConf();
			$C->c($this);
		} catch (Exception $ex) {}
	}

	public static function adviceAddAbovePosten($class, $args){
		$fpdf = $args[0];
		$Posten = $args[1];
		$lnHeight = null;
		if(isset($args[2]))
			$lnHeight = $args[2];
		
		$pageNo = 0;
		#$fpdf->SetAutoPageBreak(false);
		if(strpos($Posten->A("PostenAddLine"), "[") === 0 OR strpos($Posten->A("PostenAddLine"), "{") === 0){
			$titles = json_decode($Posten->A("PostenAddLine"));
			
			foreach($titles AS $T){
				$color = $fpdf->colorPositionenTitel;#array(100, 100, 100);
				if($T->color){
					$c = str_replace("#", "", $T->color);
					$color[0] = hexdec(substr($c, 0, 2));
					$color[1] = hexdec(substr($c, 2, 2));
					$color[2] = hexdec(substr($c, 4, 2));
				}
				$pageNo = self::printLine($fpdf, $T->label, $lnHeight, $color);
			}
		} else
			$pageNo = self::printLine($fpdf, $Posten->A("PostenAddLine"), $lnHeight);
		
		return $pageNo;
		#$fpdf->SetAutoPageBreak(true, $fpdf->marginBottom);
	}

	public static function printLine($fpdf, $text, $lnHeight = null, $color = array(100, 100, 100)){

		if($text != ""){
			if($lnHeight == null)
				$fpdf->ln();
			else
				$fpdf->ln($lnHeight);
			
			if($text != "-"){
				if($fpdf->GetY() + 15 > $fpdf->h - $fpdf->marginBottom)
					$fpdf->AddPage();

				$fpdf->SetTextColor($color[0], $color[1], $color[2]);
				$fpdf->SetFont($fpdf->fontPositionenTitel[0], $fpdf->fontPositionenTitel[1], $fpdf->fontPositionenTitel[2]);
				$fpdf->MultiCell8(0, 5, str_replace("%n%", "\n", $text), 0, 1);
				$fpdf->SetFont($fpdf->fontPositionen[0], $fpdf->fontPositionen[1], $fpdf->fontPositionen[2]);
				$fpdf->SetTextColorArray($fpdf->colorPositionen);
			}
			$fpdf->SetDrawColor(150, 150, 150);
			$fpdf->Line($fpdf->marginLeft , $fpdf->getY(), 210-$fpdf->marginRight , $fpdf->getY());
			$fpdf->SetDrawColor(0, 0, 0);
		}
		
		return $fpdf->PageNo();
	}
	
	public static function adviceAddBelowPosten($class, $args){
		$fpdf = $args[0];
		$Posten = $args[1];
		$lnHeight = null;
		if(isset($args[2]))
			$lnHeight = $args[2];

		$fpdf->SetDrawColor(150, 150, 150);
		$fpdf->Line($fpdf->marginLeft , $fpdf->getY() + 1, 210-$fpdf->marginRight , $fpdf->getY() + 1);
		$fpdf->SetDrawColor(0, 0, 0);
		if($lnHeight == null)
			$fpdf->ln();
		else
			$fpdf->ln($lnHeight);
	}

	public function getLabel(){
		return "Linie über Posten";
	}
	
	public function getAffectedClasses(){
		return array("mPostenGUI");
	}
	
	public function customizerDescription(){
		return "Dieser Customizer stellt einen Button im Posten zur Verfügung, mit dem vor dem Posten eine Linie eingefügt werden kann.";
	}

	public static function adviceAddPostenButton($class, Posten $Posten){
		$B = new Button("Linie vor Posten einfügen", "./interface/loadFrame.php?p=DBImage&id=CustomizerPostenAddLineGUI:::PostenAddLine:::image");
		$B->type("icon");
		$B->style("float:right;margin-right:10px;".($Posten->A("PostenAddLine") == "" ? "" : "display:none;"));
		
		$B->id("PostenAddLine{$Posten->getID()}");
		try {
			$c = new CustomizerPostenAddLabelGUI(false);
			$B->contextMenu("CustomizerPostenAddLabel", $Posten->getID(), "Überschrift hinzufügen");
		} catch(ClassNotFoundException $e) {
			$B->rmePCR("CustomizerPostenAddLine", "", "toggleAddLine", $Posten->getID(), "$('PostenAddLine{$Posten->getID()}').style.display = 'none'; $('PostenAddLineOK{$Posten->getID()}').style.display = '';");
		}
		
		$BOK = new Button("Linie vor Posten entfernen", "./interface/loadFrame.php?p=DBImage&id=CustomizerPostenAddLineGUI:::PostenAddLineOK:::image");
		$BOK->type("icon");
		$BOK->style("float:right;margin-right:10px;".($Posten->A("PostenAddLine") != "" ? "" : "display:none;"));
		$BOK->rmePCR("CustomizerPostenAddLine", "", "toggleAddLine", $Posten->getID(), "$('PostenAddLineOK{$Posten->getID()}').style.display = 'none'; $('PostenAddLine{$Posten->getID()}').style.display = '';");
		$BOK->id("PostenAddLineOK{$Posten->getID()}");
		return $B.$BOK;
	}
	
	public function customizeClass($class){
		switch(get_class($class)){
			case "GRLBM":
			case "GRLBMGUI":
				$class->CustomizerPostenAddLabelInsertOrigin = self::$AddLabelInsertOrigin;
			break;
		}
	}

	public function toggleAddLine($PostenID){
		$P = new Posten($PostenID, false);
		$P->recalcNetto = false;
		
		if($P->A("PostenAddLine") == "")
			$P->changeA("PostenAddLine", "-");
		else $P->changeA("PostenAddLine", "");

		$P->saveMe(true, true);
	}
	
	public function customizeNewAttributes($className, $Attributes){
	}
	
	public function customizeGUI($class, $GUI){
		switch(get_class($class)){
			case "PostenGUI":
				$GUI->type("PostenAddLine", "hidden");
			break;
		
			case "TempPostenGUI":
				if($class->A("TempPostenTypeClass") == "" OR $class->A("TempPostenTypeClass") == "Artikel"){
					$GUI->insertAttribute("above", "name", "TempPostenAddLine");
					#$GUI->setParser("TempPostenAddLine", "CustomizerPostenAddLineGUI::parserButton");
					$GUI->setLabel("TempPostenAddLine", "Überschrift");
				}
			break;
		}
	}

	#public static function parserButton($w, $E){
		#$B = new Button("Titel\nbearbeiten", "edit");
		#$B->popup("", "Titel bearbeiten", "CustomizerPostenAddLabel", "-1", "editLabel", array($E->getID(), "'TempPosten'"));

		#return $B;
	#}
	
	public function loadMe(){
		$this->A = new stdClass();

		if($this->ID == "PostenAddLineOK")
			$this->A->image = "image/png:::402:::iVBORw0KGgpcMFwwXDANSUhEUlwwXDBcMBJcMFwwXDASCAZcMFwwXDBWzo5XXDBcMFwwAXNSR0JcMK7OHOlcMFwwXDAGYktHRFww/1ww/1ww/6C9p5NcMFwwXDAJcEhZc1wwXDALE1wwXDALEwFcMJqcGFwwXDBcMAd0SU1FB9sDEA0mKrMpsqJcMFwwARJJREFUOMvt0rFLw0AUx/Hv3Vl0VEEqFDoUXFx0klI3B4csUlwnwT/AKV3179DFoZkcHZROFpeMbpbSRV0sgl0akKhbDeTeOaiouCRZ9Te94/E+3OMO/vOHoz4L77jnilwi4W5DKYD1g4vCyOX+pvpxI2CpgHP3a7Us6W+ttcWK73AoFNrooH5+1coF9ZuN9uz8nF9bWQZjwFrub255eXoO6t1eS2eFRMSvVcq4eIyMH3DxmFqljIj4XDBTWSFcJwIbTZS387VGeIobXFyTC9LGkJ4FuJMjxAraaFSphDbmvZ8VipK0M4xcJziborE4mzKMXCdESdrJ+2rVrrd6uDgzve0+BqPXpNMMB3vASOX8N1Vg4dv5ERgBvAHwul8tXCKvplpcMFwwXDBcMElFTkSuQmCC";


		if($this->ID == "PostenAddLine")
			$this->A->image = "image/png:::386:::iVBORw0KGgpcMFwwXDANSUhEUlwwXDBcMBJcMFwwXDASCAZcMFwwXDBWzo5XXDBcMFwwAXNSR0JcMK7OHOlcMFwwXDAGYktHRFww/1ww/1ww/6C9p5NcMFwwXDAJcEhZc1wwXDALE1wwXDALEwFcMJqcGFwwXDBcMAd0SU1FB9sDEA0mGQz507RcMFwwAQJJREFUOMvt0iFIA1Ecx/Hv/90QTJMDwZVrbmFh5fSSURCrCEY1nW24wdlXHKhVk9rFYNDiwkCWLOsHQxZWBGE4Md3+hqegWO6u6i+99w8f3nu/B//5w5Gvxer5o+ZF7neXRFwwVo7vciMPjXX5cVwiYDGHE/+6WppsX3CaJIRTBSPgOJxd7rAH4GRB3FwiYVCDreWImbker2/4lTUW+jfcmrRQMiUsezCeQNU9ZDyBsmfnXDCpIVXwSxH1wPZSDxS/FKGfNaWGjIFu3KbVsc/a6gjduI0xGaH3F64HIygo9J4OKCgMRnaetTVv84iTWZcNVRCxyFWTfWAoGf+NB8x/2z8DQ4APrQtLnJ02X65cMFwwXDBcMElFTkSuQmCC";

	}

	public function A($val){
		return $this->A->$val;
	}

	

	public function tableUpdatesXML(){
		$xml = '<phynx>
	<collectionOf>Patch</collectionOf>
	<entry>

		<id>6</id>
		<attribute name="PatchID"><![CDATA[7]]></attribute>
		<attribute name="PatchType"><![CDATA[mysql]]></attribute>
		<attribute name="PatchDescription"><![CDATA['.$this->getLabel().']]></attribute>
		<attribute name="PatchValue"><![CDATA[ALTER TABLE `Posten` ADD `PostenAddLine` VARCHAR(50) NOT NULL COMMENT \'CustomizerColumn\'
ALTER TABLE `Posten` CHANGE `PostenAddLine` `PostenAddLine` TEXT CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT \'CustomizerColumn\'
ALTER TABLE `VertragPosten` ADD `VertragPostenAddLine` TEXT NOT NULL COMMENT \'CustomizerColumn\'
ALTER TABLE `TempPosten` ADD `TempPostenAddLine` TEXT NOT NULL COMMENT \'CustomizerColumn\']]></attribute>
		<attribute name="PatchExecuted"><![CDATA[0]]></attribute>
		<attribute name="PatchDate"><![CDATA[1548741617]]></attribute>
		<attribute name="PatchApplication"><![CDATA[open3A]]></attribute>

		<attribute name="PatchNummer"><![CDATA[1000024]]></attribute>
		
	</entry>
	
</phynx>';
		
		return $xml;
	}
}
?>
