<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class CustomizerPakete implements iFileBrowser, iCustomizer {
	private static $Customizers = null;
	private $cs = array(
			"CustomizerPostenAlternative.class.php",
			"CustomizerPostenOptionalGUI.class.php",
			"CustomizerPostenAddLineGUI.class.php",
			"CustomizerPostenNewPageGUI.class.php",
			"CustomizerPostenSortGUI.class.php",
			"CustomizerRabatt.class.php",
			"CustomizerPostenAddLabelGUI.class.php",
			"CustomizerDoubleContactGUI.class.php",
			"CustomizerBelegKommentar.class.php",
			"CustomizerBelegRunden.class.php",
			"CustomizerTeilzahlungen.class.php",
			"CustomizerAuftragNotiz.class.php",
			"CustomizerPostenTextGUI.class.php",
			"CustomizerAuftragVorlage.class.php",
			"CustomizerPostenAddPositionGUI.class.php",
			"CustomizerMonatsrechnungGUI.class.php",
			"CustomizerMonatsrechnungBestaetigung.class.php",
			"CustomizerArtikelBettensteuerGUI.class.php",
			"CustomizerBelegBestaetigung.class.php",
			"CustomizerBelegServiceGUI.class.php",
			"CustomizerPostenZwischensummeGUI.class.php",
			"CustomizerPostenZwischensummeZuschlagGUI.class.php",
			"CustomizerAdresseKundeVon.class.php",
			"CustomizerArtikelAbrechungszeitraum.class.php",
			"CustomizerAuftragBenutzer.class.php",
			"CustomizerAuftragBelegkopieGUI.class.php",
			"CustomizerMonatsrechnungLieferschein.class.php",
			"CustomizerBelegStornorechnung.class.php",
			"CustomizerKundeKeineMwSt.class.php",
			"CustomizerBelegBestelldaten.class.php",
			"CustomizerZahlungszielGUI.class.php",
			"CustomizerService.class.php",
			"CustomizerBelegBetreff.class.php",
			"CustomizerAuftragMandant.class.php",
			"CustomizerTextbausteinStammdaten.class.php",
			"CustomizerProvisionen.class.php",
			"CustomizerBelegEAN.class.php",
			"CustomizerBelegAuftrag.class.php",
			"CustomizerBelegProformaRechnung.class.php",
			"CustomizerBelegVersand.class.php",
			"CustomizerStandardversandGUI.class.php",
			"CustomizerArtikelSetup.class.php",
			"CustomizerArtikelVertraegeGUI.class.php",
			"CustomizerPostenAddDescription.class.php",
			"CustomizerAdresseAuftragGUI.class.php",
			"CustomizerAdresseKuerzel.class.php",
			"CustomizerVertragBemerkung.class.php",
			"CustomizerAuftragMarkArtikelGUI.class.php",
			"CustomizerAuftragMarkPayedGUI.class.php",
			"CustomizerArtikelMindestmenge.class.php",
			"CustomizerAuftragStatus.class.php",
			"CustomizerPostenNotizGUI.class.php",
			"CustomizerBelegDruckenSperrt.class.php",
			"CustomizerBelegLagerbestand.class.php",
			"CustomizerAdresseAuftraegeGUI.class.php",
			"CustomizerKundeBruttoNetto.class.php",
			"CustomizerMPOverview.class.php",
			"CustomizerPostenInsertGUI.class.php",
			"CustomizerBelegRetoureGUI.class.php",
			"CustomizerArtikelNummern.class.php",
			"CustomizerArtikelBelegeGUI.class.php",
			"CustomizerZeiterfassungLohnAuszahlenGUI.class.php",
			"CustomizerArtikel5Nachkomma.class.php",
			"CustomizerPostenNaturalrabattGUI.class.php",
			"CustomizerPostenCopyGUI.class.php",
			"CustomizerPostenStueckliste.class.php",
			"CustomizerPostenStuecklistePosten.class.php",
			"CustomizerPostenMenge2.class.php",
			"CustomizerBelegOrigUndKopieGUI.class.php",
			"CustomizerBelegAttachmentsMerge.class.php",
			"CustomizerBelegFreigebenGUI.class.php",
			"CustomizerBelegLeihschein.class.php",
			"CustomizerAuftragStatusGesperrt.class.php",
			"CustomizerBelegMandant.class.php",
			"CustomizerAuftragMarkStornoGUI.class.php",
			"CustomizerBelegZusammenfassung.class.php",
			"CustomizerTextbausteinKunde.class.php",
			"CustomizerPostenKalkulation.class.php",
			"CustomizerPostenRunden.class.php",
			"CustomizerBelegNewPage.class.php",
			"CustomizerVertragInfo.class.php",
			"CustomizerBelegPauschal.class.php",
			"CustomizerBelegVerschiebenGUI.class.php",
			"CustomizerArtikelZolltarifnummer.class.php",
			"CustomizerKundeSEPATyp.class.php",
			"CustomizerBelegVersionGUI.class.php",
			"CustomizerArtikelPreisHistorieGUI.class.php",
			"CustomizerBelegUebersicht.class.php",
			"CustomizerPostenHidePriceGUI.class.php",
			"CustomizerAdresseOldSchool.class.php",
			"CustomizerBelegPackliste.class.php",
			"CustomizerKundeAufschlag.class.php",
			"CustomizerAuftragStatusAbgeschlossen.class.php",
			"CustomizerVertragEMailTB.class.php",
			"CustomizerBelegAttachmentsAlways.class.php",
			"CustomizerBelegP13BBelegGUI.class.php",
			"CustomizerPostenChangesGUI.class.php",
			"CustomizerBelegKuendigungGUI.class.php",
			"CustomizerPostenProzent.class.php",
			"CustomizerPostenStaffelpreisePosten.class.php",
			"CustomizerPostenImageAbove.class.php",
			"CustomizerBelegKundenpreis.class.php",
			"CustomizerBelegOhneSumme.class.php",
			"CustomizerKundePayedNotification.class.php",
			"CustomizerBelegLagerAusbuchenGUI.class.php",
			"CustomizerBelegLagerAusbuchen2GUI.class.php",
			"CustomizerBelegSummeNetto.class.php",
			"CustomizerBelegNummerNeuGUI.class.php",
			"CustomizerPostenLagerGUI.class.php",
			"CustomizerArtikelPfandGUI.class.php",
			"CustomizerBeleg2teWaehrung.class.php",
			"CustomizerBelegEntwurfGUI.class.php",
			"CustomizerVertragSEPADataGUI.class.php",
			"CustomizerKundeCustomFieldsGUI.class.php",
			"CustomizerBelegBuchungsstempel.class.php",
			"CustomizerBelegTBO2.class.php",
			"CustomizerPostenPercentGUI.class.php");
	
	public function getLabel(){
		return "Pakete";
	}
	
	function __construct(){
		if(self::$Customizers !== null)
			return;
		
		$root = Util::getRootPath();
		
		if(file_exists($root."/specifics/CustomizerPostenAddLabelGUI.class.php")
			OR file_exists($root."/customizer/CustomizerPostenAddLabelGUI.class.php"))
			unset($this->cs[array_search("CustomizerPostenAddLineGUI.class.php", $this->cs)]);
		
		if(file_exists($root."/specifics/CustomizerPostenOptionalGUI.class.php")
			OR file_exists($root."/customizer/CustomizerPostenOptionalGUI.class.php"))
			unset($this->cs[array_search("CustomizerPostenAlternative.class.php", $this->cs)]);
		
		$filesSpecifics = array();
		$filesCustomizer = array();
		
		$dir = new DirectoryIterator(dirname(__FILE__));
		foreach ($dir as $file) {
			if(strpos($file->getFilename(), "CustomizerAuto") === 0)
				$this->cs[] = $file->getFilename();
			
			if(strpos($file->getFilename(), "Customizer") === 0)
				$filesCustomizer[$file->getFilename()] = true;
		}
		
		$dir = new DirectoryIterator($root."/specifics/");
		foreach ($dir as $file) {
			if(strpos($file->getFilename(), "CustomizerAuto") === 0)
				$this->cs[] = $file->getFilename();
			
			if(strpos($file->getFilename(), "Customizer") === 0)
				$filesSpecifics[$file->getFilename()] = true;
		}
					
		self::$Customizers = array();
		foreach($this->cs AS $c){
			if(!isset($filesSpecifics[$c]) AND !isset($filesCustomizer[$c]))
				continue;
			
			$class = str_replace(".class.php", "", $c);
			
			self::$Customizers[] = new $class();
		}
	}
	
	public function getAffectedClasses(){
		$g = array();
		foreach(self::$Customizers as $v)
			$g = array_merge($g, $v->getAffectedClasses());
		return $g;
	}
	
	public function customizerDescription(){
		$t = "Dieser Customizer fasst mehrere einzelne Customizer zusammen:<ul>";
		
		foreach(self::$Customizers AS $c)
			$t .= "<li>".$c->getLabel()."</li>";
		
		$t .= "</ul>";
		return $t;
	}
	
	public function customizeClass($class){
		foreach(self::$Customizers as $v)
			$v->customizeClass($class);
	}
	
	public function customizeNewAttributes($className, $Attributes){
		foreach(self::$Customizers as $v)
			$v->customizeNewAttributes($className, $Attributes);
	}
	
	public function customizeGUI($class, $GUI){
		foreach(self::$Customizers as $v)
			$v->customizeGUI($class, $GUI);
	}
	
	public function tableUpdatesXML(){
		$xml = '';
		
		foreach(self::$Customizers as $v){
			$cxml = $v->tableUpdatesXML();
			
			$cxml = preg_replace("/<phynx>[\s]*<collectionOf>Patch<\/collectionOf>/", "", $cxml);
			$cxml = preg_replace("/<\/phynx>/", "", $cxml);
			
			$xml .= $cxml;
		}
		
		$xml = "<phynx><collectionOf>Patch</collectionOf>$xml</phynx>";
		
		#echo htmlentities($xml);
		return $xml;
	}
}
?>
